/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.encrypiton.api;

import de.adorsys.datasafe.encrypiton.api.types.keystore.AuthPathEncryptionSecretKey;
import de.adorsys.datasafe.encrypiton.api.types.keystore.KeyID;
import de.adorsys.datasafe.encrypiton.api.types.keystore.SecretKeyIDWithKey;
import de.adorsys.datasafe.types.api.shared.BaseMockitoTest;
import javax.crypto.SecretKey;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;

class PathEncryptionSecretKeyTest
extends BaseMockitoTest {
    @Mock
    private KeyID secretKeyId;
    @Mock
    private SecretKey secretKey;
    @Mock
    private KeyID counterKeyId;
    @Mock
    private SecretKey counterSecretKey;

    PathEncryptionSecretKeyTest() {
    }

    @Test
    void validateAllOk() {
        AuthPathEncryptionSecretKey key = new AuthPathEncryptionSecretKey(new SecretKeyIDWithKey(this.secretKeyId, this.secretKey), new SecretKeyIDWithKey(this.counterKeyId, this.counterSecretKey));
        Assertions.assertThat((Object)key.getSecretKey().getSecretKey()).isEqualTo((Object)this.secretKey);
        Assertions.assertThat((Object)key.getCounterSecretKey().getSecretKey()).isEqualTo((Object)this.counterSecretKey);
    }

    @Test
    void validateNullSecretKeyImpossible() {
        org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, () -> new AuthPathEncryptionSecretKey(null, new SecretKeyIDWithKey(this.counterKeyId, this.counterSecretKey)));
    }

    @Test
    void validateNullCounterKeyImpossible() {
        org.junit.jupiter.api.Assertions.assertThrows(NullPointerException.class, () -> new AuthPathEncryptionSecretKey(new SecretKeyIDWithKey(this.secretKeyId, this.secretKey), null));
    }
}

