/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.business.impl.e2e;

import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import dagger.Lazy;
import de.adorsys.datasafe.business.impl.service.DaggerDefaultDatasafeServices;
import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.profile.keys.StorageKeyStoreOperations;
import de.adorsys.datasafe.directory.api.types.CreateUserPrivateProfile;
import de.adorsys.datasafe.directory.api.types.CreateUserPublicProfile;
import de.adorsys.datasafe.directory.api.types.StorageCredentials;
import de.adorsys.datasafe.directory.api.types.UserPrivateProfile;
import de.adorsys.datasafe.directory.impl.profile.config.DefaultDFSConfig;
import de.adorsys.datasafe.directory.impl.profile.dfs.BucketAccessServiceImpl;
import de.adorsys.datasafe.directory.impl.profile.dfs.BucketAccessServiceImplRuntimeDelegatable;
import de.adorsys.datasafe.directory.impl.profile.dfs.RegexAccessServiceWithStorageCredentialsImpl;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.privatestore.api.PasswordClearingInputStream;
import de.adorsys.datasafe.privatestore.api.PasswordClearingOutputStream;
import de.adorsys.datasafe.storage.api.RegexDelegatingStorage;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.storage.api.UriBasedAuthStorageService;
import de.adorsys.datasafe.storage.impl.s3.S3ClientFactory;
import de.adorsys.datasafe.storage.impl.s3.S3StorageService;
import de.adorsys.datasafe.types.api.actions.ListRequest;
import de.adorsys.datasafe.types.api.actions.ReadRequest;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.context.BaseOverridesRegistry;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.BasePublicResource;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.PublicResource;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import de.adorsys.datasafe.types.api.resource.StorageIdentifier;
import de.adorsys.datasafe.types.api.shared.BaseMockitoTest;
import de.adorsys.datasafe.types.api.shared.DockerUtil;
import de.adorsys.datasafe.types.api.types.ReadKeyPassword;
import de.adorsys.datasafe.types.api.types.ReadStorePassword;
import de.adorsys.datasafe.types.api.utils.ExecutorServiceUtil;
import de.adorsys.datasafe.types.api.utils.ReadKeyPasswordTestFactory;
import java.io.InputStream;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.io.Streams;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.shaded.com.google.common.collect.ImmutableMap;

class MultiDFSFunctionalityTest
extends BaseMockitoTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MultiDFSFunctionalityTest.class);
    private static final String REGION = "eu-central-1";
    private static final String LOCALHOST = DockerUtil.getDockerUri((String)"http://127.0.0.1");
    private static final String CREDENTIALS = "credentialsbucket";
    private static final String KEYSTORE = "keystorebucket";
    private static final String FILES_ONE = "filesonebucket";
    private static final String FILES_TWO = "filestwobucket";
    private static final String INBOX = "inboxbucket";
    private static final ExecutorService EXECUTOR = ExecutorServiceUtil.submitterExecutesOnStarvationExecutingService((int)5, (int)5);
    private static Map<String, GenericContainer> minios = new HashMap<String, GenericContainer>();
    private static Map<String, String> endpointsByHost = new HashMap<String, String>();
    private static Map<String, String> endpointsByHostNoBucket = new HashMap<String, String>();
    private DefaultDatasafeServices datasafeServices;

    MultiDFSFunctionalityTest() {
    }

    @BeforeAll
    static void initDistributedMinios() {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Stream.of(CREDENTIALS, KEYSTORE, FILES_ONE, FILES_TWO, INBOX).forEach(it -> {
            GenericContainer minio = new GenericContainer("minio/minio").withExposedPorts(new Integer[]{9000}).withEnv("MINIO_ACCESS_KEY", MultiDFSFunctionalityTest.accessKey(it)).withEnv("MINIO_SECRET_KEY", MultiDFSFunctionalityTest.secretKey(it)).withCommand("server /data").waitingFor(Wait.defaultWaitStrategy());
            minio.start();
            minios.put((String)it, minio);
            String endpoint = LOCALHOST + ":" + minio.getFirstMappedPort() + "/";
            log.info("Minio `{}` with endpoint `{}` and keys `{}`/`{}` has started", new Object[]{it, endpoint, MultiDFSFunctionalityTest.accessKey(it), MultiDFSFunctionalityTest.secretKey(it)});
            endpointsByHost.put((String)it, endpoint + REGION + "/" + it + "/");
            endpointsByHostNoBucket.put((String)it, endpoint);
            AmazonS3 client = S3ClientFactory.getClient((String)endpoint, (String)REGION, (String)MultiDFSFunctionalityTest.accessKey(it), (String)MultiDFSFunctionalityTest.secretKey(it));
            client.createBucket(it);
        });
    }

    @AfterAll
    static void stopAll() {
        minios.forEach((id, minio) -> minio.stop());
    }

    @BeforeEach
    void initDatasafe() {
        S3StorageService directoryStorage = new S3StorageService(S3ClientFactory.getClient((String)endpointsByHostNoBucket.get(CREDENTIALS), (String)REGION, (String)MultiDFSFunctionalityTest.accessKey(CREDENTIALS), (String)MultiDFSFunctionalityTest.secretKey(CREDENTIALS)), CREDENTIALS, EXECUTOR);
        BaseOverridesRegistry registry = new BaseOverridesRegistry();
        this.datasafeServices = DaggerDefaultDatasafeServices.builder().config((DFSConfig)new DefaultDFSConfig(endpointsByHost.get(CREDENTIALS), new ReadStorePassword("PAZZWORT"))).overridesRegistry((OverridesRegistry)registry).storage((StorageService)new RegexDelegatingStorage((Map)ImmutableMap.builder().put((Object)Pattern.compile(endpointsByHost.get(CREDENTIALS) + ".+"), (Object)directoryStorage).put((Object)Pattern.compile(LOCALHOST + ".+"), (Object)new UriBasedAuthStorageService(acc -> new S3StorageService(S3ClientFactory.getClient((String)acc.getEndpoint(), (String)acc.getRegion(), (String)acc.getAccessKey(), (String)acc.getSecretKey()), acc.getBucketName(), EXECUTOR))).build())).build();
        BucketAccessServiceImplRuntimeDelegatable.overrideWith((OverridesRegistry)registry, args -> new WithCredentialProvider(args.getStorageKeyStoreOperations()));
    }

    @Test
    void testWriteToPrivateListPrivateReadPrivate() {
        UserIDAuth john = new UserIDAuth("john", ReadKeyPasswordTestFactory.getForString((String)"my-passwd"));
        this.registerUser(john);
        this.validateBasicOperationsAndContent(john);
        this.deregisterAndValidateEmpty(john);
    }

    @Test
    void testWriteToPrivateListPrivateReadPrivateWithPasswordChange() {
        UserIDAuth john = new UserIDAuth("john", ReadKeyPasswordTestFactory.getForString((String)"my-passwd"));
        this.registerUser(john);
        this.validateBasicOperationsAndContent(john);
        ReadKeyPassword newPasswd = ReadKeyPasswordTestFactory.getForString((String)"ANOTHER");
        this.datasafeServices.userProfile().updateReadKeyPassword(john, newPasswd);
        UserIDAuth newJohn = new UserIDAuth("john", newPasswd);
        org.junit.jupiter.api.Assertions.assertThrows(UnrecoverableKeyException.class, () -> this.doBasicOperations(john));
        this.validateBasicOperationsAndContent(newJohn);
        this.deregisterAndValidateEmpty(newJohn);
    }

    private void doBasicOperations(UserIDAuth john) {
        this.writeToPrivate(john, MultiDFSFunctionalityTest.id(FILES_ONE), "path/to/file1.txt", "Hello 1");
        this.writeToPrivate(john, MultiDFSFunctionalityTest.id(FILES_TWO), "path/to/file2.txt", "Hello 2");
        AbsoluteLocation<ResolvedResource> fileOne = this.getFirstFileInPrivate(john, MultiDFSFunctionalityTest.id(FILES_ONE), "path/to/file1.txt");
        AbsoluteLocation<ResolvedResource> fileTwo = this.getFirstFileInPrivate(john, MultiDFSFunctionalityTest.id(FILES_TWO), "path/to/file2.txt");
        Assertions.assertThat((String)this.readFromPrivate(john, fileOne)).isEqualTo((Object)"Hello 1");
        Assertions.assertThat((String)this.readFromPrivate(john, fileTwo)).isEqualTo((Object)"Hello 2");
        Assertions.assertThat((String)this.readFromPrivate(john, MultiDFSFunctionalityTest.id(FILES_ONE), "path/to/file1.txt")).isEqualTo((Object)"Hello 1");
        Assertions.assertThat((String)this.readFromPrivate(john, MultiDFSFunctionalityTest.id(FILES_TWO), "path/to/file2.txt")).isEqualTo((Object)"Hello 2");
    }

    private void validateBasicOperationsAndContent(UserIDAuth john) {
        this.doBasicOperations(john);
        Assertions.assertThat(this.listInBucket(FILES_ONE)).hasSize(1);
        Assertions.assertThat(this.listInBucket(FILES_TWO)).hasSize(1);
        Assertions.assertThat(this.listInBucket(KEYSTORE)).hasSize(1);
        Assertions.assertThat(this.listInBucket(CREDENTIALS)).containsExactlyInAnyOrder((Object[])new String[]{"profiles/private/john", "profiles/public/john", "pubkeys", "storagecreds"});
    }

    private void deregisterAndValidateEmpty(UserIDAuth john) {
        this.datasafeServices.userProfile().deregister(john);
        Assertions.assertThat(this.listInBucket(FILES_ONE)).isEmpty();
        Assertions.assertThat(this.listInBucket(FILES_TWO)).isEmpty();
        Assertions.assertThat(this.listInBucket(KEYSTORE)).isEmpty();
        Assertions.assertThat(this.listInBucket(CREDENTIALS)).isEmpty();
    }

    private void registerUser(UserIDAuth auth) {
        String inboxLocation = endpointsByHost.get(INBOX) + "inbox/";
        String pubKeysLocation = endpointsByHost.get(CREDENTIALS) + "pubkeys";
        this.datasafeServices.userProfile().registerPublic(CreateUserPublicProfile.builder().id(auth.getUserID()).inbox(BasePublicResource.forAbsolutePublic((String)inboxLocation)).publicKeys(BasePublicResource.forAbsolutePublic((String)pubKeysLocation)).build());
        this.datasafeServices.userProfile().registerPrivate(CreateUserPrivateProfile.builder().id(auth).storageCredentialsKeystore(BasePrivateResource.forAbsolutePrivate((String)(endpointsByHost.get(CREDENTIALS) + "storagecreds"))).inboxWithWriteAccess(BasePrivateResource.forAbsolutePrivate((String)inboxLocation)).keystore(BasePrivateResource.forAbsolutePrivate((String)(endpointsByHost.get(KEYSTORE) + "keystore"))).privateStorage(BasePrivateResource.forAbsolutePrivate((String)(endpointsByHost.get(FILES_ONE) + "private/"))).associatedResources(Collections.emptyList()).publishPubKeysTo(BasePublicResource.forAbsolutePublic((String)pubKeysLocation)).build());
        this.datasafeServices.userProfile().createStorageKeystore(auth);
        Stream.of(KEYSTORE, FILES_ONE, FILES_TWO, INBOX).forEach(it -> {
            String endpoint = endpointsByHost.get(it);
            UserPrivateProfile profile = this.datasafeServices.userProfile().privateProfile(auth);
            profile.getPrivateStorage().put(MultiDFSFunctionalityTest.id(it), new AbsoluteLocation((ResourceLocation)BasePrivateResource.forPrivate((String)(endpoint + "/"))));
            this.datasafeServices.userProfile().registerStorageCredentials(auth, MultiDFSFunctionalityTest.id(it), new StorageCredentials(MultiDFSFunctionalityTest.accessKey(it), MultiDFSFunctionalityTest.secretKey(it)));
            this.datasafeServices.userProfile().updatePrivateProfile(auth, profile);
        });
        UserPrivateProfile profile = this.datasafeServices.userProfile().privateProfile(auth);
        this.datasafeServices.userProfile().createDocumentKeystore(auth, profile);
    }

    private List<String> listInBucket(String bucket) {
        return S3ClientFactory.getClient((String)endpointsByHostNoBucket.get(bucket), (String)REGION, (String)MultiDFSFunctionalityTest.accessKey(bucket), (String)MultiDFSFunctionalityTest.secretKey(bucket)).listObjects(bucket, "").getObjectSummaries().stream().map(S3ObjectSummary::getKey).collect(Collectors.toList());
    }

    private void writeToPrivate(UserIDAuth user, StorageIdentifier id, String path, String data) {
        try (PasswordClearingOutputStream os = this.datasafeServices.privateService().write(WriteRequest.forPrivate((Object)user, (StorageIdentifier)id, (String)path));){
            os.write(data.getBytes());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readFromPrivate(UserIDAuth user, StorageIdentifier id, String path) {
        try (PasswordClearingInputStream is = this.datasafeServices.privateService().read(ReadRequest.forPrivate((Object)user, (StorageIdentifier)id, (String)path));){
            String string = new String(Streams.readAll((InputStream)is));
            return string;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readFromPrivate(UserIDAuth user, AbsoluteLocation<ResolvedResource> location) {
        try (PasswordClearingInputStream is = this.datasafeServices.privateService().read(ReadRequest.forPrivate((Object)user, (PrivateResource)((ResolvedResource)location.getResource()).asPrivate()));){
            String string = new String(Streams.readAll((InputStream)is));
            return string;
        }
    }

    private AbsoluteLocation<ResolvedResource> getFirstFileInPrivate(UserIDAuth user, StorageIdentifier id, String path) {
        return (AbsoluteLocation)this.datasafeServices.privateService().list(ListRequest.forPrivate((Object)user, (StorageIdentifier)id, (String)path)).findFirst().orElseThrow(() -> new IllegalArgumentException("Not found"));
    }

    private static StorageIdentifier id(String endpointId) {
        String endpoint = endpointsByHost.get(endpointId);
        return new StorageIdentifier(endpoint + ".+");
    }

    private static String accessKey(String bucket) {
        return "ACCESS-" + bucket;
    }

    private static String secretKey(String bucket) {
        return "SECRET-" + bucket;
    }

    private static class WithCredentialProvider
    extends BucketAccessServiceImpl {
        private final RegexAccessServiceWithStorageCredentialsImpl delegate;

        private WithCredentialProvider(Lazy<StorageKeyStoreOperations> storageKeyStoreOperations) {
            super(null);
            this.delegate = new RegexAccessServiceWithStorageCredentialsImpl(storageKeyStoreOperations);
        }

        @Generated
        public AbsoluteLocation<PrivateResource> privateAccessFor(UserIDAuth user, PrivateResource resource) {
            return this.delegate.privateAccessFor(user, resource);
        }

        @Generated
        public AbsoluteLocation<PublicResource> publicAccessFor(UserID user, PublicResource resource) {
            return this.delegate.publicAccessFor(user, resource);
        }

        @Generated
        public AbsoluteLocation withSystemAccess(AbsoluteLocation resource) {
            return this.delegate.withSystemAccess(resource);
        }
    }
}

