/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.business.impl.e2e;

import de.adorsys.datasafe.business.impl.e2e.BaseE2ETest;
import de.adorsys.datasafe.business.impl.e2e.DatasafeServicesProvider;
import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.privatestore.api.PasswordClearingInputStream;
import de.adorsys.datasafe.privatestore.api.PasswordClearingOutputStream;
import de.adorsys.datasafe.privatestore.api.PasswordClearingStream;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.teststorage.WithStorageProvider;
import de.adorsys.datasafe.types.api.actions.ListRequest;
import de.adorsys.datasafe.types.api.actions.ReadRequest;
import de.adorsys.datasafe.types.api.actions.RemoveRequest;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.global.Version;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import de.adorsys.datasafe.types.api.resource.Uri;
import de.adorsys.datasafe.types.api.types.BaseTypePasswordStringException;
import de.adorsys.datasafe.types.api.types.ReadKeyPassword;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.UnrecoverableKeyException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.com.google.common.collect.ImmutableSet;

class BasicFunctionalityTest
extends BaseE2ETest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BasicFunctionalityTest.class);
    private static final int LARGE_SIZE = 10485860;
    private StorageService storage;
    private Uri location;

    BasicFunctionalityTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"fsOnly"})
    void testDFSPasswordClearance(WithStorageProvider.StorageDescriptor descriptor) {
        this.init(descriptor);
        UserID userJohn = new UserID("john");
        Assertions.assertThat((boolean)this.profileRetrievalService.userExists(userJohn)).isFalse();
        String passwordString = "a password that should be nullyfied";
        char[] password = passwordString.toCharArray();
        char[] copyOfPassword = Arrays.copyOf(password, password.length);
        ReadKeyPassword readKeyPassword = new ReadKeyPassword(password);
        this.john = this.registerUser(userJohn.getValue(), readKeyPassword);
        Assertions.assertThat((boolean)this.profileRetrievalService.userExists(userJohn)).isTrue();
        String filename = "root.txt";
        String content = "affe";
        log.info("1. write file");
        Assertions.assertThat((boolean)Arrays.equals(password, copyOfPassword)).isTrue();
        try (PasswordClearingOutputStream os = this.writeToPrivate.write(WriteRequest.forDefaultPrivate((Object)this.john, (String)filename));){
            os.write(content.getBytes());
        }
        Assertions.assertThat((boolean)Arrays.equals(password, copyOfPassword)).isFalse();
        System.arraycopy(copyOfPassword, 0, password, 0, copyOfPassword.length);
        this.john = new UserIDAuth(this.john.getUserID(), new ReadKeyPassword(password));
        log.info("password recovered");
        log.info("2. read file");
        var10_11 = null;
        try (PasswordClearingInputStream is = this.readFromPrivate.read(ReadRequest.forDefaultPrivate((Object)this.john, (String)filename));){
            Assertions.assertThat((InputStream)is).hasContent(content);
        }
        catch (Throwable throwable) {
            var10_11 = throwable;
            throw throwable;
        }
        Assertions.assertThat((boolean)Arrays.equals(password, copyOfPassword)).isFalse();
        System.arraycopy(copyOfPassword, 0, password, 0, copyOfPassword.length);
        this.john = new UserIDAuth(this.john.getUserID(), new ReadKeyPassword(password));
        log.info("password recovered");
        log.info("3. list files");
        var10_11 = null;
        try (PasswordClearingStream list = this.listPrivate.list(ListRequest.forDefaultPrivate((Object)this.john, (Uri)new Uri("/")));){
            org.junit.jupiter.api.Assertions.assertEquals((int)list.map(it -> ((ResolvedResource)it.getResource()).asPrivate().decryptedPath().asString()).collect(Collectors.toList()).size(), (int)1);
        }
        catch (Throwable throwable) {
            var10_11 = throwable;
            throw throwable;
        }
        Assertions.assertThat((boolean)Arrays.equals(password, copyOfPassword)).isFalse();
        System.arraycopy(copyOfPassword, 0, password, 0, copyOfPassword.length);
        this.john = new UserIDAuth(this.john.getUserID(), new ReadKeyPassword(password));
        log.info("password recovered");
        log.info("4. remove file");
        this.removeFromPrivate.remove(RemoveRequest.forDefaultPrivate((Object)this.john, (Uri)new Uri(filename)));
        Assertions.assertThat((boolean)Arrays.equals(password, copyOfPassword)).isFalse();
        org.junit.jupiter.api.Assertions.assertThrows(BaseTypePasswordStringException.class, () -> this.john.getReadKeyPassword().getValue());
        org.junit.jupiter.api.Assertions.assertThrows(UnrecoverableKeyException.class, () -> this.profileRemovalService.deregister(this.john));
        System.arraycopy(copyOfPassword, 0, password, 0, copyOfPassword.length);
        this.john = new UserIDAuth(this.john.getUserID(), new ReadKeyPassword(password));
        log.info("password recovered");
        log.info("5. remove user");
        this.profileRemovalService.deregister(this.john);
        Assertions.assertThat((boolean)Arrays.equals(password, copyOfPassword)).isFalse();
        Assertions.assertThat((boolean)this.profileRetrievalService.userExists(userJohn)).isFalse();
    }

    @ParameterizedTest
    @MethodSource(value={"allStorages"})
    void testDFSBasedProfileStorage(WithStorageProvider.StorageDescriptor descriptor) {
        this.init(descriptor);
        UserID userJohn = new UserID("john");
        Assertions.assertThat((boolean)this.profileRetrievalService.userExists(userJohn)).isFalse();
        this.john = this.registerUser(userJohn.getValue());
        Assertions.assertThat((boolean)this.profileRetrievalService.userExists(userJohn)).isTrue();
        Assertions.assertThat((String)this.profileRetrievalService.privateProfile(this.john).getAppVersion().getId()).isEqualTo((Object)Version.current().getId());
        Assertions.assertThat((String)this.profileRetrievalService.publicProfile(this.john.getUserID()).getAppVersion().getId()).isEqualTo((Object)Version.current().getId());
        this.profileRemovalService.deregister(this.john);
        Assertions.assertThat((boolean)this.profileRetrievalService.userExists(userJohn)).isFalse();
    }

    @ParameterizedTest
    @MethodSource(value={"fsOnly"})
    void testUserIsRemovedWithFiles(WithStorageProvider.StorageDescriptor descriptor) {
        this.init(descriptor);
        UserID userJohn = new UserID("john");
        this.john = this.registerUser(userJohn.getValue());
        this.writeDataToPrivate(this.john, "root.txt", "Hello here 1");
        this.writeDataToPrivate(this.john, "some/some.txt", "Hello here 1");
        this.writeDataToPrivate(this.john, "some/another_one.txt", "Hello here 1");
        this.writeDataToPrivate(this.john, "some/other/other.txt", "Hello here 1");
        this.writeDataToPrivate(this.john, "different/data.txt", "Hello here 1");
        this.profileRemovalService.deregister(this.john);
        this.assertRootDirIsEmpty(descriptor);
    }

    @ParameterizedTest
    @MethodSource(value={"allStorages"})
    void testMultipleRecipientsSharing(WithStorageProvider.StorageDescriptor descriptor) {
        this.init(descriptor);
        UserIDAuth john = this.registerUser("john");
        UserIDAuth jane = this.registerUser("jane");
        UserIDAuth jamie = this.registerUser("jamie");
        String multiShareFile = "multishare.txt";
        try (OutputStream os = this.writeToInbox.write(WriteRequest.forDefaultPublic((Object)ImmutableSet.of((Object)john.getUserID(), (Object)jane.getUserID(), (Object)jamie.getUserID()), (String)multiShareFile));){
            os.write("Hello here 1".getBytes());
        }
        Assertions.assertThat((InputStream)this.readFromInbox.read(ReadRequest.forDefaultPrivate((Object)john, (String)multiShareFile))).hasContent("Hello here 1");
        Assertions.assertThat((InputStream)this.readFromInbox.read(ReadRequest.forDefaultPrivate((Object)jane, (String)multiShareFile))).hasContent("Hello here 1");
        Assertions.assertThat((InputStream)this.readFromInbox.read(ReadRequest.forDefaultPrivate((Object)jamie, (String)multiShareFile))).hasContent("Hello here 1");
    }

    @ParameterizedTest
    @MethodSource(value={"allStorages"})
    void testMultipleRecipientsSharingLargeChunk(WithStorageProvider.StorageDescriptor descriptor) {
        this.init(descriptor);
        UserIDAuth john = this.registerUser("john");
        UserIDAuth jane = this.registerUser("jane");
        UserIDAuth jamie = this.registerUser("jamie");
        String multiShareFile = "multishare.txt";
        byte[] bytes = new byte[10485860];
        ThreadLocalRandom.current().nextBytes(bytes);
        try (OutputStream os = this.writeToInbox.write(WriteRequest.forDefaultPublic((Object)ImmutableSet.of((Object)john.getUserID(), (Object)jane.getUserID(), (Object)jamie.getUserID()), (String)multiShareFile));){
            os.write(bytes);
        }
        Assertions.assertThat((InputStream)this.readFromInbox.read(ReadRequest.forDefaultPrivate((Object)john, (String)multiShareFile))).hasSameContentAs((InputStream)new ByteArrayInputStream(bytes));
        Assertions.assertThat((InputStream)this.readFromInbox.read(ReadRequest.forDefaultPrivate((Object)jane, (String)multiShareFile))).hasSameContentAs((InputStream)new ByteArrayInputStream(bytes));
        Assertions.assertThat((InputStream)this.readFromInbox.read(ReadRequest.forDefaultPrivate((Object)jamie, (String)multiShareFile))).hasSameContentAs((InputStream)new ByteArrayInputStream(bytes));
    }

    @ParameterizedTest
    @MethodSource(value={"allStorages"})
    void testWriteToPrivateListPrivateReadPrivateAndSendToAndReadFromInbox(WithStorageProvider.StorageDescriptor descriptor) {
        this.init(descriptor);
        this.registerJohnAndJane();
        this.writeDataToPrivate(this.jane, "folder1/secret.txt", "Hello here 1");
        AbsoluteLocation<ResolvedResource> privateJane = this.getFirstFileInPrivate(this.jane);
        String privateContentJane = this.readPrivateUsingPrivateKey(this.jane, ((ResolvedResource)privateJane.getResource()).asPrivate());
        this.sendToInbox(this.john.getUserID(), "hello.txt", privateContentJane);
        AbsoluteLocation<ResolvedResource> inboxJohn = this.getFirstFileInInbox(this.john);
        String result = this.readInboxUsingPrivateKey(this.john, ((ResolvedResource)inboxJohn.getResource()).asPrivate());
        Assertions.assertThat((String)result).isEqualTo((Object)"Hello here 1");
        Assertions.assertThat((Object)((ResolvedResource)privateJane.getResource()).asPrivate().decryptedPath()).extracting(Uri::toASCIIString).isEqualTo((Object)"folder1/secret.txt");
        Assertions.assertThat((Object)((ResolvedResource)privateJane.getResource()).asPrivate().encryptedPath()).extracting(Uri::toASCIIString).isNotEqualTo((Object)"folder1/secret.txt");
        this.validateInboxStructAndEncryption(inboxJohn);
        this.validatePrivateStructAndEncryption(privateJane);
        this.removeFromPrivate(this.jane, ((ResolvedResource)privateJane.getResource()).asPrivate());
        this.removeFromInbox(this.john, ((ResolvedResource)inboxJohn.getResource()).asPrivate());
    }

    @ParameterizedTest
    @MethodSource(value={"allStorages"})
    void listingValidation(WithStorageProvider.StorageDescriptor descriptor) {
        this.init(descriptor);
        this.registerJohnAndJane();
        this.writeDataToPrivate(this.jane, "root.file", "Hello here 1");
        this.writeDataToPrivate(this.jane, "level1/file", "Hello here 1");
        this.writeDataToPrivate(this.jane, "level1/level2/file", "Hello here 1");
        this.assertPrivateSpaceList(this.jane, "", "root.file", "level1/file", "level1/level2/file");
        this.assertPrivateSpaceList(this.jane, "./", "root.file", "level1/file", "level1/level2/file");
        this.assertPrivateSpaceList(this.jane, ".", "root.file", "level1/file", "level1/level2/file");
        this.assertPrivateSpaceList(this.jane, "root.file", "root.file");
        this.assertPrivateSpaceList(this.jane, "./root.file", "root.file");
        this.assertPrivateSpaceList(this.jane, "level1", "level1/file", "level1/level2/file");
        this.assertPrivateSpaceList(this.jane, "level1/", "level1/file", "level1/level2/file");
        this.assertPrivateSpaceList(this.jane, "./level1", "level1/file", "level1/level2/file");
        this.assertPrivateSpaceList(this.jane, "./level1/", "level1/file", "level1/level2/file");
        this.assertPrivateSpaceList(this.jane, "./level1/level2", "level1/level2/file");
        this.assertPrivateSpaceList(this.jane, "./level1/level2/", "level1/level2/file");
        this.assertPrivateSpaceList(this.jane, "level1/level2", "level1/level2/file");
        this.assertPrivateSpaceList(this.jane, "level1/level2/", "level1/level2/file");
    }

    @ParameterizedTest
    @MethodSource(value={"allStorages"})
    void listingInboxValidation(WithStorageProvider.StorageDescriptor descriptor) {
        this.init(descriptor);
        this.registerJohnAndJane();
        this.writeDataToInbox(this.jane, "root.file", "Hello here 1");
        this.writeDataToInbox(this.jane, "level1/file", "Hello here 1");
        this.writeDataToInbox(this.jane, "level1/level2/file", "Hello here 1");
        this.assertInboxSpaceList(this.jane, "", "root.file", "level1/file", "level1/level2/file");
        this.assertInboxSpaceList(this.jane, "./", "root.file", "level1/file", "level1/level2/file");
        this.assertInboxSpaceList(this.jane, ".", "root.file", "level1/file", "level1/level2/file");
        this.assertInboxSpaceList(this.jane, "root.file", "root.file");
        this.assertInboxSpaceList(this.jane, "./root.file", "root.file");
        this.assertInboxSpaceList(this.jane, "level1", "level1/file", "level1/level2/file");
        this.assertInboxSpaceList(this.jane, "level1/", "level1/file", "level1/level2/file");
        this.assertInboxSpaceList(this.jane, "./level1", "level1/file", "level1/level2/file");
        this.assertInboxSpaceList(this.jane, "./level1/", "level1/file", "level1/level2/file");
        this.assertInboxSpaceList(this.jane, "./level1/level2", "level1/level2/file");
        this.assertInboxSpaceList(this.jane, "./level1/level2/", "level1/level2/file");
        this.assertInboxSpaceList(this.jane, "level1/level2", "level1/level2/file");
        this.assertInboxSpaceList(this.jane, "level1/level2/", "level1/level2/file");
    }

    private void validateInboxStructAndEncryption(AbsoluteLocation<ResolvedResource> expectedInboxResource) {
        List<AbsoluteLocation<ResolvedResource>> inbox = this.listFiles(it -> it.contains("public/inbox"));
        Assertions.assertThat(inbox).hasSize(1);
        AbsoluteLocation<ResolvedResource> foundResource = inbox.get(0);
        Assertions.assertThat((Object)foundResource.location()).isEqualTo((Object)expectedInboxResource.location());
        Assertions.assertThat((String)foundResource.location().getPath()).asString().contains(new CharSequence[]{"hello.txt"});
        try (InputStream read = this.storage.read(foundResource);){
            Assertions.assertThat((InputStream)read).asString().doesNotContain(new CharSequence[]{"Hello here 1"});
        }
    }

    private void validatePrivateStructAndEncryption(AbsoluteLocation<ResolvedResource> expectedPrivateResource) {
        List<AbsoluteLocation<ResolvedResource>> privateFiles = this.listFiles(it -> it.contains("private/files"));
        Assertions.assertThat(privateFiles).hasSize(1);
        AbsoluteLocation<ResolvedResource> foundResource = privateFiles.get(0);
        Assertions.assertThat((Object)foundResource.location()).isEqualTo((Object)expectedPrivateResource.location());
        Assertions.assertThat((String)foundResource.toString()).doesNotContain(new CharSequence[]{"secret.txt"});
        Assertions.assertThat((String)foundResource.toString()).doesNotContain(new CharSequence[]{"folder1"});
        try (InputStream read = this.storage.read(foundResource);){
            Assertions.assertThat((InputStream)read).asString().doesNotContain(new CharSequence[]{"Hello here 1"});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<AbsoluteLocation<ResolvedResource>> listFiles(Predicate<String> pattern) {
        try (Stream ls = this.storage.list(new AbsoluteLocation((ResourceLocation)BasePrivateResource.forPrivate((Uri)this.location)));){
            List<AbsoluteLocation<ResolvedResource>> list = ls.filter(it -> !it.location().toASCIIString().startsWith(".")).filter(it -> pattern.test(it.location().toASCIIString())).collect(Collectors.toList());
            return list;
        }
    }

    private void init(WithStorageProvider.StorageDescriptor descriptor) {
        DefaultDatasafeServices datasafeServices = DatasafeServicesProvider.defaultDatasafeServices((StorageService)descriptor.getStorageService().get(), descriptor.getLocation());
        this.initialize(DatasafeServicesProvider.dfsConfig(descriptor.getLocation()), datasafeServices);
        this.location = descriptor.getLocation();
        this.storage = (StorageService)descriptor.getStorageService().get();
    }
}

