/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.business.impl.e2e;

import com.google.common.io.ByteStreams;
import de.adorsys.datasafe.business.impl.service.DaggerDefaultDatasafeServices;
import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.impl.profile.config.DefaultDFSConfig;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadKeyPassword;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.storage.impl.fs.FileSystemStorageService;
import de.adorsys.datasafe.types.api.actions.ReadRequest;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.shared.BaseMockitoTest;
import de.adorsys.datasafe.types.api.shared.Dirs;
import de.adorsys.datasafe.types.api.shared.Resources;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.Provider;
import java.security.Security;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class Datasafe043CompatTest
extends BaseMockitoTest {
    private static final String BASE_FIXTURE = "compat-0.4.3";
    private static final String OLD_ROOT = "file:/var/folders/3w/fzdgs28j1_b3r4y8x9_s4wpw0000gn/T/junit4892767241345613098/";
    private UserIDAuth john = new UserIDAuth(new UserID("john"), new ReadKeyPassword("secure-password john"));
    private UserIDAuth jane = new UserIDAuth(new UserID("jane"), new ReadKeyPassword("secure-password jane"));
    private DefaultDatasafeServices datasafe;
    private Path dfsRoot;

    Datasafe043CompatTest() {
    }

    @BeforeEach
    void extractFixtureAndPrepare(@TempDir Path tempDir) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.dfsRoot = tempDir;
        Resources.copyResourceDir((String)BASE_FIXTURE, (Path)tempDir);
        this.replace(tempDir.resolve("profiles/private/jane"), OLD_ROOT, tempDir.toUri().toString());
        this.replace(tempDir.resolve("profiles/private/john"), OLD_ROOT, tempDir.toUri().toString());
        this.replace(tempDir.resolve("profiles/public/jane"), OLD_ROOT, tempDir.toUri().toString());
        this.replace(tempDir.resolve("profiles/public/john"), OLD_ROOT, tempDir.toUri().toString());
        this.datasafe = DaggerDefaultDatasafeServices.builder().config((DFSConfig)new DefaultDFSConfig(tempDir.toUri(), "PAZZWORD")).storage((StorageService)new FileSystemStorageService(tempDir)).build();
    }

    @Test
    void writeNewAndReadFileFromOldVersion() {
        String oldContent = "Hello here 1";
        String newContent = "NEW Hello here 1";
        String newPrivatePath = "folder1/secret-NEW.txt";
        String oldPrivatePath = "folder1/secret.txt";
        String newInboxPath = "hello-NEW.txt";
        String oldInboxPath = "hello.txt";
        try (OutputStream os = this.datasafe.privateService().write(WriteRequest.forDefaultPrivate((Object)this.jane, (String)newPrivatePath));){
            os.write(newContent.getBytes());
        }
        var8_9 = null;
        try (InputStream is = this.datasafe.privateService().read(ReadRequest.forDefaultPrivate((Object)this.jane, (String)newPrivatePath));
             OutputStream os = this.datasafe.inboxService().write(WriteRequest.forDefaultPublic(Collections.singleton(this.john.getUserID()), (String)newInboxPath));){
            ByteStreams.copy((InputStream)is, (OutputStream)os);
        }
        catch (Throwable throwable) {
            var8_9 = throwable;
            throw throwable;
        }
        Assertions.assertThat((InputStream)this.datasafe.privateService().read(ReadRequest.forDefaultPrivate((Object)this.jane, (String)oldPrivatePath))).hasContent(oldContent);
        Assertions.assertThat((InputStream)this.datasafe.privateService().read(ReadRequest.forDefaultPrivate((Object)this.jane, (String)newPrivatePath))).hasContent(newContent);
        Assertions.assertThat((InputStream)this.datasafe.inboxService().read(ReadRequest.forDefaultPrivate((Object)this.john, (String)oldInboxPath))).hasContent(oldContent);
        Assertions.assertThat((InputStream)this.datasafe.inboxService().read(ReadRequest.forDefaultPrivate((Object)this.john, (String)newInboxPath))).hasContent(newContent);
        Assertions.assertThat((List)Dirs.walk((Path)this.dfsRoot, (int)1)).containsExactlyInAnyOrder((Object[])new String[]{"profiles", "users"});
        Assertions.assertThat((List)Dirs.walk((Path)this.dfsRoot.resolve("profiles"))).containsExactlyInAnyOrder((Object[])new String[]{"public", "private", "public/john", "public/jane", "private/john", "private/jane"});
        Assertions.assertThat((List)Dirs.walk((Path)this.dfsRoot.resolve("users"), (int)3)).containsExactlyInAnyOrder((Object[])new String[]{"john", "john/public", "john/public/inbox", "john/public/pubkeys", "john/private", "john/private/keystore", "jane", "jane/public", "jane/public/pubkeys", "jane/private", "jane/private/keystore", "jane/private/files"});
    }

    private void replace(Path file, String what, String with) {
        List<String> baseContent = Files.readAllLines(file);
        Files.write(file, (Iterable<? extends CharSequence>)baseContent.stream().map(it -> it.replace(what, with)).collect(Collectors.toList()), new OpenOption[0]);
    }
}

