/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.business.impl.e2e;

import de.adorsys.datasafe.business.impl.e2e.BaseE2ETest;
import de.adorsys.datasafe.business.impl.e2e.DatasafeServicesProvider;
import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.teststorage.WithStorageProvider;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BasicFunctionalityUtf8Test
extends BaseE2ETest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BasicFunctionalityUtf8Test.class);
    private static final String MESSAGE_ONE = "Hello here 1";
    private static final String FOLDER = "folder1";
    private static final String PRIVATE_FILE = "secret.txt";
    private static final String PRIVATE_FILE_PATH = "folder1/secret.txt";

    BasicFunctionalityUtf8Test() {
    }

    @ParameterizedTest
    @MethodSource(value={"allStorages"})
    void readPrivateContentWithUnicode(WithStorageProvider.StorageDescriptor descriptor) {
        this.init(descriptor);
        this.jane = this.registerUser("jane");
        String unicodeMessage = "\u043f\u0440\u0438\u0432\u0435\u0442 \u043c\u0438\u0440!";
        this.writeDataToPrivate(this.jane, PRIVATE_FILE_PATH, unicodeMessage);
        AbsoluteLocation<ResolvedResource> privateJane = this.getFirstFileInPrivate(this.jane);
        String privateContentJane = this.readPrivateUsingPrivateKey(this.jane, ((ResolvedResource)privateJane.getResource()).asPrivate());
        Assertions.assertThat((String)privateContentJane).isEqualTo((Object)unicodeMessage);
    }

    @ParameterizedTest
    @MethodSource(value={"allStorages"})
    void readPrivateContentWithUnicodeUsingUnicodePath(WithStorageProvider.StorageDescriptor descriptor) {
        this.init(descriptor);
        this.jane = this.registerUser("jane");
        String unicodeMessage = "\u043f\u0440\u0438\u0432\u0435\u0442 \u043c\u0438\u0440!";
        this.writeDataToPrivate(this.jane, " \u043f\u0440\u0438\u0432\u0435\u0442/pr\u00fcfungsdokument=/\u0444\u0430\u0439\u043b:&? \u0441 \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u043c.\u0434\u043e\u043a", unicodeMessage);
        String privateContentJane = this.readPrivateUsingPrivateKey(this.jane, BasePrivateResource.forPrivate((String)" \u043f\u0440\u0438\u0432\u0435\u0442/pr\u00fcfungsdokument=/\u0444\u0430\u0439\u043b:&? \u0441 \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u043c.\u0434\u043e\u043a"));
        Assertions.assertThat((String)privateContentJane).isEqualTo((Object)unicodeMessage);
    }

    @ParameterizedTest
    @MethodSource(value={"allStorages"})
    void listingPrivatePathWithUnicode(WithStorageProvider.StorageDescriptor descriptor) {
        this.init(descriptor);
        this.registerJohnAndJane();
        this.writeDataToPrivate(this.jane, "pr\u00fcfungsdokument.doc+doc", MESSAGE_ONE);
        this.writeDataToPrivate(this.jane, "\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/?\u0444\u0430\u0439\u043b+doc", MESSAGE_ONE);
        this.writeDataToPrivate(this.jane, "\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/\u0443\u0440\u043e\u0432\u0435\u043d\u044c 2=+/&\u0444\u0430\u0439\u043b \u043f\u0440\u043e\u0431\u0435\u043b+\u043f\u043b\u044e\u0441", MESSAGE_ONE);
        this.assertPrivateSpaceList(this.jane, "", "pr\u00fcfungsdokument.doc+doc", "\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/?\u0444\u0430\u0439\u043b+doc", "\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/\u0443\u0440\u043e\u0432\u0435\u043d\u044c 2=+/&\u0444\u0430\u0439\u043b \u043f\u0440\u043e\u0431\u0435\u043b+\u043f\u043b\u044e\u0441");
        this.assertPrivateSpaceList(this.jane, "./", "pr\u00fcfungsdokument.doc+doc", "\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/?\u0444\u0430\u0439\u043b+doc", "\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/\u0443\u0440\u043e\u0432\u0435\u043d\u044c 2=+/&\u0444\u0430\u0439\u043b \u043f\u0440\u043e\u0431\u0435\u043b+\u043f\u043b\u044e\u0441");
        this.assertPrivateSpaceList(this.jane, ".", "pr\u00fcfungsdokument.doc+doc", "\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/?\u0444\u0430\u0439\u043b+doc", "\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/\u0443\u0440\u043e\u0432\u0435\u043d\u044c 2=+/&\u0444\u0430\u0439\u043b \u043f\u0440\u043e\u0431\u0435\u043b+\u043f\u043b\u044e\u0441");
        this.assertPrivateSpaceList(this.jane, "pr\u00fcfungsdokument.doc+doc", "pr\u00fcfungsdokument.doc+doc");
        this.assertPrivateSpaceList(this.jane, "./pr\u00fcfungsdokument.doc+doc", "pr\u00fcfungsdokument.doc+doc");
        this.assertPrivateSpaceList(this.jane, "\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/\u0443\u0440\u043e\u0432\u0435\u043d\u044c 2=+", "\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/\u0443\u0440\u043e\u0432\u0435\u043d\u044c 2=+/&\u0444\u0430\u0439\u043b \u043f\u0440\u043e\u0431\u0435\u043b+\u043f\u043b\u044e\u0441");
        this.assertPrivateSpaceList(this.jane, "\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/\u0443\u0440\u043e\u0432\u0435\u043d\u044c 2=+/", "\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/\u0443\u0440\u043e\u0432\u0435\u043d\u044c 2=+/&\u0444\u0430\u0439\u043b \u043f\u0440\u043e\u0431\u0435\u043b+\u043f\u043b\u044e\u0441");
        this.assertPrivateSpaceList(this.jane, "./\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/\u0443\u0440\u043e\u0432\u0435\u043d\u044c 2=+", "\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/\u0443\u0440\u043e\u0432\u0435\u043d\u044c 2=+/&\u0444\u0430\u0439\u043b \u043f\u0440\u043e\u0431\u0435\u043b+\u043f\u043b\u044e\u0441");
        this.assertPrivateSpaceList(this.jane, "./\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/\u0443\u0440\u043e\u0432\u0435\u043d\u044c 2=+/", "\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/\u0443\u0440\u043e\u0432\u0435\u043d\u044c 2=+/&\u0444\u0430\u0439\u043b \u043f\u0440\u043e\u0431\u0435\u043b+\u043f\u043b\u044e\u0441");
    }

    @ParameterizedTest
    @MethodSource(value={"allStorages"})
    void readInboxContentWithUnicodeUsingUnicodePath(WithStorageProvider.StorageDescriptor descriptor) {
        this.init(descriptor);
        this.jane = this.registerUser("jane");
        String unicodeMessage = "\u043f\u0440\u0438\u0432\u0435\u0442 \u043c\u0438\u0440!";
        this.writeDataToInbox(this.jane, " \u043f\u0440\u0438\u0432\u0435\u0442/pr\u00fcfungsdokument=/\u0444\u0430\u0439\u043b:&? \u0441 \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u043c.\u0434\u043e\u043a", unicodeMessage);
        String inboxContentJane = this.readInboxUsingPrivateKey(this.jane, BasePrivateResource.forPrivate((String)" \u043f\u0440\u0438\u0432\u0435\u0442/pr\u00fcfungsdokument=/\u0444\u0430\u0439\u043b:&? \u0441 \u043f\u0440\u043e\u0431\u0435\u043b\u043e\u043c.\u0434\u043e\u043a"));
        Assertions.assertThat((String)inboxContentJane).isEqualTo((Object)unicodeMessage);
    }

    @ParameterizedTest
    @MethodSource(value={"allStorages"})
    void listingInboxPathWithUnicode(WithStorageProvider.StorageDescriptor descriptor) {
        this.init(descriptor);
        this.registerJohnAndJane();
        this.writeDataToInbox(this.jane, "pr\u00fcfungsdokument.doc+doc", MESSAGE_ONE);
        this.writeDataToInbox(this.jane, "\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/?\u0444\u0430\u0439\u043b+doc", MESSAGE_ONE);
        this.writeDataToInbox(this.jane, "\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/\u0443\u0440\u043e\u0432\u0435\u043d\u044c 2=+/&\u0444\u0430\u0439\u043b \u043f\u0440\u043e\u0431\u0435\u043b+\u043f\u043b\u044e\u0441", MESSAGE_ONE);
        this.assertInboxSpaceList(this.jane, "", "pr\u00fcfungsdokument.doc+doc", "\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/?\u0444\u0430\u0439\u043b+doc", "\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/\u0443\u0440\u043e\u0432\u0435\u043d\u044c 2=+/&\u0444\u0430\u0439\u043b \u043f\u0440\u043e\u0431\u0435\u043b+\u043f\u043b\u044e\u0441");
        this.assertInboxSpaceList(this.jane, "./", "pr\u00fcfungsdokument.doc+doc", "\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/?\u0444\u0430\u0439\u043b+doc", "\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/\u0443\u0440\u043e\u0432\u0435\u043d\u044c 2=+/&\u0444\u0430\u0439\u043b \u043f\u0440\u043e\u0431\u0435\u043b+\u043f\u043b\u044e\u0441");
        this.assertInboxSpaceList(this.jane, ".", "pr\u00fcfungsdokument.doc+doc", "\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/?\u0444\u0430\u0439\u043b+doc", "\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/\u0443\u0440\u043e\u0432\u0435\u043d\u044c 2=+/&\u0444\u0430\u0439\u043b \u043f\u0440\u043e\u0431\u0435\u043b+\u043f\u043b\u044e\u0441");
        this.assertInboxSpaceList(this.jane, "pr\u00fcfungsdokument.doc+doc", "pr\u00fcfungsdokument.doc+doc");
        this.assertInboxSpaceList(this.jane, "./pr\u00fcfungsdokument.doc+doc", "pr\u00fcfungsdokument.doc+doc");
        this.assertInboxSpaceList(this.jane, "\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/\u0443\u0440\u043e\u0432\u0435\u043d\u044c 2=+", "\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/\u0443\u0440\u043e\u0432\u0435\u043d\u044c 2=+/&\u0444\u0430\u0439\u043b \u043f\u0440\u043e\u0431\u0435\u043b+\u043f\u043b\u044e\u0441");
        this.assertInboxSpaceList(this.jane, "\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/\u0443\u0440\u043e\u0432\u0435\u043d\u044c 2=+/", "\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/\u0443\u0440\u043e\u0432\u0435\u043d\u044c 2=+/&\u0444\u0430\u0439\u043b \u043f\u0440\u043e\u0431\u0435\u043b+\u043f\u043b\u044e\u0441");
        this.assertInboxSpaceList(this.jane, "./\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/\u0443\u0440\u043e\u0432\u0435\u043d\u044c 2=+", "\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/\u0443\u0440\u043e\u0432\u0435\u043d\u044c 2=+/&\u0444\u0430\u0439\u043b \u043f\u0440\u043e\u0431\u0435\u043b+\u043f\u043b\u044e\u0441");
        this.assertInboxSpaceList(this.jane, "./\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/\u0443\u0440\u043e\u0432\u0435\u043d\u044c 2=+/", "\u0443\u0440\u043e\u0432\u0435\u043d\u044c1/\u0443\u0440\u043e\u0432\u0435\u043d\u044c 2=+/&\u0444\u0430\u0439\u043b \u043f\u0440\u043e\u0431\u0435\u043b+\u043f\u043b\u044e\u0441");
    }

    private void init(WithStorageProvider.StorageDescriptor descriptor) {
        DefaultDatasafeServices datasafeServices = DatasafeServicesProvider.defaultDatasafeServices((StorageService)descriptor.getStorageService().get(), descriptor.getLocation());
        this.initialize(DatasafeServicesProvider.dfsConfig(descriptor.getLocation()), datasafeServices);
    }
}

