/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.business.impl.e2e;

import de.adorsys.datasafe.business.impl.service.DaggerDefaultDatasafeServices;
import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.impl.profile.config.DefaultDFSConfig;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.storage.api.SchemeDelegatingStorage;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.storage.impl.fs.FileSystemStorageService;
import de.adorsys.datasafe.teststorage.WithStorageProvider;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import de.adorsys.datasafe.types.api.resource.Uri;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.testcontainers.shaded.com.google.common.collect.ImmutableMap;

class UserProfileWithUtf8Test
extends WithStorageProvider {
    private Path fsPath;
    private Uri minioPath;
    private StorageService minio;
    private StorageService filesystem;
    private DefaultDatasafeServices datasafeServices;

    UserProfileWithUtf8Test() {
    }

    @BeforeEach
    void initialize(@TempDir Path tempDir) {
        WithStorageProvider.StorageDescriptor minioDescriptor = UserProfileWithUtf8Test.minio();
        this.fsPath = tempDir;
        this.minio = (StorageService)minioDescriptor.getStorageService().get();
        this.filesystem = new FileSystemStorageService(tempDir);
        this.minioPath = minioDescriptor.getLocation();
        SchemeDelegatingStorage multiDfs = new SchemeDelegatingStorage((Map)ImmutableMap.of((Object)"s3", (Object)this.minio, (Object)"file", (Object)this.filesystem));
        this.datasafeServices = DaggerDefaultDatasafeServices.builder().config((DFSConfig)new ProfilesOnFsDataOnMinio(this.minioPath, new Uri(tempDir.toUri()))).storage((StorageService)multiDfs).build();
    }

    @Test
    void testProfileOnFsDataOnMinioWorks() {
        UserIDAuth userJohn = new UserIDAuth("john", "doe");
        this.datasafeServices.userProfile().registerUsingDefaults(userJohn);
        try (OutputStream os = this.datasafeServices.privateService().write(WriteRequest.forDefaultPrivate((Object)userJohn, (String)"file.txt"));){
            os.write("Hello".getBytes());
        }
        Assertions.assertThat(Files.walk(this.fsPath, new FileVisitOption[0])).extracting(it -> this.fsPath.relativize((Path)it)).extracting(it -> URI.create(it.toString()).getPath()).containsExactlyInAnyOrder((Object[])new String[]{"", "pr\u00fcfungs", "pr\u00fcfungs/\u043c\u043e\u0439 \u043f\u0440\u043e\u0444\u0438\u043b\u044c+:\u043f\u0440\u0438\u0432\u0430\u0442\u043d\u044b\u0439-$&=john", "pr\u00fcfungs/\u043c\u043e\u0439 \u043f\u0440\u043e\u0444\u0438\u043b\u044c+:\u043f\u0443\u0431\u043b\u0438\u0447\u043d\u044b\u0439-$&=john"});
        ((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((Stream)this.minio.list(new AbsoluteLocation((ResourceLocation)BasePrivateResource.forPrivate((Uri)this.minioPath.resolve(""))))).extracting(it -> this.minioPath.relativize(it.location())).extracting(Uri::asString).contains((Object[])new String[]{"users/john/root pr\u00fcfungs+?=/\u0442\u0435\u0441\u0442:\u0442\u0435\u0441\u0442&/private/keystore", "users/john/root pr\u00fcfungs+?=/\u0442\u0435\u0441\u0442:\u0442\u0435\u0441\u0442&/public/pubkeys"})).anyMatch(it -> it.startsWith("users/john/root pr\u00fcfungs+?=/\u0442\u0435\u0441\u0442:\u0442\u0435\u0441\u0442&/private/files/"))).hasSize(3);
    }

    static class ProfilesOnFsDataOnMinio
    extends DefaultDFSConfig {
        private final Uri profilesPath;

        ProfilesOnFsDataOnMinio(Uri minioBucketPath, Uri profilesPath) {
            super(minioBucketPath, "PAZZWORT");
            this.profilesPath = profilesPath;
        }

        public AbsoluteLocation publicProfile(UserID forUser) {
            return new AbsoluteLocation((ResourceLocation)BasePrivateResource.forPrivate((Uri)this.profilesPath.resolve("pr\u00fcfungs/\u043c\u043e\u0439 \u043f\u0440\u043e\u0444\u0438\u043b\u044c+:\u043f\u0443\u0431\u043b\u0438\u0447\u043d\u044b\u0439-$&=" + forUser.getValue())));
        }

        public AbsoluteLocation privateProfile(UserID forUser) {
            return new AbsoluteLocation((ResourceLocation)BasePrivateResource.forPrivate((Uri)this.profilesPath.resolve("pr\u00fcfungs/\u043c\u043e\u0439 \u043f\u0440\u043e\u0444\u0438\u043b\u044c+:\u043f\u0440\u0438\u0432\u0430\u0442\u043d\u044b\u0439-$&=" + forUser.getValue())));
        }

        protected Uri userRoot(UserID userID) {
            return super.userRoot(userID).resolve("root pr\u00fcfungs+?=/\u0442\u0435\u0441\u0442:\u0442\u0435\u0441\u0442&/");
        }
    }
}

