/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.business.impl.e2e;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import de.adorsys.datasafe.business.impl.service.DaggerDefaultDatasafeServices;
import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.impl.profile.config.DefaultDFSConfig;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.storage.api.SchemeDelegatingStorage;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.storage.impl.db.DatabaseConnectionRegistry;
import de.adorsys.datasafe.storage.impl.db.DatabaseCredentials;
import de.adorsys.datasafe.storage.impl.db.DatabaseStorageService;
import de.adorsys.datasafe.storage.impl.fs.FileSystemStorageService;
import de.adorsys.datasafe.teststorage.WithStorageProvider;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import de.adorsys.datasafe.types.api.resource.Uri;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class SchemeDelegationWithDbTest
extends WithStorageProvider {
    private static final Set<String> ALLOWED_TABLES = ImmutableSet.of((Object)"users", (Object)"private_profiles", (Object)"public_profiles");
    private Path fsPath;
    private StorageService filesystem;
    private StorageService db;
    private DefaultDatasafeServices datasafeServices;

    SchemeDelegationWithDbTest() {
    }

    @BeforeEach
    void initialize(@TempDir Path tempDir) {
        this.fsPath = tempDir;
        this.filesystem = new FileSystemStorageService(tempDir);
        this.db = new DatabaseStorageService(ALLOWED_TABLES, new DatabaseConnectionRegistry(uri -> uri.location().getWrapped().getScheme() + ":" + uri.location().getPath().split("/")[1], (Map)ImmutableMap.of((Object)"jdbc://localhost:9999", (Object)new DatabaseCredentials("sa", "sa"))));
        SchemeDelegatingStorage multiDfs = new SchemeDelegatingStorage((Map)ImmutableMap.of((Object)"file", (Object)this.filesystem, (Object)"jdbc", (Object)this.db));
        this.datasafeServices = DaggerDefaultDatasafeServices.builder().config((DFSConfig)new ProfilesOnDbDataOnFs(tempDir.toUri(), URI.create("jdbc://localhost:9999/h2:mem:test/"))).storage((StorageService)multiDfs).build();
    }

    @Test
    void testProfileOnDbDataOnFsWorks() {
        UserIDAuth userJohn = new UserIDAuth("john", "doe");
        this.datasafeServices.userProfile().registerUsingDefaults(userJohn);
        try (OutputStream os = this.datasafeServices.privateService().write(WriteRequest.forDefaultPrivate((Object)userJohn, (String)"file.txt"));){
            os.write("Hello".getBytes());
        }
        Assertions.assertThat(this.listDb("jdbc://localhost:9999/h2:mem:test/private_profiles/")).containsExactly((Object[])new String[]{"jdbc://localhost:9999/h2:mem:test/private_profiles/john"});
        Assertions.assertThat(this.listDb("jdbc://localhost:9999/h2:mem:test/public_profiles/")).containsExactly((Object[])new String[]{"jdbc://localhost:9999/h2:mem:test/public_profiles/john"});
        Path encryptedFile = (Path)Files.walk(this.fsPath.resolve("users/john/private/files/"), new FileVisitOption[0]).collect(Collectors.toList()).get(1);
        Assertions.assertThat(Files.walk(this.fsPath, new FileVisitOption[0])).extracting(it -> this.fsPath.relativize((Path)it)).extracting(Path::toString).containsExactlyInAnyOrder((Object[])new String[]{"", "users", "users/john", "users/john/public", "users/john/public/pubkeys", "users/john/private", "users/john/private/keystore", "users/john/private/files", this.fsPath.relativize(encryptedFile).toString()});
    }

    private Stream<String> listDb(String path) {
        return this.db.list(BasePrivateResource.forAbsolutePrivate((URI)URI.create(path))).map(it -> it.location().asURI().toString());
    }

    static class ProfilesOnDbDataOnFs
    extends DefaultDFSConfig {
        private final Uri profilesPath;

        ProfilesOnDbDataOnFs(URI fsPath, URI profilesPath) {
            super(fsPath, "PAZZWORT");
            this.profilesPath = new Uri(profilesPath);
        }

        public AbsoluteLocation publicProfile(UserID forUser) {
            return new AbsoluteLocation((ResourceLocation)BasePrivateResource.forPrivate((Uri)this.profilesPath.resolve("public_profiles/").resolve(forUser.getValue())));
        }

        public AbsoluteLocation privateProfile(UserID forUser) {
            return new AbsoluteLocation((ResourceLocation)BasePrivateResource.forPrivate((Uri)this.profilesPath.resolve("private_profiles/").resolve(forUser.getValue())));
        }
    }
}

