/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.business.impl.e2e;

import de.adorsys.datasafe.business.impl.e2e.DatasafeServicesProvider;
import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadStorePassword;
import de.adorsys.datasafe.encrypiton.impl.keystore.DefaultPasswordBasedKeyConfig;
import de.adorsys.datasafe.encrypiton.impl.keystore.KeyStoreServiceImpl;
import de.adorsys.datasafe.encrypiton.impl.keystore.types.PasswordBasedKeyConfig;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.storage.impl.fs.FileSystemStorageService;
import de.adorsys.datasafe.types.api.resource.Uri;
import de.adorsys.datasafe.types.api.shared.BaseMockitoTest;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

class KeystoreE2ETest
extends BaseMockitoTest {
    private DefaultDatasafeServices datasafeServices;

    KeystoreE2ETest() {
    }

    @BeforeEach
    void init(@TempDir Path rootPath) {
        this.datasafeServices = DatasafeServicesProvider.defaultDatasafeServices((StorageService)new FileSystemStorageService(rootPath), new Uri(rootPath.toUri()));
    }

    @Test
    void testDefaultKeystoreHasProperKeys() {
        UserIDAuth auth = new UserIDAuth("user", "pass");
        this.datasafeServices.userProfile().registerUsingDefaults(auth);
        URI keystorePath = this.datasafeServices.userProfile().privateProfile(auth).getKeystore().location().asURI();
        KeyStoreServiceImpl keyStoreService = new KeyStoreServiceImpl((PasswordBasedKeyConfig)new DefaultPasswordBasedKeyConfig());
        KeyStore keyStore = keyStoreService.deserialize(Files.readAllBytes(Paths.get(keystorePath)), "ID", new ReadStorePassword("PAZZWORD"));
        ((IterableAssert)Assertions.assertThat(this.aliases(keyStore)).filteredOn(it -> it.matches("PATH_SECRET.+"))).hasSize(1);
        ((IterableAssert)Assertions.assertThat(this.aliases(keyStore)).filteredOn(it -> it.matches("PRIVATE_SECRET.+"))).hasSize(1);
    }

    private Set<String> aliases(KeyStore keyStore) {
        Enumeration<String> aliases = keyStore.aliases();
        HashSet<String> result = new HashSet<String>();
        while (aliases.hasMoreElements()) {
            result.add(aliases.nextElement());
        }
        return result;
    }
}

