/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.business.impl.e2e;

import de.adorsys.datasafe.business.impl.e2e.BaseE2ETest;
import de.adorsys.datasafe.business.impl.e2e.DatasafeServicesProvider;
import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadKeyPassword;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.teststorage.WithStorageProvider;
import de.adorsys.datasafe.types.api.actions.ReadRequest;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import de.adorsys.datasafe.types.api.resource.Uri;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.UnrecoverableKeyException;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.testcontainers.shaded.com.google.common.collect.ImmutableSet;

class BasicFunctionalityWithPasswordChangeTest
extends BaseE2ETest {
    BasicFunctionalityWithPasswordChangeTest() {
    }

    @ParameterizedTest
    @MethodSource(value={"allStorages"})
    void testUserIsRemovedWithFiles(WithStorageProvider.StorageDescriptor descriptor) {
        this.init(descriptor);
        UserID userJohn = new UserID("john");
        this.john = this.registerUser(userJohn.getValue());
        this.writeDataToPrivate(this.john, "root.txt", "Hello here 1");
        this.writeDataToPrivate(this.john, "some/some.txt", "Hello here 1");
        this.john = this.checkUpdatedCredsWorkAndOldDont(this.john, new ReadKeyPassword("Some other"), auth -> {
            this.writeDataToPrivate((UserIDAuth)auth, "some/other/other.txt", "Hello here 1");
            this.writeDataToPrivate((UserIDAuth)auth, "different/data.txt", "Hello here 1");
        });
        this.john = this.checkUpdatedCredsWorkAndOldDont(this.john, new ReadKeyPassword("Some another"), auth -> this.profileRemovalService.deregister(auth));
        this.assertRootDirIsEmpty(descriptor);
    }

    @ParameterizedTest
    @MethodSource(value={"allStorages"})
    void testMultipleRecipientsSharing(WithStorageProvider.StorageDescriptor descriptor) {
        this.init(descriptor);
        UserIDAuth john = this.registerUser("john");
        UserIDAuth jane = this.registerUser("jane");
        UserIDAuth jamie = this.registerUser("jamie");
        String multiShareFile = "multishare.txt";
        this.multishareFiles(john, jane, jamie, multiShareFile);
        Stream.of(john, jane, jamie).forEach(it -> this.checkUpdatedCredsWorkAndOldDont((UserIDAuth)it, new ReadKeyPassword(UUID.randomUUID().toString()), auth -> Assertions.assertThat((InputStream)this.readFromInbox.read(ReadRequest.forDefaultPrivate((Object)auth, (String)multiShareFile))).hasContent("Hello here 1")));
    }

    @ParameterizedTest
    @MethodSource(value={"allStorages"})
    void testWriteToPrivateListPrivateReadPrivateAndSendToAndReadFromInbox(WithStorageProvider.StorageDescriptor descriptor) {
        this.init(descriptor);
        this.registerJohnAndJane();
        this.writeDataToPrivate(this.jane, "folder1/secret.txt", "Hello here 1");
        this.jane = this.checkUpdatedCredsWorkAndOldDont(this.jane, new ReadKeyPassword("Another passwd1"), this::getFirstFileInPrivate);
        AbsoluteLocation<ResolvedResource> privateJane = this.getFirstFileInPrivate(this.jane);
        this.jane = this.checkUpdatedCredsWorkAndOldDont(this.jane, new ReadKeyPassword("Another passwd2"), auth -> this.readPrivateUsingPrivateKey((UserIDAuth)auth, ((ResolvedResource)privateJane.getResource()).asPrivate()));
        String privateContentJane = this.readPrivateUsingPrivateKey(this.jane, ((ResolvedResource)privateJane.getResource()).asPrivate());
        this.sendToInbox(this.john.getUserID(), "hello.txt", privateContentJane);
        AbsoluteLocation<ResolvedResource> inboxJohn = this.getFirstFileInInbox(this.john);
        this.john = this.checkUpdatedCredsWorkAndOldDont(this.john, new ReadKeyPassword("Another passwd4"), auth -> this.readInboxUsingPrivateKey((UserIDAuth)auth, ((ResolvedResource)inboxJohn.getResource()).asPrivate()));
        String result = this.readInboxUsingPrivateKey(this.john, ((ResolvedResource)inboxJohn.getResource()).asPrivate());
        Assertions.assertThat((String)result).isEqualTo((Object)"Hello here 1");
        Assertions.assertThat((Object)((ResolvedResource)privateJane.getResource()).asPrivate().decryptedPath()).extracting(Uri::toASCIIString).isEqualTo((Object)"folder1/secret.txt");
        Assertions.assertThat((Object)((ResolvedResource)privateJane.getResource()).asPrivate().encryptedPath()).extracting(Uri::toASCIIString).isNotEqualTo((Object)"folder1/secret.txt");
    }

    @ParameterizedTest
    @MethodSource(value={"allStorages"})
    void listingValidation(WithStorageProvider.StorageDescriptor descriptor) {
        this.init(descriptor);
        this.registerJohnAndJane();
        this.writeDataToPrivate(this.jane, "root.file", "Hello here 1");
        this.writeDataToPrivate(this.jane, "level1/file", "Hello here 1");
        this.jane = this.checkUpdatedCredsWorkAndOldDont(this.jane, new ReadKeyPassword("Another passwd1"), auth -> this.writeDataToPrivate((UserIDAuth)auth, "level1/level2/file", "Hello here 1"));
        this.jane = this.checkUpdatedCredsWorkAndOldDont(this.jane, new ReadKeyPassword("Another passwd2"), auth -> {
            this.assertPrivateSpaceList((UserIDAuth)auth, "", "root.file", "level1/file", "level1/level2/file");
            this.assertPrivateSpaceList((UserIDAuth)auth, "./", "root.file", "level1/file", "level1/level2/file");
            this.assertPrivateSpaceList((UserIDAuth)auth, ".", "root.file", "level1/file", "level1/level2/file");
        });
        this.jane = this.checkUpdatedCredsWorkAndOldDont(this.jane, new ReadKeyPassword("Another passwd3"), auth -> {
            this.assertPrivateSpaceList((UserIDAuth)auth, "root.file", "root.file");
            this.assertPrivateSpaceList((UserIDAuth)auth, "./root.file", "root.file");
        });
        this.jane = this.checkUpdatedCredsWorkAndOldDont(this.jane, new ReadKeyPassword("Another passwd4"), auth -> {
            this.assertPrivateSpaceList((UserIDAuth)auth, "level1", "level1/file", "level1/level2/file");
            this.assertPrivateSpaceList((UserIDAuth)auth, "level1/", "level1/file", "level1/level2/file");
        });
        this.jane = this.checkUpdatedCredsWorkAndOldDont(this.jane, new ReadKeyPassword("Another passwd5"), auth -> {
            this.assertPrivateSpaceList((UserIDAuth)auth, "./level1", "level1/file", "level1/level2/file");
            this.assertPrivateSpaceList((UserIDAuth)auth, "./level1/", "level1/file", "level1/level2/file");
        });
        this.jane = this.checkUpdatedCredsWorkAndOldDont(this.jane, new ReadKeyPassword("Another passwd6"), auth -> {
            this.assertPrivateSpaceList((UserIDAuth)auth, "./level1/level2", "level1/level2/file");
            this.assertPrivateSpaceList((UserIDAuth)auth, "./level1/level2/", "level1/level2/file");
            this.assertPrivateSpaceList((UserIDAuth)auth, "level1/level2", "level1/level2/file");
            this.assertPrivateSpaceList((UserIDAuth)auth, "level1/level2/", "level1/level2/file");
        });
    }

    private void multishareFiles(UserIDAuth userOne, UserIDAuth userTwo, UserIDAuth userThree, String multiShareFile) {
        try (OutputStream os = this.writeToInbox.write(WriteRequest.forDefaultPublic((Object)ImmutableSet.of((Object)userOne.getUserID(), (Object)userTwo.getUserID(), (Object)userThree.getUserID()), (String)multiShareFile));){
            os.write("Hello here 1".getBytes());
        }
    }

    private UserIDAuth checkUpdatedCredsWorkAndOldDont(UserIDAuth auth, ReadKeyPassword newPassword, Consumer<UserIDAuth> withAuth) {
        this.profileUpdatingService.updateReadKeyPassword(auth, newPassword);
        org.junit.jupiter.api.Assertions.assertThrows(UnrecoverableKeyException.class, () -> withAuth.accept(auth));
        UserIDAuth newAuth = new UserIDAuth(auth.getUserID(), newPassword);
        withAuth.accept(newAuth);
        return newAuth;
    }

    private void init(WithStorageProvider.StorageDescriptor descriptor) {
        DefaultDatasafeServices datasafeServices = DatasafeServicesProvider.defaultDatasafeServices((StorageService)descriptor.getStorageService().get(), descriptor.getLocation());
        this.initialize(DatasafeServicesProvider.dfsConfig(descriptor.getLocation()), datasafeServices);
    }
}

