/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.business.impl.e2e.metrtics;

import de.adorsys.datasafe.business.impl.e2e.metrtics.RecordCollection;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.testcontainers.shaded.com.fasterxml.jackson.databind.SerializationFeature;

public class TestMetricCollector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TestMetricCollector.class);
    private Map<String, List<Long>> saveRecords = Collections.synchronizedMap(new HashMap());
    private Map<String, List<Long>> registerRecords = Collections.synchronizedMap(new HashMap());
    private int dataSize;
    private String storageType;
    private RecordCollection saveMetrics;
    private RecordCollection registerMetrics;
    private int numberOfThreads;

    public void writeToJSON() {
        this.saveMetrics = RecordCollection.builder().dataSize(this.dataSize).description("Save data").storage(this.storageType).records(this.saveRecords).build();
        this.registerMetrics = RecordCollection.builder().description("Register user").storage(this.storageType).records(this.registerRecords).build();
        ObjectMapper mapper = new ObjectMapper();
        mapper.enable(SerializationFeature.INDENT_OUTPUT);
        try {
            mapper.writeValue(new File(this.getFilePathForResultOfSaveTest()), (Object)this.saveMetrics);
            mapper.writeValue(new File(this.getFilePathForResultOfRegisterUserTest()), (Object)this.registerMetrics);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    private String getFilePathForResultOfRegisterUserTest() {
        return "./target/metrics_register_user_" + this.storageType + "_" + this.numberOfThreads + "pool_size.json";
    }

    private String getFilePathForResultOfSaveTest() {
        return "./target/metrics_save_" + this.storageType + "_" + this.dataSize + "bytes_" + this.numberOfThreads + "pool_size.json";
    }

    public void addRegisterRecords(String userName, Long operationDuration) {
        if (this.registerRecords.get(userName) == null) {
            this.registerRecords.put(userName, Collections.synchronizedList(new ArrayList()));
        }
        this.registerRecords.get(userName).add(operationDuration);
    }

    public void addSaveRecord(String user, Long operationDuration) {
        if (this.saveRecords.get(user) == null) {
            this.saveRecords.put(user, Collections.synchronizedList(new ArrayList()));
        }
        this.saveRecords.get(user).add(operationDuration);
    }

    @Generated
    public TestMetricCollector() {
    }

    @Generated
    public Map<String, List<Long>> getSaveRecords() {
        return this.saveRecords;
    }

    @Generated
    public Map<String, List<Long>> getRegisterRecords() {
        return this.registerRecords;
    }

    @Generated
    public int getDataSize() {
        return this.dataSize;
    }

    @Generated
    public String getStorageType() {
        return this.storageType;
    }

    @Generated
    public RecordCollection getSaveMetrics() {
        return this.saveMetrics;
    }

    @Generated
    public RecordCollection getRegisterMetrics() {
        return this.registerMetrics;
    }

    @Generated
    public int getNumberOfThreads() {
        return this.numberOfThreads;
    }

    @Generated
    public void setSaveRecords(Map<String, List<Long>> saveRecords) {
        this.saveRecords = saveRecords;
    }

    @Generated
    public void setRegisterRecords(Map<String, List<Long>> registerRecords) {
        this.registerRecords = registerRecords;
    }

    @Generated
    public void setDataSize(int dataSize) {
        this.dataSize = dataSize;
    }

    @Generated
    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    @Generated
    public void setSaveMetrics(RecordCollection saveMetrics) {
        this.saveMetrics = saveMetrics;
    }

    @Generated
    public void setRegisterMetrics(RecordCollection registerMetrics) {
        this.registerMetrics = registerMetrics;
    }

    @Generated
    public void setNumberOfThreads(int numberOfThreads) {
        this.numberOfThreads = numberOfThreads;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestMetricCollector)) {
            return false;
        }
        TestMetricCollector other = (TestMetricCollector)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, List<Long>> this$saveRecords = this.getSaveRecords();
        Map<String, List<Long>> other$saveRecords = other.getSaveRecords();
        if (this$saveRecords == null ? other$saveRecords != null : !((Object)this$saveRecords).equals(other$saveRecords)) {
            return false;
        }
        Map<String, List<Long>> this$registerRecords = this.getRegisterRecords();
        Map<String, List<Long>> other$registerRecords = other.getRegisterRecords();
        if (this$registerRecords == null ? other$registerRecords != null : !((Object)this$registerRecords).equals(other$registerRecords)) {
            return false;
        }
        if (this.getDataSize() != other.getDataSize()) {
            return false;
        }
        String this$storageType = this.getStorageType();
        String other$storageType = other.getStorageType();
        if (this$storageType == null ? other$storageType != null : !this$storageType.equals(other$storageType)) {
            return false;
        }
        RecordCollection this$saveMetrics = this.getSaveMetrics();
        RecordCollection other$saveMetrics = other.getSaveMetrics();
        if (this$saveMetrics == null ? other$saveMetrics != null : !((Object)this$saveMetrics).equals(other$saveMetrics)) {
            return false;
        }
        RecordCollection this$registerMetrics = this.getRegisterMetrics();
        RecordCollection other$registerMetrics = other.getRegisterMetrics();
        if (this$registerMetrics == null ? other$registerMetrics != null : !((Object)this$registerMetrics).equals(other$registerMetrics)) {
            return false;
        }
        return this.getNumberOfThreads() == other.getNumberOfThreads();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TestMetricCollector;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, List<Long>> $saveRecords = this.getSaveRecords();
        result = result * 59 + ($saveRecords == null ? 43 : ((Object)$saveRecords).hashCode());
        Map<String, List<Long>> $registerRecords = this.getRegisterRecords();
        result = result * 59 + ($registerRecords == null ? 43 : ((Object)$registerRecords).hashCode());
        result = result * 59 + this.getDataSize();
        String $storageType = this.getStorageType();
        result = result * 59 + ($storageType == null ? 43 : $storageType.hashCode());
        RecordCollection $saveMetrics = this.getSaveMetrics();
        result = result * 59 + ($saveMetrics == null ? 43 : ((Object)$saveMetrics).hashCode());
        RecordCollection $registerMetrics = this.getRegisterMetrics();
        result = result * 59 + ($registerMetrics == null ? 43 : ((Object)$registerMetrics).hashCode());
        result = result * 59 + this.getNumberOfThreads();
        return result;
    }

    @Generated
    public String toString() {
        return "TestMetricCollector(saveRecords=" + this.getSaveRecords() + ", registerRecords=" + this.getRegisterRecords() + ", dataSize=" + this.getDataSize() + ", storageType=" + this.getStorageType() + ", saveMetrics=" + this.getSaveMetrics() + ", registerMetrics=" + this.getRegisterMetrics() + ", numberOfThreads=" + this.getNumberOfThreads() + ")";
    }
}

