/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.business.impl.e2e;

import de.adorsys.datasafe.business.impl.service.DaggerDefaultDatasafeServices;
import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.impl.profile.config.DefaultDFSConfig;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.storage.api.SchemeDelegatingStorage;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.storage.impl.fs.FileSystemStorageService;
import de.adorsys.datasafe.teststorage.WithStorageProvider;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import de.adorsys.datasafe.types.api.resource.Uri;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.testcontainers.shaded.com.google.common.collect.ImmutableMap;

class SchemeDelegationTest
extends WithStorageProvider {
    private Path fsPath;
    private Uri minioPath;
    private StorageService minio;
    private StorageService filesystem;
    private DefaultDatasafeServices datasafeServices;

    SchemeDelegationTest() {
    }

    @BeforeEach
    void initialize(@TempDir Path tempDir) {
        WithStorageProvider.StorageDescriptor minioDescriptor = SchemeDelegationTest.minio();
        this.fsPath = tempDir;
        this.minio = (StorageService)minioDescriptor.getStorageService().get();
        this.filesystem = new FileSystemStorageService(tempDir);
        this.minioPath = minioDescriptor.getLocation();
        SchemeDelegatingStorage multiDfs = new SchemeDelegatingStorage((Map)ImmutableMap.of((Object)"s3", (Object)this.minio, (Object)"file", (Object)this.filesystem));
        this.datasafeServices = DaggerDefaultDatasafeServices.builder().config((DFSConfig)new ProfilesOnFsDataOnMinio(this.minioPath, tempDir)).storage((StorageService)multiDfs).build();
    }

    @Test
    void testProfileOnFsDataOnMinioWorks() {
        UserIDAuth userJohn = new UserIDAuth("john", "doe");
        this.datasafeServices.userProfile().registerUsingDefaults(userJohn);
        try (OutputStream os = this.datasafeServices.privateService().write(WriteRequest.forDefaultPrivate((Object)userJohn, (String)"file.txt"));){
            os.write("Hello".getBytes());
        }
        Assertions.assertThat(Files.walk(this.fsPath, new FileVisitOption[0])).extracting(it -> this.fsPath.relativize((Path)it)).extracting(Path::toString).containsExactlyInAnyOrder((Object[])new String[]{"", "public-john", "private-john"});
        ((AbstractListAssert)((AbstractListAssert)Assertions.assertThat((Stream)this.minio.list(new AbsoluteLocation((ResourceLocation)BasePrivateResource.forPrivate((Uri)this.minioPath.resolve(""))))).extracting(it -> this.minioPath.relativize(it.location())).extracting(it -> it.asURI().toString()).contains((Object[])new String[]{"users/john/private/keystore", "users/john/public/pubkeys"})).anyMatch(it -> it.startsWith("users/john/private/files/"))).hasSize(3);
    }

    static class ProfilesOnFsDataOnMinio
    extends DefaultDFSConfig {
        private final Path profilesPath;

        ProfilesOnFsDataOnMinio(Uri minioBucketPath, Path profilesPath) {
            super(minioBucketPath, "PAZZWORT");
            this.profilesPath = profilesPath;
        }

        public AbsoluteLocation publicProfile(UserID forUser) {
            return new AbsoluteLocation((ResourceLocation)BasePrivateResource.forPrivate((URI)this.profilesPath.resolve("public-" + forUser.getValue()).toUri()));
        }

        public AbsoluteLocation privateProfile(UserID forUser) {
            return new AbsoluteLocation((ResourceLocation)BasePrivateResource.forPrivate((URI)this.profilesPath.resolve("private-" + forUser.getValue()).toUri()));
        }
    }
}

