/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.business.impl.e2e.performance.fixture.generator;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import lombok.Generated;
import org.testcontainers.shaded.com.google.common.collect.ImmutableList;

public class RandomPathGenerator {
    public static final List<String> DEFAULT_COMPONENTS = ImmutableList.of((Object)"home", (Object)"documents", (Object)"important");
    public static final List<String> DEFAULT_FILENAMES = ImmutableList.of((Object)"file.txt", (Object)"document.pdf", (Object)"presentation.ppt", (Object)"balance.xlsx");
    private final Random random;
    private final int maxDepth;
    private final List<String> pathComponents;
    private final List<String> filenames;

    public String generate() {
        List components = Stream.of(this.generatePath(), this.generateFilename()).filter(it -> !it.isEmpty()).collect(Collectors.toList());
        return "./" + String.join((CharSequence)"/", components);
    }

    public String generateInbox() {
        return "./" + this.generateFilename();
    }

    private String generatePath() {
        ArrayList components = new ArrayList();
        IntStream.range(0, this.random.nextInt(this.maxDepth)).forEach(it -> components.add(this.pathComponents.get(this.random.nextInt(this.pathComponents.size()))));
        return String.join((CharSequence)"/", components);
    }

    private String generateFilename() {
        return this.filenames.get(this.random.nextInt(this.filenames.size()));
    }

    @Generated
    public RandomPathGenerator(Random random, int maxDepth, List<String> pathComponents, List<String> filenames) {
        this.random = random;
        this.maxDepth = maxDepth;
        this.pathComponents = pathComponents;
        this.filenames = filenames;
    }
}

