/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.business.impl.e2e.performance.fixture.dto;

import com.google.common.collect.Iterables;
import de.adorsys.datasafe.business.impl.e2e.performance.fixture.dto.ContentId;
import de.adorsys.datasafe.business.impl.e2e.performance.fixture.dto.Operation;
import de.adorsys.datasafe.business.impl.e2e.performance.fixture.dto.OperationType;
import de.adorsys.datasafe.business.impl.e2e.performance.fixture.dto.StorageType;
import de.adorsys.datasafe.business.impl.e2e.performance.fixture.dto.TestUser;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestFileTree {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TestFileTree.class);
    @Generated
    private final Object $lock = new Object[0];
    private final Consumer<Operation> publishTo;
    private final TestUser testUser;
    private final StorageType storageType;
    private final Random random;
    private final Map<String, ContentId> files = new HashMap<String, ContentId>();

    public boolean isEmpty() {
        return this.files.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String path, ContentId id) {
        Object object = this.$lock;
        synchronized (object) {
            if (null == id) {
                throw new IllegalArgumentException("No content");
            }
            log.info(">PUT [{}]:{} to {}", new Object[]{this.storageTag(), id, path});
            this.files.put(path, id);
            this.publishTo.accept(new Operation(this.testUser.getUsername(), OperationType.WRITE, this.storageType, id, URI.create(path), null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentId read(String path) {
        Object object = this.$lock;
        synchronized (object) {
            ContentId value = this.files.get(path);
            if (null == value) {
                throw new IllegalArgumentException("Reading null path");
            }
            log.info(">GET [{}]:{}:{}", new Object[]{this.storageTag(), path, value});
            this.publishTo.accept(new Operation(this.testUser.getUsername(), OperationType.READ, this.storageType, null, URI.create(path), value));
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> list(String path) {
        Object object = this.$lock;
        synchronized (object) {
            log.info(">LIST [{}]:{}", (Object)this.storageTag(), (Object)path);
            this.publishTo.accept(new Operation(this.testUser.getUsername(), OperationType.LIST, this.storageType, null, URI.create(path), null));
            return this.files.keySet().stream().filter(it -> it.startsWith(path)).collect(Collectors.toSet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(String path) {
        Object object = this.$lock;
        synchronized (object) {
            ContentId value = this.files.get(path);
            if (null == value) {
                throw new IllegalArgumentException("Deleting non-existing path");
            }
            log.info(">DELETE [{}]:{}:{}", new Object[]{this.storageTag(), path, value});
            this.files.remove(path);
            this.publishTo.accept(new Operation(this.testUser.getUsername(), OperationType.DELETE, this.storageType, null, URI.create(path), value));
        }
    }

    public String getPathRandomly() {
        log.info("GET RANDOMLY [{}]", (Object)this.storageTag());
        return (String)Iterables.get(this.files.keySet(), (int)this.random.nextInt(this.files.size()));
    }

    private String storageTag() {
        return this.testUser.getUsername() + "/" + (Object)((Object)this.storageType);
    }

    @Generated
    public TestFileTree(Consumer<Operation> publishTo, TestUser testUser, StorageType storageType, Random random) {
        this.publishTo = publishTo;
        this.testUser = testUser;
        this.storageType = storageType;
        this.random = random;
    }

    @Generated
    public Consumer<Operation> getPublishTo() {
        return this.publishTo;
    }

    @Generated
    public TestUser getTestUser() {
        return this.testUser;
    }

    @Generated
    public StorageType getStorageType() {
        return this.storageType;
    }

    @Generated
    public Random getRandom() {
        return this.random;
    }

    @Generated
    public Map<String, ContentId> getFiles() {
        return this.files;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestFileTree)) {
            return false;
        }
        TestFileTree other = (TestFileTree)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Consumer<Operation> this$publishTo = this.getPublishTo();
        Consumer<Operation> other$publishTo = other.getPublishTo();
        if (this$publishTo == null ? other$publishTo != null : !this$publishTo.equals(other$publishTo)) {
            return false;
        }
        TestUser this$testUser = this.getTestUser();
        TestUser other$testUser = other.getTestUser();
        if (this$testUser == null ? other$testUser != null : !((Object)this$testUser).equals(other$testUser)) {
            return false;
        }
        StorageType this$storageType = this.getStorageType();
        StorageType other$storageType = other.getStorageType();
        if (this$storageType == null ? other$storageType != null : !((Object)((Object)this$storageType)).equals((Object)other$storageType)) {
            return false;
        }
        Random this$random = this.getRandom();
        Random other$random = other.getRandom();
        if (this$random == null ? other$random != null : !this$random.equals(other$random)) {
            return false;
        }
        Map<String, ContentId> this$files = this.getFiles();
        Map<String, ContentId> other$files = other.getFiles();
        return !(this$files == null ? other$files != null : !((Object)this$files).equals(other$files));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TestFileTree;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Consumer<Operation> $publishTo = this.getPublishTo();
        result = result * 59 + ($publishTo == null ? 43 : $publishTo.hashCode());
        TestUser $testUser = this.getTestUser();
        result = result * 59 + ($testUser == null ? 43 : ((Object)$testUser).hashCode());
        StorageType $storageType = this.getStorageType();
        result = result * 59 + ($storageType == null ? 43 : ((Object)((Object)$storageType)).hashCode());
        Random $random = this.getRandom();
        result = result * 59 + ($random == null ? 43 : $random.hashCode());
        Map<String, ContentId> $files = this.getFiles();
        result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TestFileTree(publishTo=" + this.getPublishTo() + ", testUser=" + this.getTestUser() + ", storageType=" + (Object)((Object)this.getStorageType()) + ", random=" + this.getRandom() + ", files=" + this.getFiles() + ")";
    }
}

