/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.business.impl.e2e.performance;

import de.adorsys.datasafe.business.impl.e2e.DatasafeServicesProvider;
import de.adorsys.datasafe.business.impl.e2e.performance.WithRandomActionPerformance;
import de.adorsys.datasafe.business.impl.e2e.performance.services.OperationExecutor;
import de.adorsys.datasafe.business.impl.e2e.performance.services.StatisticService;
import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import de.adorsys.datasafe.business.impl.service.VersionedDatasafeServices;
import de.adorsys.datasafe.privatestore.api.PrivateSpaceService;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class MinioPerformance
extends WithRandomActionPerformance {
    MinioPerformance() {
    }

    @ParameterizedTest
    @MethodSource(value={"sizesAndLatency"})
    @EnabledIfEnvironmentVariable(named="MINIO_PERFORMANCE_TEST", matches="true")
    void testMinioVersionedPerformance(int size, int latency) {
        WithRandomActionPerformance.DelegatingStorageWithDelay service = this.storageService(MinioPerformance.minio(), latency);
        VersionedDatasafeServices services = DatasafeServicesProvider.versionedDatasafeServices(service, service.getRootLocation());
        this.initialize(DatasafeServicesProvider.dfsConfig(service.getRootLocation()), services);
        this.initUsers(size);
        OperationExecutor executor = new OperationExecutor((PrivateSpaceService)services.latestPrivate(), services.inboxService(), this.users, STATS.computeIfAbsent(MinioPerformance.named("MINIO VERSIONED ", size, latency), id -> new StatisticService()));
        this.executeOperations(executor);
    }

    @ParameterizedTest
    @MethodSource(value={"sizesAndLatency"})
    @EnabledIfEnvironmentVariable(named="MINIO_PERFORMANCE_TEST", matches="true")
    void testMinioNonVersionedPerformance(int size, int latency) {
        WithRandomActionPerformance.DelegatingStorageWithDelay service = this.storageService(MinioPerformance.minio(), latency);
        DefaultDatasafeServices services = DatasafeServicesProvider.defaultDatasafeServices(service, service.getRootLocation());
        this.initialize(DatasafeServicesProvider.dfsConfig(service.getRootLocation()), services);
        this.initUsers(size);
        OperationExecutor executor = new OperationExecutor(services.privateService(), services.inboxService(), this.users, STATS.computeIfAbsent(MinioPerformance.named("MINIO ", size, latency), id -> new StatisticService()));
        this.executeOperations(executor);
    }
}

