/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.business.impl.e2e.performance;

import de.adorsys.datasafe.business.impl.e2e.DatasafeServicesProvider;
import de.adorsys.datasafe.business.impl.e2e.performance.WithRandomActionPerformance;
import de.adorsys.datasafe.business.impl.e2e.performance.services.OperationExecutor;
import de.adorsys.datasafe.business.impl.e2e.performance.services.StatisticService;
import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class CephPerformance
extends WithRandomActionPerformance {
    CephPerformance() {
    }

    @ParameterizedTest
    @MethodSource(value={"sizesAndLatency"})
    @EnabledIfEnvironmentVariable(named="CEPH_PERFORMANCE_TEST", matches="true")
    void testCephBucketPerformance(int size, int latency) {
        WithRandomActionPerformance.DelegatingStorageWithDelay service = this.storageService(CephPerformance.cephVersioned(), latency);
        DefaultDatasafeServices services = DatasafeServicesProvider.defaultDatasafeServices(service, service.getRootLocation());
        this.initialize(DatasafeServicesProvider.dfsConfig(service.getRootLocation()), services);
        this.initUsers(size);
        OperationExecutor executor = new OperationExecutor(services.privateService(), services.inboxService(), this.users, STATS.computeIfAbsent(CephPerformance.named("CEPH ", size, latency), id -> new StatisticService()));
        this.executeOperations(executor);
    }
}

