/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.business.impl.e2e.performance;

import de.adorsys.datasafe.business.impl.e2e.DatasafeServicesProvider;
import de.adorsys.datasafe.business.impl.e2e.performance.WithRandomActionPerformance;
import de.adorsys.datasafe.business.impl.e2e.performance.services.OperationExecutor;
import de.adorsys.datasafe.business.impl.e2e.performance.services.StatisticService;
import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariable;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class AmazonPerformance
extends WithRandomActionPerformance {
    AmazonPerformance() {
    }

    @ParameterizedTest
    @MethodSource(value={"sizesAndLatency"})
    @EnabledIfEnvironmentVariable(named="AMAZON_PERFORMANCE_TEST", matches="true")
    void testAmazonBucketPerformance(int size, int latency) {
        WithRandomActionPerformance.DelegatingStorageWithDelay service = this.storageService(AmazonPerformance.s3(), latency);
        DefaultDatasafeServices services = DatasafeServicesProvider.defaultDatasafeServices(service, service.getRootLocation());
        this.initialize(DatasafeServicesProvider.dfsConfig(service.getRootLocation()), services);
        this.initUsers(size);
        OperationExecutor executor = new OperationExecutor(services.privateService(), services.inboxService(), this.users, STATS.computeIfAbsent(AmazonPerformance.named("AMAZON BUCKET ", size, latency), id -> new StatisticService()));
        this.executeOperations(executor);
    }
}

