/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.business.impl.e2e;

import com.google.common.io.ByteStreams;
import de.adorsys.datasafe.business.impl.e2e.BaseE2ETest;
import de.adorsys.datasafe.business.impl.e2e.DatasafeServicesProvider;
import de.adorsys.datasafe.business.impl.e2e.WithStorageProvider;
import de.adorsys.datasafe.business.impl.service.VersionedDatasafeServices;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.types.api.actions.ListRequest;
import de.adorsys.datasafe.types.api.actions.ReadRequest;
import de.adorsys.datasafe.types.api.actions.RemoveRequest;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import de.adorsys.datasafe.types.api.resource.Uri;
import de.adorsys.datasafe.types.api.resource.Version;
import de.adorsys.datasafe.types.api.resource.Versioned;
import de.adorsys.datasafe.types.api.shared.Position;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionedDataTest
extends BaseE2ETest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(VersionedDataTest.class);
    private static final String MESSAGE_ONE = "Hello here 1";
    private static final String MESSAGE_TWO = "Hello here 2";
    private static final String MESSAGE_THREE = "Hello here 3";
    private static final String FOLDER = "folder1";
    private static final String PRIVATE_FILE = "secret.txt";
    private static final String PRIVATE_FILE_PATH = "folder1/secret.txt";
    private VersionedDatasafeServices versionedDocusafeServices;

    @ParameterizedTest
    @MethodSource(value={"allDefaultStorages"})
    void testVersionedWriteTopLevel(WithStorageProvider.StorageDescriptor descriptor) {
        this.init(descriptor);
        this.registerAndDoWritesWithDiffMessageInSameLocation();
        String readingResult = this.readPrivateUsingPrivateKey(this.jane, BasePrivateResource.forPrivate((String)PRIVATE_FILE_PATH));
        Assertions.assertThat((String)readingResult).isEqualTo((Object)MESSAGE_THREE);
        this.validateThereAreVersions(this.jane, 3);
    }

    @ParameterizedTest
    @MethodSource(value={"allDefaultStorages"})
    void testUserIsRemovedWithFiles(WithStorageProvider.StorageDescriptor descriptor) {
        this.init(descriptor);
        UserID userJohn = new UserID("john");
        this.john = this.registerUser(userJohn.getValue());
        this.writeDataToPrivate(this.john, "root.txt", MESSAGE_ONE);
        this.writeDataToPrivate(this.john, "some/some.txt", MESSAGE_ONE);
        this.writeDataToPrivate(this.john, "some/other/other.txt", MESSAGE_ONE);
        this.profileRemovalService.deregister(this.john);
        this.assertRootDirIsEmpty(descriptor);
    }

    @ParameterizedTest
    @MethodSource(value={"allDefaultStorages"})
    void testVersionedWriteUsingAbsoluteAccess(WithStorageProvider.StorageDescriptor descriptor) {
        this.init(descriptor);
        this.registerAndDoWritesWithDiffMessageInSameLocation();
        Versioned first = (Versioned)Position.first(this.versionedListRoot(this.jane));
        String directResult = this.readPrivateUsingPrivateKey(this.jane, ((ResolvedResource)first.stripVersion()).asPrivate());
        Assertions.assertThat((String)directResult).isEqualTo((Object)MESSAGE_THREE);
        Assertions.assertThat((Object)((ResolvedResource)first.stripVersion()).asPrivate().decryptedPath()).asString().contains(new CharSequence[]{PRIVATE_FILE_PATH});
        this.validateThereAreVersions(this.jane, 3);
    }

    @ParameterizedTest
    @MethodSource(value={"allDefaultStorages"})
    void testVersionedRemove(WithStorageProvider.StorageDescriptor descriptor) {
        this.init(descriptor);
        this.registerAndDoWritesWithDiffMessageInSameLocation();
        Versioned first = (Versioned)Position.first(this.versionedListRoot(this.jane));
        this.versionedDocusafeServices.latestPrivate().remove(RemoveRequest.forPrivate((Object)this.jane, (PrivateResource)((ResolvedResource)first.stripVersion()).asPrivate()));
        Assertions.assertThat(this.listRoot(this.jane)).isEmpty();
        this.validateThereAreVersions(this.jane, 3);
    }

    @ParameterizedTest
    @MethodSource(value={"allDefaultStorages"})
    void testVersionsOf(WithStorageProvider.StorageDescriptor descriptor) {
        this.init(descriptor);
        this.registerAndDoWritesWithDiffMessageInSameLocation();
        List versionedResource = this.versionedDocusafeServices.versionInfo().versionsOf(ListRequest.forDefaultPrivate((Object)this.jane, (String)"./")).collect(Collectors.toList());
        Assertions.assertThat(versionedResource).hasSize(3);
        Assertions.assertThat(versionedResource).extracting(Versioned::stripVersion).extracting(ResourceLocation::location).extracting(Uri::toASCIIString).containsExactly((Object[])new String[]{PRIVATE_FILE_PATH, PRIVATE_FILE_PATH, PRIVATE_FILE_PATH});
    }

    @ParameterizedTest
    @MethodSource(value={"allDefaultStorages"})
    void testVersionsOfDirectPath(WithStorageProvider.StorageDescriptor descriptor) {
        this.init(descriptor);
        this.registerAndDoWritesWithDiffMessageInSameLocation();
        List versionedResource = this.versionedDocusafeServices.versionInfo().versionsOf(ListRequest.forDefaultPrivate((Object)this.jane, (String)PRIVATE_FILE_PATH)).collect(Collectors.toList());
        Assertions.assertThat(versionedResource).hasSize(3);
        Assertions.assertThat(versionedResource).extracting(Versioned::stripVersion).extracting(ResourceLocation::location).extracting(Uri::toASCIIString).containsExactly((Object[])new String[]{PRIVATE_FILE_PATH, PRIVATE_FILE_PATH, PRIVATE_FILE_PATH});
    }

    @ParameterizedTest
    @MethodSource(value={"allDefaultStorages"})
    void testOldRemoval(WithStorageProvider.StorageDescriptor descriptor) {
        this.init(descriptor);
        this.registerAndDoWritesWithDiffMessageInSameLocation();
        List versionedResource = this.versionedDocusafeServices.versionInfo().listJoinedWithLatest(ListRequest.forDefaultPrivate((Object)this.jane, (String)"./")).collect(Collectors.toList());
        List<ResolvedResource> toRemove = versionedResource.stream().filter(it -> !((ResolvedResource)it.stripVersion()).location().equals((Object)((AbsoluteLocation)it.absolute()).location())).map(Versioned::absolute).map(AbsoluteLocation::getResource).collect(Collectors.toList());
        toRemove.forEach(it -> this.versionedDocusafeServices.privateService().remove(RemoveRequest.forPrivate((Object)this.jane, (PrivateResource)it.asPrivate())));
        String readingResult = this.readPrivateUsingPrivateKey(this.jane, BasePrivateResource.forPrivate((String)PRIVATE_FILE_PATH));
        Assertions.assertThat((String)readingResult).isEqualTo((Object)MESSAGE_THREE);
        this.validateThereAreVersions(this.jane, 1);
    }

    @ParameterizedTest
    @MethodSource(value={"allDefaultStorages"})
    void listingValidation(WithStorageProvider.StorageDescriptor descriptor) {
        this.init(descriptor);
        this.registerJohnAndJane();
        this.writeDataToPrivate(this.jane, "root.file", MESSAGE_ONE);
        this.writeDataToPrivate(this.jane, "root.file", MESSAGE_ONE);
        this.writeDataToPrivate(this.jane, "root.file", MESSAGE_THREE);
        this.writeDataToPrivate(this.jane, "level1/file", MESSAGE_ONE);
        this.writeDataToPrivate(this.jane, "level1/level2/file", MESSAGE_ONE);
        this.writeDataToPrivate(this.jane, "level1/level2/file", MESSAGE_THREE);
        this.writeDataToPrivate(this.jane, "root.file", MESSAGE_ONE);
        this.writeDataToPrivate(this.jane, "level1/file", MESSAGE_ONE);
        this.writeDataToPrivate(this.jane, "level1/level2/file", MESSAGE_ONE);
        this.assertPrivateSpaceList(this.jane, "", "root.file", "level1/file", "level1/level2/file");
        this.assertPrivateSpaceList(this.jane, "./", "root.file", "level1/file", "level1/level2/file");
        this.assertPrivateSpaceList(this.jane, ".", "root.file", "level1/file", "level1/level2/file");
        this.assertPrivateSpaceList(this.jane, "root.file", "root.file");
        this.assertPrivateSpaceList(this.jane, "./root.file", "root.file");
        this.assertPrivateSpaceList(this.jane, "level1", "level1/file", "level1/level2/file");
        this.assertPrivateSpaceList(this.jane, "level1/", "level1/file", "level1/level2/file");
        this.assertPrivateSpaceList(this.jane, "./level1", "level1/file", "level1/level2/file");
        this.assertPrivateSpaceList(this.jane, "./level1/", "level1/file", "level1/level2/file");
        this.assertPrivateSpaceList(this.jane, "./level1/level2", "level1/level2/file");
        this.assertPrivateSpaceList(this.jane, "./level1/level2/", "level1/level2/file");
        this.assertPrivateSpaceList(this.jane, "level1/level2", "level1/level2/file");
        this.assertPrivateSpaceList(this.jane, "level1/level2/", "level1/level2/file");
    }

    @Override
    protected void writeDataToPrivate(UserIDAuth auth, String path, String data) {
        try (OutputStream stream = this.writeToPrivate.write(WriteRequest.forDefaultPrivate((Object)auth, (String)path));){
            stream.write(data.getBytes());
        }
    }

    @Override
    protected String readPrivateUsingPrivateKey(UserIDAuth user, PrivateResource location) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (InputStream dataStream = this.readFromPrivate.read(ReadRequest.forPrivate((Object)user, (PrivateResource)location));){
            ByteStreams.copy((InputStream)dataStream, (OutputStream)outputStream);
        }
        return new String(outputStream.toByteArray());
    }

    protected String readRawPrivateUsingPrivateKey(UserIDAuth user, PrivateResource location) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try (InputStream dataStream = this.versionedDocusafeServices.privateService().read(ReadRequest.forPrivate((Object)user, (PrivateResource)location));){
            ByteStreams.copy((InputStream)dataStream, (OutputStream)outputStream);
        }
        return new String(outputStream.toByteArray());
    }

    @Override
    protected AbsoluteLocation<ResolvedResource> getFirstFileInPrivate(UserIDAuth owner) {
        List files = this.listRoot(owner).collect(Collectors.toList());
        log.info("{} has {} in PRIVATE", (Object)owner.getUserID().getValue(), files);
        return (AbsoluteLocation)files.get(0);
    }

    private Stream<AbsoluteLocation<ResolvedResource>> listRoot(UserIDAuth owner) {
        return this.listPrivate.list(ListRequest.forDefaultPrivate((Object)owner, (String)"./"));
    }

    private Stream<Versioned<AbsoluteLocation<PrivateResource>, ResolvedResource, Version>> versionedListRoot(UserIDAuth owner) {
        return this.versionedDocusafeServices.latestPrivate().listWithDetails(ListRequest.forDefaultPrivate((Object)owner, (String)"./"));
    }

    private void init(WithStorageProvider.StorageDescriptor descriptor) {
        VersionedDatasafeServices datasafeServices = DatasafeServicesProvider.versionedDatasafeServices(descriptor.getStorageService().get(), descriptor.getLocation());
        this.initialize(DatasafeServicesProvider.dfsConfig(descriptor.getLocation()), datasafeServices);
        this.versionedDocusafeServices = datasafeServices;
    }

    private void registerAndDoWritesWithDiffMessageInSameLocation() {
        this.registerJohnAndJane();
        this.writeDataToPrivate(this.jane, PRIVATE_FILE_PATH, MESSAGE_ONE);
        this.writeDataToPrivate(this.jane, PRIVATE_FILE_PATH, MESSAGE_TWO);
        this.writeDataToPrivate(this.jane, PRIVATE_FILE_PATH, MESSAGE_THREE);
    }

    private void validateThereAreVersions(UserIDAuth user, int versionCount) {
        Assertions.assertThat((Stream)this.versionedDocusafeServices.privateService().list(ListRequest.forDefaultPrivate((Object)user, (String)"./"))).hasSize(versionCount);
    }
}

