/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.business.impl.e2e;

import de.adorsys.datasafe.business.impl.e2e.BaseE2ETest;
import de.adorsys.datasafe.business.impl.e2e.DatasafeServicesProvider;
import de.adorsys.datasafe.business.impl.e2e.WithStorageProvider;
import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.types.api.actions.ReadRequest;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.callback.PhysicalVersionCallback;
import de.adorsys.datasafe.types.api.callback.ResourceWriteCallback;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.StorageVersion;
import de.adorsys.datasafe.types.api.resource.Version;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testcontainers.shaded.com.google.common.io.ByteStreams;

class StorageBasedVersioningTest
extends BaseE2ETest {
    private static final String FILE = "file.txt";

    StorageBasedVersioningTest() {
    }

    @Test
    void testVersionedWriteReturnsVersionId() {
        this.init(StorageBasedVersioningTest.cephVersioned());
        this.registerJohnAndJane();
        String version = this.writeAndGetVersion(this.jane, FILE, "Hello");
        Assertions.assertThat((String)version).isNotBlank();
    }

    @Test
    void testVersionedWriteSequenceAndThenReadLatest() {
        this.init(StorageBasedVersioningTest.cephVersioned());
        this.registerJohnAndJane();
        this.writeAndGetVersion(this.jane, FILE, "Hello 1");
        this.writeAndGetVersion(this.jane, FILE, "Hello 2");
        this.writeAndGetVersion(this.jane, FILE, "Hello 3");
        Assertions.assertThat((String)this.readPrivateUsingPrivateKey(this.jane, BasePrivateResource.forPrivate((String)FILE))).isEqualTo((Object)"Hello 3");
    }

    @Test
    void testVersionedWriteSequenceAndThenReadByVersion() {
        this.init(StorageBasedVersioningTest.cephVersioned());
        this.registerJohnAndJane();
        String oldVersion = this.writeAndGetVersion(this.jane, FILE, "Hello 1");
        this.writeAndGetVersion(this.jane, FILE, "Hello 2");
        this.writeAndGetVersion(this.jane, FILE, "Hello 3");
        Assertions.assertThat((String)this.readByVersion(this.jane, FILE, new StorageVersion(oldVersion))).isEqualTo((Object)"Hello 1");
    }

    private String writeAndGetVersion(UserIDAuth user, String path, String data) {
        AtomicReference version = new AtomicReference();
        try (OutputStream os = this.writeToPrivate.write(WriteRequest.forDefaultPrivate((Object)user, (String)path).toBuilder().callback((ResourceWriteCallback)((PhysicalVersionCallback)version::set)).build());){
            os.write(data.getBytes());
        }
        return (String)version.get();
    }

    private String readByVersion(UserIDAuth user, String path, StorageVersion version) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try (InputStream is = this.readFromPrivate.read(ReadRequest.forDefaultPrivateWithVersion((Object)user, (String)path, (Version)version));){
            ByteStreams.copy((InputStream)is, (OutputStream)os);
        }
        return new String(os.toByteArray(), StandardCharsets.UTF_8);
    }

    private void init(WithStorageProvider.StorageDescriptor descriptor) {
        DefaultDatasafeServices datasafeServices = DatasafeServicesProvider.defaultDatasafeServices(descriptor.getStorageService().get(), descriptor.getLocation());
        this.initialize(DatasafeServicesProvider.dfsConfig(descriptor.getLocation()), datasafeServices);
    }
}

