/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.business.impl.e2e.performance.services;

import com.google.common.math.Quantiles;
import com.google.gson.Gson;
import de.adorsys.datasafe.business.impl.e2e.performance.fixture.dto.Operation;
import de.adorsys.datasafe.business.impl.e2e.performance.fixture.dto.OperationType;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.com.google.common.collect.ImmutableMap;

public class StatisticService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatisticService.class);
    private final Map<OperationType, List<Integer>> performanceInMsByOp = new ConcurrentHashMap<OperationType, List<Integer>>();

    public void reportOperationPerformance(Operation oper, int duration) {
        this.performanceInMsByOp.computeIfAbsent(oper.getType(), id -> new CopyOnWriteArrayList()).add(duration);
    }

    public Map<OperationType, Percentiles> generateReport() {
        return this.performanceInMsByOp.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, it -> new Percentiles((List)it.getValue())));
    }

    public String reportAsJson(String name) {
        return new Gson().toJson((Object)ImmutableMap.of((Object)name, this.generateReport()));
    }

    @Generated
    public StatisticService() {
    }

    public static class Percentiles {
        private final Map<Integer, Double> stat;

        private Percentiles(List<Integer> values) {
            this.stat = Quantiles.percentiles().indexes(new int[]{50, 75, 90, 95, 99}).compute(values);
        }

        @Generated
        public Map<Integer, Double> getStat() {
            return this.stat;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Percentiles)) {
                return false;
            }
            Percentiles other = (Percentiles)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<Integer, Double> this$stat = this.getStat();
            Map<Integer, Double> other$stat = other.getStat();
            return !(this$stat == null ? other$stat != null : !((Object)this$stat).equals(other$stat));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Percentiles;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<Integer, Double> $stat = this.getStat();
            result = result * 59 + ($stat == null ? 43 : ((Object)$stat).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "StatisticService.Percentiles(stat=" + this.getStat() + ")";
        }
    }
}

