/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.business.impl.e2e.performance.services;

import com.google.common.io.ByteStreams;
import de.adorsys.datasafe.business.impl.e2e.performance.dto.UserSpec;
import de.adorsys.datasafe.business.impl.e2e.performance.fixture.dto.Operation;
import de.adorsys.datasafe.business.impl.e2e.performance.fixture.dto.OperationType;
import de.adorsys.datasafe.business.impl.e2e.performance.fixture.dto.StorageType;
import de.adorsys.datasafe.business.impl.e2e.performance.services.StatisticService;
import de.adorsys.datasafe.directory.impl.profile.exceptions.UserNotFoundException;
import de.adorsys.datasafe.inbox.api.InboxService;
import de.adorsys.datasafe.privatestore.api.PrivateSpaceService;
import de.adorsys.datasafe.types.api.actions.ListRequest;
import de.adorsys.datasafe.types.api.actions.ReadRequest;
import de.adorsys.datasafe.types.api.actions.RemoveRequest;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.shaded.com.google.common.collect.ImmutableMap;

public class OperationExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OperationExecutor.class);
    private final Map<OperationType, Consumer<Operation>> handlers = ImmutableMap.of((Object)((Object)OperationType.WRITE), this::doWrite, (Object)((Object)OperationType.READ), this::doRead, (Object)((Object)OperationType.LIST), this::doList, (Object)((Object)OperationType.DELETE), this::doDelete);
    private final AtomicLong counter = new AtomicLong();
    private final PrivateSpaceService privateSpace;
    private final InboxService inboxService;
    private final Map<String, UserSpec> users;
    private final StatisticService statisticService;

    public void execute(Operation oper) {
        long cnt = this.counter.incrementAndGet();
        log.trace("[{}] [{} {}/{}/{}] Executing {}", new Object[]{cnt, oper.getType(), oper.getUserId(), oper.getStorageType(), oper.getLocation(), oper});
        long start = System.currentTimeMillis();
        this.handlers.get((Object)oper.getType()).accept(oper);
        long end = System.currentTimeMillis();
        this.statisticService.reportOperationPerformance(oper, (int)(end - start));
        if (0L == cnt % 100L) {
            log.info("[{}] Done operations", (Object)cnt);
        }
    }

    public void doWrite(Operation oper) {
        UserSpec user = this.requireUser(oper);
        try (OutputStream os = this.openWriteStream(user, oper);){
            ByteStreams.copy((InputStream)user.getGenerator().generate(oper.getContentId().getId()), (OutputStream)os);
        }
    }

    public void doRead(Operation oper) {
        UserSpec user = this.requireUser(oper);
        try (InputStream is = this.openReadStream(user, oper);){
            byte[] users = this.digest(is);
            byte[] expected = this.digest(user.getGenerator().generate(oper.getExpected().getId()));
            if (!Arrays.equals(users, expected)) {
                log.error("Checksum mismatch for {}", (Object)oper);
                throw new IllegalArgumentException("Failed reading - checksum mismatch");
            }
        }
    }

    public void doList(Operation oper) {
        UserSpec user = this.requireUser(oper);
        List resources = this.listResources(user, oper).collect(Collectors.toList());
        if (resources.isEmpty()) {
            log.info("Empty bucket");
        }
    }

    public void doDelete(Operation oper) {
        UserSpec user = this.requireUser(oper);
        RemoveRequest request = RemoveRequest.forDefaultPrivate((Object)user.getAuth(), (URI)oper.getLocation());
        if (StorageType.INBOX.equals((Object)oper.getStorageType())) {
            this.inboxService.remove(request);
            return;
        }
        this.privateSpace.remove(request);
    }

    private OutputStream openWriteStream(UserSpec user, Operation oper) {
        if (StorageType.INBOX.equals((Object)oper.getStorageType())) {
            return this.inboxService.write(WriteRequest.forDefaultPublic(Collections.singleton(user.getAuth().getUserID()), (URI)oper.getLocation()));
        }
        return this.privateSpace.write(WriteRequest.forDefaultPrivate((Object)user.getAuth(), (URI)oper.getLocation()));
    }

    private InputStream openReadStream(UserSpec user, Operation oper) {
        ReadRequest request = ReadRequest.forDefaultPrivate((Object)user.getAuth(), (URI)oper.getLocation());
        if (StorageType.INBOX.equals((Object)oper.getStorageType())) {
            return this.inboxService.read(request);
        }
        return this.privateSpace.read(ReadRequest.forDefaultPrivate((Object)user.getAuth(), (URI)oper.getLocation()));
    }

    private Stream<AbsoluteLocation<ResolvedResource>> listResources(UserSpec user, Operation oper) {
        ListRequest request = ListRequest.forDefaultPrivate((Object)user.getAuth(), (URI)oper.getLocation());
        if (StorageType.INBOX.equals((Object)oper.getStorageType())) {
            return this.inboxService.list(request);
        }
        return this.privateSpace.list(request);
    }

    private byte[] digest(InputStream is) {
        MessageDigest digest = OperationExecutor.getDigest();
        try (DigestInputStream dis = new DigestInputStream(is, digest);){
            ByteStreams.copy((InputStream)dis, (OutputStream)ByteStreams.nullOutputStream());
        }
        return digest.digest();
    }

    private UserSpec requireUser(Operation oper) {
        UserSpec user = this.users.get(oper.getUserId());
        if (null == user) {
            log.error("No such user for {}", (Object)oper);
            throw new UserNotFoundException(oper.getUserId());
        }
        return user;
    }

    private static MessageDigest getDigest() {
        return MessageDigest.getInstance("MD5");
    }

    @Generated
    public OperationExecutor(PrivateSpaceService privateSpace, InboxService inboxService, Map<String, UserSpec> users, StatisticService statisticService) {
        this.privateSpace = privateSpace;
        this.inboxService = inboxService;
        this.users = users;
        this.statisticService = statisticService;
    }
}

