/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.business.impl.e2e.performance.fixture.generator;

import com.google.gson.Gson;
import de.adorsys.datasafe.business.impl.e2e.performance.fixture.dto.Fixture;
import de.adorsys.datasafe.business.impl.e2e.performance.fixture.dto.Operation;
import de.adorsys.datasafe.business.impl.e2e.performance.fixture.dto.StorageType;
import de.adorsys.datasafe.business.impl.e2e.performance.fixture.dto.TestFileTree;
import de.adorsys.datasafe.business.impl.e2e.performance.fixture.dto.TestUser;
import de.adorsys.datasafe.business.impl.e2e.performance.fixture.dto.UserFileSystem;
import de.adorsys.datasafe.business.impl.e2e.performance.fixture.generator.HistoryList;
import de.adorsys.datasafe.business.impl.e2e.performance.fixture.generator.RandomContentIdGenerator;
import de.adorsys.datasafe.business.impl.e2e.performance.fixture.generator.RandomPassGate;
import de.adorsys.datasafe.business.impl.e2e.performance.fixture.generator.RandomPathGenerator;
import de.adorsys.datasafe.types.api.shared.BaseMockitoTest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.Generated;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariable;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieModule;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.StatelessKieSession;
import org.kie.internal.io.ResourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnabledIfEnvironmentVariable(named="GENERATE_FIXTURE_SIZE", matches=".+")
class FixtureGenerator
extends BaseMockitoTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FixtureGenerator.class);
    static final String GENERATE_FIXTURE_SIZE = "GENERATE_FIXTURE_SIZE";
    private static final int DESIRED_SOFT_OPERATION_COUNT = Integer.parseInt(System.getenv("GENERATE_FIXTURE_SIZE"));
    private static final int USER_COUNT = 10;
    private Map<TestUser, UserFileSystem> storageByUser;
    private HistoryList historyList;
    private StatelessKieSession session;

    FixtureGenerator() {
    }

    @BeforeEach
    void init() {
        this.storageByUser = new HashMap<TestUser, UserFileSystem>();
        this.historyList = new HistoryList(new ArrayList<Operation>(), DESIRED_SOFT_OPERATION_COUNT);
        IntStream.range(0, 10).forEach(it -> this.storageByUser.computeIfAbsent(new TestUser("user-" + it, UUID.randomUUID().toString()), id -> new UserFileSystem((TestUser)id, FixtureGenerator.privatespace(this.historyList.getOperations(), id), FixtureGenerator.inbox(this.historyList.getOperations(), id))));
        this.session = this.prepareSession(this.newKieSession());
    }

    @Test
    void generateRandomFixture() {
        do {
            this.session.execute(this.storageByUser.values());
        } while (this.historyList.canContinue());
        log.info("DONE");
        this.printResult();
    }

    private void printResult() {
        Fixture fixture = new Fixture(this.historyList.getOperations(), this.storageByUser.entrySet().stream().collect(Collectors.toMap(it -> ((TestUser)it.getKey()).getUsername(), it -> ((UserFileSystem)it.getValue()).getPrivateFiles().getFiles())), this.storageByUser.entrySet().stream().collect(Collectors.toMap(it -> ((TestUser)it.getKey()).getUsername(), it -> ((UserFileSystem)it.getValue()).getInboxFiles().getFiles())));
        log.info("Fixture:");
        log.info("{}", (Object)new Gson().toJson((Object)fixture));
    }

    private StatelessKieSession newKieSession() {
        KieServices services = KieServices.Factory.get();
        KieFileSystem fileSystem = services.newKieFileSystem();
        fileSystem.write(ResourceFactory.newClassPathResource((String)"performance/fixture/generator/drools/user.drl"));
        KieBuilder kb = services.newKieBuilder(fileSystem);
        kb.buildAll();
        KieModule kieModule = kb.getKieModule();
        KieContainer kContainer = services.newKieContainer(kieModule.getReleaseId());
        return kContainer.newStatelessKieSession();
    }

    private StatelessKieSession prepareSession(StatelessKieSession session) {
        session.setGlobal("randomPass", (Object)new RandomPassGate(FixtureGenerator.random()));
        session.setGlobal("randomPath", (Object)new RandomPathGenerator(FixtureGenerator.random(), 3, RandomPathGenerator.DEFAULT_COMPONENTS, RandomPathGenerator.DEFAULT_FILENAMES));
        session.setGlobal("randomContent", (Object)new RandomContentIdGenerator(FixtureGenerator.random(), 10));
        session.setGlobal("historyList", (Object)this.historyList);
        return session;
    }

    private static Random random() {
        return new Random(0L);
    }

    private static TestFileTree inbox(List<Operation> operations, TestUser user) {
        return new TestFileTree(operations::add, user, StorageType.INBOX, FixtureGenerator.random());
    }

    private static TestFileTree privatespace(List<Operation> operations, TestUser user) {
        return new TestFileTree(operations::add, user, StorageType.PRIVATE, FixtureGenerator.random());
    }
}

