/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.business.impl.e2e.performance;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.io.Resources;
import com.google.gson.Gson;
import de.adorsys.datasafe.business.impl.e2e.BaseE2ETest;
import de.adorsys.datasafe.business.impl.e2e.WithStorageProvider;
import de.adorsys.datasafe.business.impl.e2e.performance.dto.UserSpec;
import de.adorsys.datasafe.business.impl.e2e.performance.fixture.dto.Fixture;
import de.adorsys.datasafe.business.impl.e2e.performance.services.OperationExecutor;
import de.adorsys.datasafe.business.impl.e2e.performance.services.StatisticService;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import de.adorsys.datasafe.types.api.resource.Uri;
import de.adorsys.datasafe.types.api.shared.ContentGenerator;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.Generated;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.provider.Arguments;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class WithRandomActionPerformance
extends BaseE2ETest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WithRandomActionPerformance.class);
    private static Fixture fixture;
    protected static final Map<String, StatisticService> STATS;
    protected Map<String, UserSpec> users;
    private WithStorageProvider.StorageDescriptor descriptor;
    private String testId;

    WithRandomActionPerformance() {
    }

    @BeforeAll
    static void init() {
        try (Reader reader = Resources.asCharSource((URL)Resources.getResource((String)"performance/fixture/fixture.json"), (Charset)StandardCharsets.UTF_8).openStream();){
            fixture = (Fixture)new Gson().fromJson(reader, Fixture.class);
        }
    }

    @BeforeEach
    void generateDataAndRegisterUsers() {
        this.users = new HashMap<String, UserSpec>();
        this.descriptor = WithRandomActionPerformance.minio();
        this.testId = UUID.randomUUID().toString();
    }

    @AfterAll
    static void reportStats() {
        STATS.forEach((name, stat) -> log.info("Performance for <{}>: {}", name, (Object)stat.reportAsJson((String)name)));
    }

    protected static Stream<Arguments> sizesAndLatency() {
        return Sets.cartesianProduct((Set[])new Set[]{ImmutableSet.of((Object)1024, (Object)10240, (Object)102400, (Object)1024000), ImmutableSet.of((Object)0, (Object)10, (Object)100, (Object)250, (Object)500)}).stream().map(it -> Arguments.of((Object[])new Object[]{it.get(0), it.get(1)}));
    }

    protected void executeOperations(OperationExecutor executor) {
        fixture.getOperations().forEach(executor::execute);
    }

    protected void initUsers(int fileSize) {
        fixture.getUserPrivateSpace().forEach((userId, space) -> {
            UserIDAuth auth = this.registerUser(this.testId + "-" + userId);
            this.users.put((String)userId, new UserSpec(auth, new ContentGenerator(fileSize)));
        });
    }

    protected static String named(String baseName, int size, int latency) {
        return String.format("%s:size:%d latency:%d", baseName, size, latency);
    }

    protected DelegatingStorageWithDelay storageService(WithStorageProvider.StorageDescriptor descriptor, long latency) {
        return new DelegatingStorageWithDelay(descriptor.getLocation(), descriptor.getStorageService().get(), () -> 0L == latency ? 0L : ThreadLocalRandom.current().nextLong((long)((double)latency * 0.8), (long)((double)latency * 1.2)));
    }

    static {
        STATS = new HashMap<String, StatisticService>();
    }

    static class DelegatingStorageWithDelay
    implements StorageService {
        private final Uri rootLocation;
        private final StorageService delegate;
        private final Supplier<Long> delayProvider;

        public boolean objectExists(AbsoluteLocation location) {
            Thread.sleep(this.delayProvider.get());
            return this.delegate.objectExists(location);
        }

        public Stream<AbsoluteLocation<ResolvedResource>> list(AbsoluteLocation location) {
            Thread.sleep(this.delayProvider.get());
            return this.delegate.list(location);
        }

        public InputStream read(AbsoluteLocation location) {
            Thread.sleep(this.delayProvider.get());
            return this.delegate.read(location);
        }

        public void remove(AbsoluteLocation location) {
            Thread.sleep(this.delayProvider.get());
            this.delegate.remove(location);
        }

        public OutputStream write(AbsoluteLocation location) {
            Thread.sleep(this.delayProvider.get());
            return this.delegate.write(location);
        }

        @Generated
        public DelegatingStorageWithDelay(Uri rootLocation, StorageService delegate, Supplier<Long> delayProvider) {
            this.rootLocation = rootLocation;
            this.delegate = delegate;
            this.delayProvider = delayProvider;
        }

        @Generated
        public Uri getRootLocation() {
            return this.rootLocation;
        }
    }
}

