/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.business.impl.e2e;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.google.common.base.Suppliers;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.storage.impl.fs.FileSystemStorageService;
import de.adorsys.datasafe.storage.impl.s3.S3StorageService;
import de.adorsys.datasafe.types.api.resource.Uri;
import de.adorsys.datasafe.types.api.shared.BaseMockitoTest;
import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import java.util.stream.Stream;
import lombok.Generated;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.provider.ValueSource;
import org.junit.platform.commons.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.shaded.org.apache.commons.io.FileUtils;

public abstract class WithStorageProvider
extends BaseMockitoTest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WithStorageProvider.class);
    private static String deeperBucketPath = "deeper/and/deeper";
    private static final ExecutorService EXECUTOR_SERVICE = Executors.newFixedThreadPool(5);
    private static String minioAccessKeyID = "admin";
    private static String minioSecretAccessKey = "password";
    private static String minioRegion = "eu-central-1";
    private static String minioBucketName = "home";
    private static String minioUrl = "http://localhost";
    private static String minioMappedUrl;
    private static String cephAccessKeyID;
    private static String cephSecretAccessKey;
    private static String cephRegion;
    private static String cephBucketName;
    private static String cephUrl;
    private static String cephMappedUrl;
    private static String amazonAccessKeyID;
    private static String amazonSecretAccessKey;
    private static String amazonRegion;
    private static String amazonBucket;
    private static String amazonMappedUrl;
    private static GenericContainer minioContainer;
    private static GenericContainer cephContainer;
    private static Path tempDir;
    private static AmazonS3 minio;
    private static AmazonS3 ceph;
    private static AmazonS3 amazonS3;
    private static Supplier<Void> cephStorage;
    private static Supplier<Void> minioStorage;
    private static Supplier<Void> amazonSotrage;

    @BeforeAll
    static void init(@TempDir Path tempDir) {
        log.info("Executing init");
        log.info("");
        WithStorageProvider.tempDir = tempDir;
        minioStorage = Suppliers.memoize(() -> {
            WithStorageProvider.startMinio();
            return null;
        });
        cephStorage = Suppliers.memoize(() -> {
            WithStorageProvider.startCeph();
            return null;
        });
        amazonSotrage = Suppliers.memoize(() -> {
            WithStorageProvider.initS3();
            return null;
        });
    }

    @AfterEach
    void cleanup() {
        log.info("Executing cleanup");
        if (null != tempDir && tempDir.toFile().exists()) {
            FileUtils.cleanDirectory((File)tempDir.toFile());
        }
        if (null != minio) {
            this.removeObjectFromS3(minio, minioBucketName, deeperBucketPath);
        }
        if (null != amazonS3) {
            this.removeObjectFromS3(amazonS3, amazonBucket, deeperBucketPath);
        }
    }

    @AfterAll
    static void shutdown() {
        log.info("Stopping containers");
        if (null != minioContainer) {
            minioContainer.stop();
            minioContainer = null;
            minio = null;
        }
        if (null != cephContainer) {
            cephContainer.stop();
            cephContainer = null;
            ceph = null;
        }
        amazonS3 = null;
    }

    @ValueSource
    protected static Stream<StorageDescriptor> allStorages() {
        return Stream.of(WithStorageProvider.fs(), WithStorageProvider.minio(), WithStorageProvider.s3()).filter(Objects::nonNull);
    }

    @ValueSource
    protected static Stream<StorageDescriptor> minioStorage() {
        return Stream.of(WithStorageProvider.minio()).filter(Objects::nonNull);
    }

    @ValueSource
    protected static Stream<StorageDescriptor> fsStorage() {
        return Stream.of(WithStorageProvider.fs()).filter(Objects::nonNull);
    }

    private static StorageDescriptor fs() {
        return new StorageDescriptor(StorageDescriptorName.FILESYSTEM, () -> new FileSystemStorageService(new Uri(tempDir.toUri())), new Uri(tempDir.toUri()), null, null, null, tempDir.toString());
    }

    protected static StorageDescriptor minio() {
        return new StorageDescriptor(StorageDescriptorName.MINIO, () -> {
            minioStorage.get();
            return new S3StorageService(minio, minioBucketName, EXECUTOR_SERVICE);
        }, new Uri("s3://" + minioBucketName + "/" + deeperBucketPath + "/"), minioAccessKeyID, minioSecretAccessKey, minioRegion, minioBucketName + "/" + deeperBucketPath);
    }

    protected static StorageDescriptor ceph() {
        return new StorageDescriptor(StorageDescriptorName.CEPH, () -> {
            cephStorage.get();
            return new S3StorageService(ceph, cephBucketName, EXECUTOR_SERVICE);
        }, new Uri("s3://" + cephBucketName + "/" + deeperBucketPath + "/"), cephAccessKeyID, cephSecretAccessKey, cephRegion, cephBucketName + "/" + deeperBucketPath);
    }

    protected static StorageDescriptor s3() {
        if (null == amazonAccessKeyID) {
            return null;
        }
        return new StorageDescriptor(StorageDescriptorName.AMAZON, () -> {
            amazonSotrage.get();
            return new S3StorageService(amazonS3, amazonBucket, EXECUTOR_SERVICE);
        }, new Uri("s3://" + amazonBucket + "/" + deeperBucketPath + "/"), amazonAccessKeyID, amazonSecretAccessKey, amazonRegion, amazonBucket + "/" + deeperBucketPath);
    }

    private void removeObjectFromS3(AmazonS3 amazonS3, String bucket, String prefix) {
        amazonS3.listObjects(bucket, prefix).getObjectSummaries().forEach(it -> {
            log.debug("Remove {}", (Object)it.getKey());
            amazonS3.deleteObject(bucket, it.getKey());
        });
    }

    private static void initS3() {
        log.info("Initializing S3");
        if (StringUtils.isBlank((String)amazonAccessKeyID)) {
            return;
        }
        amazonS3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(amazonAccessKeyID, amazonSecretAccessKey)))).withRegion(amazonRegion)).build();
        amazonMappedUrl = "s3://" + amazonBucket + "/" + deeperBucketPath + "/";
        log.info("Amazon napped URL:" + amazonMappedUrl);
    }

    private static void startMinio() {
        log.info("Starting MINIO");
        minioContainer = new GenericContainer("minio/minio").withExposedPorts(new Integer[]{9000}).withEnv("MINIO_ACCESS_KEY", minioAccessKeyID).withEnv("MINIO_SECRET_KEY", minioSecretAccessKey).withCommand("server /data").waitingFor(Wait.defaultWaitStrategy());
        minioContainer.start();
        Integer mappedPort = minioContainer.getMappedPort(9000);
        minioMappedUrl = minioUrl + ":" + mappedPort;
        log.info("Minio mapped URL:" + minioMappedUrl);
        minio = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(minioMappedUrl, minioRegion))).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(minioAccessKeyID, minioSecretAccessKey)))).enablePathStyleAccess()).build();
        minio.createBucket(minioBucketName);
    }

    private static void startCeph() {
        log.info("Starting CEPH");
        cephContainer = new GenericContainer("localrepo/ceph-nano").withExposedPorts(new Integer[]{5000}).withEnv("MON_IP", "0.0.0.0").withEnv("CEPH_PUBLIC_NETWORK", "0.0.0.0/0").withEnv("CEPH_DEMO_UID", "ceph").withEnv("CEPH_DEMO_ACCESS_KEY", cephAccessKeyID).withEnv("CEPH_DEMO_SECRET_KEY", cephSecretAccessKey).withEnv("CEPH_DEMO_BUCKET", cephBucketName).waitingFor(Wait.defaultWaitStrategy());
        cephContainer.start();
        Integer mappedPort = cephContainer.getMappedPort(9000);
        log.info("Ceph mapped URL:" + cephMappedUrl);
        cephMappedUrl = cephUrl + ":" + mappedPort;
        ceph = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(cephMappedUrl, cephRegion))).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(cephAccessKeyID, cephSecretAccessKey)))).enablePathStyleAccess()).build();
        ceph.createBucket(cephBucketName);
    }

    static {
        cephAccessKeyID = "admin";
        cephSecretAccessKey = "password";
        cephRegion = "eu-central-1";
        cephBucketName = "home";
        cephUrl = "http://localhost";
        amazonAccessKeyID = System.getProperty("AWS_ACCESS_KEY");
        amazonSecretAccessKey = System.getProperty("AWS_SECRET_KEY");
        amazonRegion = System.getProperty("AWS_REGION", "eu-central-1");
        amazonBucket = System.getProperty("AWS_BUCKET", "adorsys-docusafe");
    }

    public static enum StorageDescriptorName {
        FILESYSTEM,
        MINIO,
        CEPH,
        AMAZON;

    }

    public static class StorageDescriptor {
        private final StorageDescriptorName name;
        private final Supplier<StorageService> storageService;
        private final Uri location;
        private final String accessKey;
        private final String secretKey;
        private final String region;
        private final String rootBucket;

        public String getMappedUrl() {
            switch (this.name) {
                case MINIO: {
                    return minioMappedUrl;
                }
                case CEPH: {
                    return cephMappedUrl;
                }
                case AMAZON: {
                    return amazonMappedUrl;
                }
                case FILESYSTEM: {
                    return null;
                }
            }
            throw new RuntimeException("missing switch for " + (Object)((Object)this.name));
        }

        @Generated
        public StorageDescriptorName getName() {
            return this.name;
        }

        @Generated
        public Supplier<StorageService> getStorageService() {
            return this.storageService;
        }

        @Generated
        public Uri getLocation() {
            return this.location;
        }

        @Generated
        public String getAccessKey() {
            return this.accessKey;
        }

        @Generated
        public String getSecretKey() {
            return this.secretKey;
        }

        @Generated
        public String getRegion() {
            return this.region;
        }

        @Generated
        public String getRootBucket() {
            return this.rootBucket;
        }

        @Generated
        public String toString() {
            return "WithStorageProvider.StorageDescriptor(name=" + (Object)((Object)this.getName()) + ")";
        }

        @Generated
        public StorageDescriptor(StorageDescriptorName name, Supplier<StorageService> storageService, Uri location, String accessKey, String secretKey, String region, String rootBucket) {
            this.name = name;
            this.storageService = storageService;
            this.location = location;
            this.accessKey = accessKey;
            this.secretKey = secretKey;
            this.region = region;
            this.rootBucket = rootBucket;
        }
    }
}

