/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.business.impl.e2e;

import com.google.common.io.ByteStreams;
import de.adorsys.datasafe.business.impl.e2e.BaseE2ETest;
import de.adorsys.datasafe.business.impl.e2e.DatasafeServicesProvider;
import de.adorsys.datasafe.business.impl.e2e.WithStorageProvider;
import de.adorsys.datasafe.business.impl.e2e.metrtics.TestMetricCollector;
import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.storage.api.StorageService;
import de.adorsys.datasafe.types.api.actions.ListRequest;
import de.adorsys.datasafe.types.api.actions.ReadRequest;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import de.adorsys.datasafe.types.api.resource.Uri;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.compress.utils.IOUtils;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.bouncycastle.util.encoders.Hex;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.junit.jupiter.params.provider.ValueSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BasicFunctionalityWithConcurrencyTest
extends BaseE2ETest {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BasicFunctionalityWithConcurrencyTest.class);
    private static final int TIMEOUT_S = 10;
    private static int NUMBER_OF_TEST_USERS = 3;
    private static int NUMBER_OF_TEST_FILES;
    private static int EXPECTED_NUMBER_OF_FILES_PER_USER;
    private static final String TEST_FILENAME = "/test.txt";
    @TempDir
    protected Path tempTestFileFolder;
    protected StorageService storage;
    protected Uri location;
    private TestMetricCollector metricCollector = new TestMetricCollector();
    private Function<Runnable, Long> measurePerformanceAndReturnValue = measuredMethod -> {
        Instant start = Instant.now();
        measuredMethod.run();
        long durationOfSavingFile = Duration.between(start, Instant.now()).toMillis();
        return durationOfSavingFile;
    };
    private BiFunction<Supplier<UserIDAuth>, BiConsumer<String, Long>, UserIDAuth> measurePerformance = (measuredMethod, collector) -> {
        Instant start = Instant.now();
        UserIDAuth user = (UserIDAuth)measuredMethod.get();
        long durationOfUserRegistration = Duration.between(start, Instant.now()).toMillis();
        collector.accept(user.getUserID().getValue(), durationOfUserRegistration);
        log.debug("Registered user: {} in {}ms", (Object)user.getUserID().getValue(), (Object)durationOfUserRegistration);
        return user;
    };

    BasicFunctionalityWithConcurrencyTest() {
    }

    @ParameterizedTest(name="Run #{index} service storage: {0} with data size: {1} bytes and {2} threads.")
    @MethodSource(value={"differentThreadsTestOptions"})
    void writeToPrivateListPrivateInDifferentThreads(WithStorageProvider.StorageDescriptor descriptor, int size, int poolSize) {
        int i;
        String checksumOfOriginTestFile;
        this.init(descriptor);
        String testFile = this.tempTestFileFolder.toString() + TEST_FILENAME;
        BasicFunctionalityWithConcurrencyTest.generateTestFile(testFile, size);
        ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(poolSize);
        CountDownLatch holdingLatch = new CountDownLatch(1);
        CountDownLatch finishHoldingLatch = new CountDownLatch(NUMBER_OF_TEST_USERS * NUMBER_OF_TEST_FILES);
        try (FileInputStream input = new FileInputStream(new File(testFile));){
            checksumOfOriginTestFile = this.checksum(input);
        }
        log.trace("*** Starting write threads ***");
        for (i = 0; i < NUMBER_OF_TEST_USERS; ++i) {
            String userName = "john_" + i;
            executor.execute(() -> {
                UserIDAuth user = this.measurePerformance.apply(() -> this.registerUser(userName), this.metricCollector::addRegisterRecords);
                this.createFileForUserParallelly(executor, holdingLatch, finishHoldingLatch, testFile, user);
            });
        }
        holdingLatch.countDown();
        log.trace("*** Main thread waiting for all threads ***");
        finishHoldingLatch.await(10L, TimeUnit.SECONDS);
        executor.shutdown();
        log.trace("*** All threads are finished work ***");
        log.trace("*** Starting read info saved earlier *** ");
        for (i = 0; i < NUMBER_OF_TEST_USERS; ++i) {
            UserIDAuth user = this.createJohnTestUser(i);
            Awaitility.await().atMost(5L, TimeUnit.SECONDS).until(() -> this.listAllPrivateFiles(user).size() == EXPECTED_NUMBER_OF_FILES_PER_USER);
            List<AbsoluteLocation<ResolvedResource>> resourceList = this.listAllPrivateFiles(user);
            Assertions.assertThat((int)resourceList.size()).isEqualTo(EXPECTED_NUMBER_OF_FILES_PER_USER);
            resourceList.forEach(item -> org.junit.jupiter.api.Assertions.assertEquals((Object)checksumOfOriginTestFile, (Object)this.calculateDecryptedContentChecksum(user, (AbsoluteLocation<ResolvedResource>)item)));
        }
        this.metricCollector.setDataSize(size);
        this.metricCollector.setStorageType(this.storage.getClass().getSimpleName());
        this.metricCollector.setNumberOfThreads(poolSize);
        this.metricCollector.writeToJSON();
    }

    private List<AbsoluteLocation<ResolvedResource>> listAllPrivateFiles(UserIDAuth user) {
        return this.listPrivate.list(ListRequest.forDefaultPrivate((Object)user, (String)"./")).collect(Collectors.toList());
    }

    private void createFileForUserParallelly(ThreadPoolExecutor executor, CountDownLatch holdingLatch, CountDownLatch finishHoldingLatch, String testFilePath, UserIDAuth user) {
        AtomicInteger counter = new AtomicInteger();
        String remotePath = "folder2";
        for (int j = 0; j < NUMBER_OF_TEST_FILES; ++j) {
            executor.execute(() -> {
                try {
                    holdingLatch.await();
                    Thread.currentThread().setName(user.getUserID().getValue());
                    String filePath = remotePath + "/" + counter.incrementAndGet() + ".txt";
                    log.debug("Saving file: {}", (Object)filePath);
                    long durationOfSavingFile = this.measurePerformanceAndReturnValue.apply(() -> this.writeDataToFileForUser(user, filePath, testFilePath, finishHoldingLatch));
                    this.metricCollector.addSaveRecord(user.getUserID().getValue(), durationOfSavingFile);
                    log.debug("Save file in {} ms", (Object)durationOfSavingFile);
                }
                catch (InterruptedException e) {
                    org.junit.jupiter.api.Assertions.fail((Throwable)e);
                }
            });
        }
    }

    private String calculateDecryptedContentChecksum(UserIDAuth user, AbsoluteLocation<ResolvedResource> item) {
        try {
            InputStream decryptedFileStream = this.readFromPrivate.read(ReadRequest.forPrivate((Object)user, (PrivateResource)((ResolvedResource)item.getResource()).asPrivate()));
            String checksumOfDecryptedTestFile = this.checksum(decryptedFileStream);
            decryptedFileStream.close();
            return checksumOfDecryptedTestFile;
        }
        catch (IOException e) {
            org.junit.jupiter.api.Assertions.fail((Throwable)e);
            return "";
        }
    }

    private String checksum(InputStream input) {
        int length;
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] block = new byte[4096];
        while ((length = input.read(block)) > 0) {
            digest.update(block, 0, length);
        }
        return Hex.toHexString((byte[])digest.digest());
    }

    private static void generateTestFile(String testFile, int testFileSizeInBytes) {
        try (RandomAccessFile originTestFile = new RandomAccessFile(testFile, "rw");){
            MappedByteBuffer out = originTestFile.getChannel().map(FileChannel.MapMode.READ_WRITE, 0L, testFileSizeInBytes);
            for (int i = 0; i < testFileSizeInBytes; ++i) {
                out.put((byte)120);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage());
        }
    }

    @ValueSource
    protected static Stream<Arguments> differentThreadsTestOptions() {
        Stream<WithStorageProvider.StorageDescriptor> storageDescriptorMap = BasicFunctionalityWithConcurrencyTest.allStorages();
        ArrayList arguments = new ArrayList();
        storageDescriptorMap.forEach(storageDescriptor -> {
            arguments.add(Arguments.of((Object[])new Object[]{storageDescriptor, 30720, 4}));
            arguments.add(Arguments.of((Object[])new Object[]{storageDescriptor, 30720, 8}));
            arguments.add(Arguments.of((Object[])new Object[]{storageDescriptor, 61440, 4}));
            arguments.add(Arguments.of((Object[])new Object[]{storageDescriptor, 61440, 8}));
            arguments.add(Arguments.of((Object[])new Object[]{storageDescriptor, 0x500000, 4}));
            arguments.add(Arguments.of((Object[])new Object[]{storageDescriptor, 0x500000, 8}));
            arguments.add(Arguments.of((Object[])new Object[]{storageDescriptor, 0xA00000, 4}));
            arguments.add(Arguments.of((Object[])new Object[]{storageDescriptor, 0xA00000, 8}));
        });
        return arguments.stream();
    }

    private void init(WithStorageProvider.StorageDescriptor descriptor) {
        DefaultDatasafeServices datasafeServices = DatasafeServicesProvider.defaultDatasafeServices(descriptor.getStorageService().get(), descriptor.getLocation());
        this.initialize(DatasafeServicesProvider.dfsConfig(descriptor.getLocation()), datasafeServices);
        this.location = descriptor.getLocation();
        this.storage = descriptor.getStorageService().get();
    }

    protected void writeDataToFileForUser(UserIDAuth john, String filePathForWriting, String filePathForReading, CountDownLatch latch) {
        try {
            OutputStream write = this.writeToPrivate.write(WriteRequest.forDefaultPrivate((Object)john, (String)filePathForWriting));
            FileInputStream fis = new FileInputStream(filePathForReading);
            ByteStreams.copy((InputStream)fis, (OutputStream)write);
            IOUtils.closeQuietly((Closeable)fis);
            IOUtils.closeQuietly((Closeable)write);
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        latch.countDown();
    }

    @BeforeAll
    public static void setUp() {
        if (System.getenv("NUMBER_OF_TEST_USERS") != null) {
            NUMBER_OF_TEST_USERS = Integer.parseInt(System.getenv("NUMBER_OF_TEST_USERS"));
        }
        if (System.getenv("NUMBER_OF_TEST_FILES") != null) {
            EXPECTED_NUMBER_OF_FILES_PER_USER = NUMBER_OF_TEST_FILES = Integer.parseInt(System.getenv("NUMBER_OF_TEST_FILES"));
        }
    }

    static {
        EXPECTED_NUMBER_OF_FILES_PER_USER = NUMBER_OF_TEST_FILES = 5;
    }
}

