/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.datasafe.business.impl.e2e;

import com.google.common.io.ByteStreams;
import de.adorsys.datasafe.business.impl.e2e.WithStorageProvider;
import de.adorsys.datasafe.business.impl.service.DefaultDatasafeServices;
import de.adorsys.datasafe.business.impl.service.VersionedDatasafeServices;
import de.adorsys.datasafe.directory.api.config.DFSConfig;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRegistrationService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRemovalService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRetrievalService;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.encrypiton.api.types.keystore.ReadKeyPassword;
import de.adorsys.datasafe.inbox.api.actions.ListInbox;
import de.adorsys.datasafe.inbox.api.actions.ReadFromInbox;
import de.adorsys.datasafe.inbox.api.actions.RemoveFromInbox;
import de.adorsys.datasafe.inbox.api.actions.WriteToInbox;
import de.adorsys.datasafe.privatestore.api.actions.ListPrivate;
import de.adorsys.datasafe.privatestore.api.actions.ReadFromPrivate;
import de.adorsys.datasafe.privatestore.api.actions.RemoveFromPrivate;
import de.adorsys.datasafe.privatestore.api.actions.WriteToPrivate;
import de.adorsys.datasafe.storage.impl.fs.FileSystemStorageService;
import de.adorsys.datasafe.types.api.actions.ListRequest;
import de.adorsys.datasafe.types.api.actions.ReadRequest;
import de.adorsys.datasafe.types.api.actions.RemoveRequest;
import de.adorsys.datasafe.types.api.actions.WriteRequest;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.BasePrivateResource;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.ResolvedResource;
import de.adorsys.datasafe.types.api.resource.ResourceLocation;
import de.adorsys.datasafe.types.api.resource.Uri;
import de.adorsys.datasafe.types.api.utils.Obfuscate;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseE2ETest
extends WithStorageProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseE2ETest.class);
    protected static final String PRIVATE_COMPONENT = "private";
    protected static final String PRIVATE_FILES_COMPONENT = "private/files";
    protected static final String PUBLIC_COMPONENT = "public";
    protected static final String INBOX_COMPONENT = "public/inbox";
    protected static final String VERSION_COMPONENT = "versions";
    protected DFSConfig dfsConfig;
    protected ListPrivate listPrivate;
    protected ReadFromPrivate readFromPrivate;
    protected WriteToPrivate writeToPrivate;
    protected RemoveFromPrivate removeFromPrivate;
    protected ReadFromInbox readFromInbox;
    protected ListInbox listInbox;
    protected WriteToInbox writeToInbox;
    protected RemoveFromInbox removeFromInbox;
    protected ProfileRegistrationService profileRegistrationService;
    protected ProfileRemovalService profileRemovalService;
    protected ProfileRetrievalService profileRetrievalService;
    protected UserIDAuth john;
    protected UserIDAuth jane;

    protected void initialize(DFSConfig dfsConfig, DefaultDatasafeServices datasafeServices) {
        this.dfsConfig = dfsConfig;
        this.listPrivate = datasafeServices.privateService();
        this.readFromPrivate = datasafeServices.privateService();
        this.writeToPrivate = datasafeServices.privateService();
        this.removeFromPrivate = datasafeServices.privateService();
        this.readFromInbox = datasafeServices.inboxService();
        this.listInbox = datasafeServices.inboxService();
        this.writeToInbox = datasafeServices.inboxService();
        this.removeFromInbox = datasafeServices.inboxService();
        this.profileRegistrationService = datasafeServices.userProfile();
        this.profileRemovalService = datasafeServices.userProfile();
        this.profileRetrievalService = datasafeServices.userProfile();
    }

    protected void initialize(DFSConfig dfsConfig, VersionedDatasafeServices datasafeServices) {
        this.dfsConfig = dfsConfig;
        this.listPrivate = datasafeServices.latestPrivate();
        this.readFromPrivate = datasafeServices.latestPrivate();
        this.writeToPrivate = datasafeServices.latestPrivate();
        this.removeFromPrivate = datasafeServices.latestPrivate();
        this.readFromInbox = datasafeServices.inboxService();
        this.listInbox = datasafeServices.inboxService();
        this.writeToInbox = datasafeServices.inboxService();
        this.removeFromInbox = datasafeServices.inboxService();
        this.profileRegistrationService = datasafeServices.userProfile();
        this.profileRemovalService = datasafeServices.userProfile();
        this.profileRetrievalService = datasafeServices.userProfile();
    }

    protected void writeDataToPrivate(UserIDAuth auth, String path, String data) {
        OutputStream stream = this.writeToPrivate.write(WriteRequest.forDefaultPrivate((Object)auth, (String)path));
        stream.write(data.getBytes());
        stream.close();
        log.info("File {} of user {} saved to {}", new Object[]{Obfuscate.secure((Object)data), Obfuscate.secure((Object)auth), Obfuscate.secure((Object[])path.split("/"), (String)"/")});
    }

    protected void writeDataToInbox(UserIDAuth auth, String path, String data) {
        OutputStream stream = this.writeToInbox.write(WriteRequest.forDefaultPublic(Collections.singleton(auth.getUserID()), (String)path));
        stream.write(data.getBytes());
        stream.close();
        log.info("File {} of user {} saved to {}", new Object[]{Obfuscate.secure((Object)data), Obfuscate.secure((Object)auth), Obfuscate.secure((Object[])path.split("/"), (String)"/")});
    }

    protected AbsoluteLocation<ResolvedResource> getFirstFileInPrivate(UserIDAuth owner) {
        return this.getAllFilesInPrivate(owner).get(0);
    }

    protected List<AbsoluteLocation<ResolvedResource>> getAllFilesInPrivate(UserIDAuth owner) {
        List<AbsoluteLocation<ResolvedResource>> files = this.listPrivate.list(ListRequest.forDefaultPrivate((Object)owner, (String)"./")).collect(Collectors.toList());
        log.info("{} has {} in PRIVATE", (Object)owner.getUserID(), (Object)Obfuscate.secure(files));
        return files;
    }

    protected String readPrivateUsingPrivateKey(UserIDAuth user, PrivateResource location) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        InputStream dataStream = this.readFromPrivate.read(ReadRequest.forPrivate((Object)user, (PrivateResource)location));
        ByteStreams.copy((InputStream)dataStream, (OutputStream)outputStream);
        String data = new String(outputStream.toByteArray());
        log.info("{} has {} in PRIVATE", (Object)user, (Object)Obfuscate.secure((Object)data));
        return data;
    }

    protected void removeFromPrivate(UserIDAuth user, PrivateResource location) {
        this.removeFromPrivate.remove(RemoveRequest.forPrivate((Object)user, (PrivateResource)location));
    }

    protected String readInboxUsingPrivateKey(UserIDAuth user, PrivateResource location) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        InputStream dataStream = this.readFromInbox.read(ReadRequest.forPrivate((Object)user, (PrivateResource)location));
        ByteStreams.copy((InputStream)dataStream, (OutputStream)outputStream);
        String data = new String(outputStream.toByteArray());
        log.info("{} has {} in INBOX", (Object)user, (Object)Obfuscate.secure((Object)data));
        return data;
    }

    protected AbsoluteLocation<ResolvedResource> getFirstFileInInbox(UserIDAuth inboxOwner) {
        return this.getAllFilesInInbox(inboxOwner).get(0);
    }

    protected List<AbsoluteLocation<ResolvedResource>> getAllFilesInInbox(UserIDAuth inboxOwner) {
        List<AbsoluteLocation<ResolvedResource>> files = this.listInbox.list(ListRequest.forDefaultPrivate((Object)inboxOwner, (String)"./")).collect(Collectors.toList());
        log.info("{} has {} in INBOX", (Object)inboxOwner, (Object)Obfuscate.secure(files));
        return files;
    }

    protected void registerJohnAndJane() {
        this.john = this.registerUser("john");
        this.jane = this.registerUser("jane");
    }

    protected void sendToInbox(UserID to, String filename, String data) {
        OutputStream stream = this.writeToInbox.write(WriteRequest.forDefaultPublic(Collections.singleton(to), (String)("./" + filename)));
        stream.write(data.getBytes());
        stream.close();
        log.info("File {} sent to INBOX of user {}", (Object)Obfuscate.secure((Object)filename), (Object)to);
    }

    protected void removeFromInbox(UserIDAuth inboxOwner, PrivateResource location) {
        this.removeFromInbox.remove(RemoveRequest.forPrivate((Object)inboxOwner, (PrivateResource)location));
    }

    protected UserIDAuth registerUser(String userName) {
        UserIDAuth auth = new UserIDAuth(new UserID(userName), new ReadKeyPassword("secure-password " + userName));
        this.profileRegistrationService.registerPublic(this.dfsConfig.defaultPublicTemplate(auth));
        this.profileRegistrationService.registerPrivate(this.dfsConfig.defaultPrivateTemplate(auth));
        log.info("Created user: {}", (Object)Obfuscate.secure((Object)userName));
        return auth;
    }

    protected UserIDAuth createJohnTestUser(int i) {
        UserID userName = new UserID("john_" + i);
        return new UserIDAuth(userName, new ReadKeyPassword("secure-password " + userName.getValue()));
    }

    protected void assertPrivateSpaceList(UserIDAuth user, String root, String ... expected) {
        List paths = this.listPrivate.list(ListRequest.forDefaultPrivate((Object)user, (String)root)).map(it -> ((ResolvedResource)it.getResource()).asPrivate().decryptedPath().toASCIIString()).collect(Collectors.toList());
        for (String toFind : expected) {
            Assertions.assertThat((boolean)paths.stream().anyMatch(it -> it.equals(toFind))).isTrue();
        }
    }

    protected void assertInboxSpaceList(UserIDAuth user, String root, String ... expected) {
        List paths = this.listInbox.list(ListRequest.forDefaultPrivate((Object)user, (String)root)).map(it -> ((ResolvedResource)it.getResource()).asPrivate().decryptedPath().toASCIIString()).collect(Collectors.toList());
        for (String toFind : expected) {
            Assertions.assertThat((boolean)paths.stream().anyMatch(it -> it.equals(toFind))).isTrue();
        }
    }

    protected void assertRootDirIsEmpty(WithStorageProvider.StorageDescriptor descriptor) {
        Assertions.assertThat((Stream)descriptor.getStorageService().get().list(new AbsoluteLocation((ResourceLocation)BasePrivateResource.forPrivate((Uri)descriptor.getLocation())))).isEmpty();
        if (descriptor.getStorageService().get() instanceof FileSystemStorageService) {
            ((ListAssert)Assertions.assertThat(Files.walk(Paths.get(descriptor.getLocation().asURI()), new FileVisitOption[0])).allMatch(it -> it.toFile().isDirectory())).extracting(Path::toUri).extracting(it -> descriptor.getLocation().asURI().relativize((URI)it)).extracting(URI::toString).containsExactlyInAnyOrder((Object[])new String[]{"", "profiles/", "profiles/public/", "profiles/private/"});
        }
    }

    @Generated
    public BaseE2ETest() {
    }
}

