/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.cryptoutils.storeconnectionfactory;

import org.adorsys.cryptoutils.exceptions.BaseException;
import org.adorsys.cryptoutils.extendendstoreconnection.impl.amazons3.AmazonS3ExtendedStoreConnection;
import org.adorsys.cryptoutils.mongodbstoreconnection.MongoDBExtendedStoreConnection;
import org.adorsys.cryptoutils.storeconnectionfactory.ReadArguments;
import org.adorsys.encobject.filesystem.FileSystemExtendedStorageConnection;
import org.adorsys.encobject.service.api.ExtendedStoreConnection;
import org.adorsys.encobject.types.properties.AmazonS3ConnectionProperties;
import org.adorsys.encobject.types.properties.ConnectionProperties;
import org.adorsys.encobject.types.properties.FilesystemConnectionProperties;
import org.adorsys.encobject.types.properties.MongoConnectionProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedStoreConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendedStoreConnectionFactory.class);
    private static ConnectionProperties properties = null;

    public static ExtendedStoreConnection get(ConnectionProperties properties) {
        if (properties instanceof MongoConnectionProperties) {
            return new MongoDBExtendedStoreConnection((MongoConnectionProperties)properties);
        }
        if (properties instanceof AmazonS3ConnectionProperties) {
            return new AmazonS3ExtendedStoreConnection((AmazonS3ConnectionProperties)properties);
        }
        if (properties instanceof FilesystemConnectionProperties) {
            return new FileSystemExtendedStorageConnection((FilesystemConnectionProperties)properties);
        }
        throw new BaseException("Properties of unknown type: " + properties.getClass().getName());
    }

    public static ExtendedStoreConnection get() {
        if (properties == null) {
            properties = new ReadArguments().readEnvironment();
        }
        return ExtendedStoreConnectionFactory.get(properties);
    }

    public static void reset() {
        properties = null;
    }

    public static String[] readArguments(String[] args) {
        ReadArguments.ArgsAndProperties argsAndProperties = new ReadArguments().readArguments(args);
        properties = argsAndProperties.properties;
        return argsAndProperties.remainingArgs;
    }
}

