/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.cryptoutils.storeconnectionfactory;

import java.util.ArrayList;
import java.util.Arrays;
import org.adorsys.cryptoutils.exceptions.BaseExceptionHandler;
import org.adorsys.cryptoutils.extendendstoreconnection.impl.amazons3.AmazonS3ParamParser;
import org.adorsys.cryptoutils.miniostoreconnection.MinioParamParser;
import org.adorsys.cryptoutils.mongodbstoreconnection.MongoParamParser;
import org.adorsys.encobject.filesystem.FileSystemParamParser;
import org.adorsys.encobject.types.BucketPathEncryptionPassword;
import org.adorsys.encobject.types.properties.BucketPathEncryptionFilenameOnly;
import org.adorsys.encobject.types.properties.ConnectionProperties;
import org.adorsys.encobject.types.properties.ConnectionPropertiesImpl;
import org.adorsys.encobject.types.properties.FilesystemConnectionProperties;
import org.adorsys.encobject.types.properties.MongoConnectionProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReadArguments {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReadArguments.class);
    private static final String SYSTEM_PROPERTY_PREFIX = "-D";
    public static final String MONGO = "SC-MONGO";
    public static final String MINIO = "SC-MINIO";
    public static final String AMAZONS3 = "SC-AMAZONS3";
    public static final String FILESYSTEM = "SC-FILESYSTEM";
    public static final String ENCRYPTION_PASSWORD = "SC-ENCRYPTION-PASSWORD";
    public static final String NO_ENCRYPTION_PASSWORD = "SC-NO-ENCRYPTION-PASSWORD";
    public static final String ENCRYPTION_FILENAME_ONLY = "SC-ENCRYPTION-FILENAME-ONLY";
    public static final String MONGO_ARG = "-DSC-MONGO=";
    public static final String MINIO_ARG = "-DSC-MINIO=";
    public static final String AMAZONS3_ARG = "-DSC-AMAZONS3=";
    public static final String FILESYSTEM_ARG = "-DSC-FILESYSTEM=";
    public static final String ENCRYPTION_PASSWORD_ARG = "-DSC-ENCRYPTION-PASSWORD=";
    public static final String NO_ENCRYPTION_PASSWORD_ARG = "-DSC-NO-ENCRYPTION-PASSWORD";
    public static final String ENCRYPTION_FILENAME_ONLY_ARG = "-DSC-ENCRYPTION-FILENAME-ONLY";

    public ArgsAndProperties readArguments(String[] args) {
        Arrays.stream(args).forEach(arg -> LOGGER.debug("readArguments arg:" + arg));
        ArrayList<String> remainingArgs = new ArrayList<String>();
        FilesystemConnectionProperties properties = null;
        BucketPathEncryptionPassword bucketPathEncryptionPassword = ConnectionProperties.defaultEncryptionPassword;
        BucketPathEncryptionFilenameOnly bucketPathEncryptionFilenameOnly = ConnectionProperties.defaultBucketPathEncryptionFilenameOnly;
        for (String arg2 : args) {
            if (arg2.startsWith(MONGO_ARG)) {
                properties = MongoParamParser.getProperties((String)arg2.substring(MONGO_ARG.length()));
                continue;
            }
            if (arg2.startsWith(MINIO_ARG)) {
                properties = MinioParamParser.getProperties((String)arg2.substring(MINIO_ARG.length()));
                continue;
            }
            if (arg2.startsWith(AMAZONS3_ARG)) {
                properties = AmazonS3ParamParser.getProperties((String)arg2.substring(AMAZONS3_ARG.length()));
                continue;
            }
            if (arg2.startsWith(FILESYSTEM_ARG)) {
                properties = FileSystemParamParser.getProperties((String)arg2.substring(FILESYSTEM_ARG.length()));
                continue;
            }
            if (arg2.startsWith(ENCRYPTION_PASSWORD_ARG)) {
                bucketPathEncryptionPassword = new BucketPathEncryptionPassword(arg2.substring(ENCRYPTION_PASSWORD_ARG.length()));
                continue;
            }
            if (arg2.startsWith(NO_ENCRYPTION_PASSWORD_ARG)) {
                bucketPathEncryptionPassword = null;
                continue;
            }
            if (arg2.startsWith(ENCRYPTION_FILENAME_ONLY_ARG)) {
                bucketPathEncryptionFilenameOnly = BucketPathEncryptionFilenameOnly.TRUE;
                continue;
            }
            remainingArgs.add(arg2);
        }
        if (properties == null) {
            properties = FileSystemParamParser.getProperties((String)"");
        }
        ((ConnectionPropertiesImpl)properties).setBucketPathEncryptionPassword(bucketPathEncryptionPassword);
        ((ConnectionPropertiesImpl)properties).setBucketPathEncryptionFilenameOnly(bucketPathEncryptionFilenameOnly);
        String[] remainingArgArray = new String[remainingArgs.size()];
        remainingArgArray = remainingArgs.toArray(remainingArgArray);
        return new ArgsAndProperties((ConnectionProperties)properties, remainingArgArray);
    }

    public ConnectionProperties readEnvironment() {
        try {
            LOGGER.debug("readEnvironment");
            BucketPathEncryptionPassword bucketPathEncryptionPassword = ConnectionProperties.defaultEncryptionPassword;
            BucketPathEncryptionFilenameOnly bucketPathEncryptionFilenameOnly = ConnectionProperties.defaultBucketPathEncryptionFilenameOnly;
            MongoConnectionProperties properties = null;
            if (System.getProperty(ENCRYPTION_PASSWORD) != null) {
                bucketPathEncryptionPassword = new BucketPathEncryptionPassword(System.getProperty(ENCRYPTION_PASSWORD));
            }
            if (System.getProperty(NO_ENCRYPTION_PASSWORD) != null) {
                bucketPathEncryptionPassword = null;
            }
            if (System.getProperty(ENCRYPTION_FILENAME_ONLY) != null) {
                bucketPathEncryptionFilenameOnly = BucketPathEncryptionFilenameOnly.TRUE;
            }
            if (System.getProperty(MONGO) != null) {
                properties = MongoParamParser.getProperties((String)System.getProperty(MONGO));
            }
            if (System.getProperty(MINIO) != null) {
                properties = MinioParamParser.getProperties((String)System.getProperty(MINIO));
            }
            if (System.getProperty(AMAZONS3) != null) {
                properties = AmazonS3ParamParser.getProperties((String)System.getProperty(AMAZONS3));
            }
            if (System.getProperty(FILESYSTEM) != null) {
                properties = FileSystemParamParser.getProperties((String)System.getProperty(FILESYSTEM));
            }
            if (properties == null) {
                properties = FileSystemParamParser.getProperties((String)"");
            }
            ((ConnectionPropertiesImpl)properties).setBucketPathEncryptionPassword(bucketPathEncryptionPassword);
            ((ConnectionPropertiesImpl)properties).setBucketPathEncryptionFilenameOnly(bucketPathEncryptionFilenameOnly);
            return properties;
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public static class ArgsAndProperties {
        public ConnectionProperties properties;
        public String[] remainingArgs;

        public ArgsAndProperties(ConnectionProperties properties, String[] remainingArgs) {
            this.properties = properties;
            this.remainingArgs = remainingArgs;
        }
    }
}

