/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.cryptoutils.storeconnectionfactory;

import org.adorsys.cryptoutils.exceptions.BaseException;
import org.adorsys.cryptoutils.extendendstoreconnection.impl.ceph.CephExtendedStoreConnection;
import org.adorsys.cryptoutils.miniostoreconnection.MinioExtendedStoreConnection;
import org.adorsys.cryptoutils.mongodbstoreconnection.MongoDBExtendedStoreConnection;
import org.adorsys.cryptoutils.storeconnectionfactory.ReadArguments;
import org.adorsys.cryptoutils.storeconnectionfactory.StoreConnectionFactoryConfig;
import org.adorsys.encobject.filesystem.FileSystemExtendedStorageConnection;
import org.adorsys.encobject.service.api.ExtendedStoreConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedStoreConnectionFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExtendedStoreConnectionFactory.class);
    private static StoreConnectionFactoryConfig config = null;

    public static ExtendedStoreConnection get() {
        if (config == null) {
            config = new ReadArguments().readEnvironment();
        }
        switch (ExtendedStoreConnectionFactory.config.connectionType) {
            case MONGO: {
                return new MongoDBExtendedStoreConnection(ExtendedStoreConnectionFactory.config.mongoParams.getHost(), ExtendedStoreConnectionFactory.config.mongoParams.getPort(), ExtendedStoreConnectionFactory.config.mongoParams.getDatabasename());
            }
            case MINIO: {
                return new MinioExtendedStoreConnection(ExtendedStoreConnectionFactory.config.minioParams.getUrl(), ExtendedStoreConnectionFactory.config.minioParams.getMinioAccessKey(), ExtendedStoreConnectionFactory.config.minioParams.getMinioSecretKey(), ExtendedStoreConnectionFactory.config.minioParams.getRootBucketName());
            }
            case CEPH: {
                return new CephExtendedStoreConnection(ExtendedStoreConnectionFactory.config.cephParams.getUrl(), ExtendedStoreConnectionFactory.config.cephParams.getMinioAccessKey(), ExtendedStoreConnectionFactory.config.cephParams.getMinioSecretKey());
            }
            case FILE_SYSTEM: {
                return new FileSystemExtendedStorageConnection(ExtendedStoreConnectionFactory.config.fileSystemParamParser.getFilesystembase());
            }
        }
        throw new BaseException("missing switch");
    }

    public static void reset() {
        config = null;
    }

    public static String[] readArguments(String[] args) {
        ReadArguments.ArgsAndConfig argsAndConfig = new ReadArguments().readArguments(args);
        config = argsAndConfig.config;
        return argsAndConfig.remainingArgs;
    }
}

