/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.encobject.types;

import org.adorsys.cryptoutils.basetypes.BaseTypePasswordString;
import org.adorsys.cryptoutils.exceptions.BaseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketPathEncryptionPassword
extends BaseTypePasswordString {
    private static final Logger LOGGER = LoggerFactory.getLogger(BucketPathEncryptionPassword.class);
    public static final String specialChars = " <>{}^!\"\u00a7$%&/()=?\u00b4`{}#'*";

    public BucketPathEncryptionPassword(String s) {
        super(s);
        if (s.equalsIgnoreCase("null")) {
            throw new BaseException("Password must not be \"null\". Null should set the password to NULL");
        }
        if (s.length() < 10) {
            throw new BaseException("Password is not compless enough. At least 9 characters long");
        }
        if (s.toLowerCase().equals(s)) {
            throw new BaseException("Password is not compless enough. At least one uppercase char");
        }
        if (s.toUpperCase().equals(s)) {
            throw new BaseException("Password is not compless enough. At least one lowercase char");
        }
        if (!s.matches(".*[01234567890].*")) {
            throw new BaseException("Password is not compless enough. At least one digit");
        }
        if (!s.matches(".*[ <>{}^!\"\u00a7$%&/()=?\u00b4`{}#'*]{1}.*")) {
            throw new BaseException("Password is not compless enough. At least one special char of \" <>{}^!\"\u00a7$%&/()=?\u00b4`{}#'*\"");
        }
    }
}

