/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.encobject.service.impl;

import java.net.URI;
import java.util.Date;
import org.adorsys.encobject.domain.Location;
import org.adorsys.encobject.domain.ResourceMetadata;
import org.adorsys.encobject.domain.StorageMetadata;
import org.adorsys.encobject.domain.StorageType;
import org.adorsys.encobject.domain.UserMetaData;
import org.adorsys.encobject.service.impl.SimpleLocationImpl;

public class SimpleStorageMetadataImpl
implements StorageMetadata {
    private StorageType storageType = null;
    private String providerID = null;
    private String name = null;
    private SimpleLocationImpl location = null;
    private URI uri = null;
    private UserMetaData userMetaData = new UserMetaData();
    private String eTag = null;
    private Date creationDate = null;
    private Date lastModified = null;
    private Long size = null;
    private Boolean shouldBeCompressed = null;
    private String contentType = null;

    public void addUserMetadata(UserMetaData userMetaData) {
        for (String key : userMetaData.keySet()) {
            this.userMetaData.put(key, userMetaData.get(key));
        }
    }

    public SimpleStorageMetadataImpl() {
    }

    public SimpleStorageMetadataImpl(StorageMetadata storageMetadata) {
        this.setType((StorageType)((Object)storageMetadata.getType()));
        this.setProviderID(storageMetadata.getProviderID());
        this.setName(storageMetadata.getName());
        if (storageMetadata.getLocation() != null) {
            this.setLocation(storageMetadata.getLocation());
        }
        if (storageMetadata.getUri() != null) {
            this.setUri(URI.create(storageMetadata.getUri().toString()));
        }
        this.mergeUserMetadata(storageMetadata.getUserMetadata());
        this.setETag(storageMetadata.getETag());
        this.setCreationDate(storageMetadata.getCreationDate());
        this.setLastModified(storageMetadata.getLastModified());
        this.setSize(storageMetadata.getSize());
        this.setShouldBeCompressed(storageMetadata.getShouldBeCompressed());
        this.setContentType(storageMetadata.getContentType());
    }

    public void mergeUserMetadata(UserMetaData otherUserMetadata) {
        if (otherUserMetadata != null) {
            for (String key : otherUserMetadata.keySet()) {
                this.getUserMetadata().put(key, otherUserMetadata.get(key));
            }
        }
    }

    @Override
    public UserMetaData getUserMetadata() {
        return this.userMetaData;
    }

    @Override
    public StorageType getType() {
        return this.storageType;
    }

    public void setType(StorageType storageType) {
        this.storageType = storageType;
    }

    @Override
    public String getProviderID() {
        return this.providerID;
    }

    public void setProviderID(String providerID) {
        this.providerID = providerID;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public SimpleLocationImpl getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = new SimpleLocationImpl(location);
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    public void setUri(URI uri) {
        this.uri = uri;
    }

    @Override
    public String getETag() {
        return this.eTag;
    }

    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    @Override
    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date creationDate) {
        this.creationDate = creationDate;
    }

    @Override
    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    @Override
    public Long getSize() {
        return this.size;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    @Override
    public Boolean getShouldBeCompressed() {
        return this.shouldBeCompressed;
    }

    public void setShouldBeCompressed(Boolean shouldBeCompressed) {
        this.shouldBeCompressed = shouldBeCompressed;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public void setSize(Long size) {
        this.size = size;
    }

    @Override
    public int compareTo(ResourceMetadata<StorageType> o) {
        int otherHashCode;
        int myHashCode = this.hashCode();
        if (myHashCode < (otherHashCode = o.hashCode())) {
            return -1;
        }
        if (myHashCode > otherHashCode) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SimpleStorageMetadataImpl)) {
            return false;
        }
        SimpleStorageMetadataImpl that = (SimpleStorageMetadataImpl)o;
        if (this.storageType != that.storageType) {
            return false;
        }
        if (this.providerID != null ? !this.providerID.equals(that.providerID) : that.providerID != null) {
            return false;
        }
        if (this.getName() != null ? !this.getName().equals(that.getName()) : that.getName() != null) {
            return false;
        }
        if (this.getLocation() != null ? !this.getLocation().equals(that.getLocation()) : that.getLocation() != null) {
            return false;
        }
        if (this.getUri() != null ? !this.getUri().equals(that.getUri()) : that.getUri() != null) {
            return false;
        }
        if (this.userMetaData != null ? !this.userMetaData.equals(that.userMetaData) : that.userMetaData != null) {
            return false;
        }
        if (this.eTag != null ? !this.eTag.equals(that.eTag) : that.eTag != null) {
            return false;
        }
        if (this.getCreationDate() != null ? !this.getCreationDate().equals(that.getCreationDate()) : that.getCreationDate() != null) {
            return false;
        }
        if (this.getLastModified() != null ? !this.getLastModified().equals(that.getLastModified()) : that.getLastModified() != null) {
            return false;
        }
        return this.getSize() != null ? this.getSize().equals(that.getSize()) : that.getSize() == null;
    }

    public int hashCode() {
        int result = this.storageType != null ? this.storageType.hashCode() : 0;
        result = 31 * result + (this.providerID != null ? this.providerID.hashCode() : 0);
        result = 31 * result + (this.getName() != null ? this.getName().hashCode() : 0);
        result = 31 * result + (this.getLocation() != null ? this.getLocation().hashCode() : 0);
        result = 31 * result + (this.getUri() != null ? this.getUri().hashCode() : 0);
        result = 31 * result + (this.userMetaData != null ? this.userMetaData.hashCode() : 0);
        result = 31 * result + (this.eTag != null ? this.eTag.hashCode() : 0);
        result = 31 * result + (this.getCreationDate() != null ? this.getCreationDate().hashCode() : 0);
        result = 31 * result + (this.getLastModified() != null ? this.getLastModified().hashCode() : 0);
        result = 31 * result + (this.getSize() != null ? this.getSize().hashCode() : 0);
        return result;
    }
}

