/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.encobject.filesystem;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.adorsys.encobject.domain.Location;
import org.adorsys.encobject.domain.StorageMetadata;
import org.adorsys.encobject.service.impl.SimpleStorageMetadataImpl;

public class StorageMetadataFlattenerGSON {
    private Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(Location.class, new InterfaceAdapter()).create();

    public StorageMetadata fromJson(String jsonString) {
        return (StorageMetadata)this.gson.fromJson(jsonString, SimpleStorageMetadataImpl.class);
    }

    public String toJson(StorageMetadata storageMetadata) {
        return this.gson.toJson((Object)storageMetadata);
    }

    private static class InterfaceAdapter<T>
    implements JsonSerializer<T>,
    JsonDeserializer<T> {
        private static final String CLASSNAME = "CLASSNAME";
        private static final String DATA = "DATA";

        private InterfaceAdapter() {
        }

        public T deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            JsonPrimitive prim = (JsonPrimitive)jsonObject.get(CLASSNAME);
            String className = prim.getAsString();
            Class klass = this.getObjectClass(className);
            return (T)jsonDeserializationContext.deserialize(jsonObject.get(DATA), (Type)klass);
        }

        public JsonElement serialize(T jsonElement, Type type, JsonSerializationContext jsonSerializationContext) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty(CLASSNAME, jsonElement.getClass().getName());
            jsonObject.add(DATA, jsonSerializationContext.serialize(jsonElement));
            return jsonObject;
        }

        public Class getObjectClass(String className) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new JsonParseException(e.getMessage());
            }
        }
    }
}

