/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.encobject.complextypes;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.adorsys.encobject.complextypes.BucketDirectory;
import org.adorsys.encobject.domain.ObjectHandle;
import org.adorsys.encobject.exceptions.BucketException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketPath {
    public static final String BUCKET_SEPARATOR = "/";
    private static final Logger LOGGER = LoggerFactory.getLogger(BucketPath.class);
    String container = null;
    String name = null;

    public BucketPath(String path) {
        List<String> split = BucketPath.split(path);
        if (!split.isEmpty()) {
            this.container = split.remove(0);
            if (!split.isEmpty()) {
                this.name = split.stream().map(b -> b).collect(Collectors.joining(BUCKET_SEPARATOR));
            }
        } else {
            throw new BucketException("container must not be null");
        }
    }

    public BucketPath(String container, String path) {
        List<String> split;
        if (container != null && BucketPath.notOnlyWhitespace(container)) {
            if (container.indexOf(BUCKET_SEPARATOR) != -1) {
                throw new BucketException("container " + container + " must not contain " + BUCKET_SEPARATOR);
            }
            this.container = container;
        }
        if (!(split = BucketPath.split(path)).isEmpty()) {
            if (this.container == null) {
                throw new BucketException("not allowed to create a bucketPath with a path but no container");
            }
            this.name = split.stream().map(b -> b).collect(Collectors.joining(BUCKET_SEPARATOR));
        }
    }

    public BucketPath(BucketPath bucketPath) {
        this.container = bucketPath.container;
        this.name = bucketPath.name;
    }

    public BucketPath append(BucketPath bucketPath) {
        if (this.container == null) {
            if (this.name != null) {
                throw new BucketException("Programming Error. BucketPath must not exist with no container but a name " + this.name);
            }
            return bucketPath;
        }
        String appendedName = "";
        if (this.name != null) {
            appendedName = this.name;
        }
        if (bucketPath.container != null) {
            if (appendedName.length() > 0) {
                appendedName = appendedName + BUCKET_SEPARATOR;
            }
            appendedName = appendedName + bucketPath.container;
        }
        if (bucketPath.name != null) {
            if (appendedName.length() > 0) {
                appendedName = appendedName + BUCKET_SEPARATOR;
            }
            appendedName = appendedName + bucketPath.name;
        }
        return new BucketPath(this.container, appendedName);
    }

    public BucketPath append(String path) {
        return this.append(new BucketPath(path));
    }

    public BucketPath add(String suffix) {
        if (this.name == null) {
            throw new BucketException("add not possible, because name is null. container is " + this.container);
        }
        return new BucketPath(this.container, this.name + suffix);
    }

    public ObjectHandle getObjectHandle() {
        return new ObjectHandle(this.container, this.name);
    }

    private static List<String> split(String fullBucketPath) {
        ArrayList<String> list = new ArrayList<String>();
        if (fullBucketPath == null) {
            return list;
        }
        StringTokenizer st = new StringTokenizer(fullBucketPath, BUCKET_SEPARATOR);
        while (st.hasMoreElements()) {
            String token = st.nextToken();
            if (!BucketPath.notOnlyWhitespace(token)) continue;
            list.add(token);
        }
        return list;
    }

    public static BucketPath fromHandle(ObjectHandle objectHandle) {
        return new BucketPath(objectHandle.getContainer(), objectHandle.getName());
    }

    public String toString() {
        return "BucketPath{" + this.container + " - " + this.name + '}';
    }

    public BucketDirectory getBucketDirectory() {
        ObjectHandle objectHandle = this.getObjectHandle();
        String name = objectHandle.getName();
        if (name == null) {
            return new BucketDirectory("");
        }
        BucketDirectory documentDirectory = new BucketDirectory(this.getObjectHandle().getContainer());
        String directory = BucketPath.getDirectoryOf(name);
        if (directory != null) {
            documentDirectory = documentDirectory.appendDirectory(directory);
        }
        return documentDirectory;
    }

    private static String getDirectoryOf(String value) {
        int i = value.lastIndexOf(BUCKET_SEPARATOR);
        if (i == -1) {
            return null;
        }
        return value.substring(0, i);
    }

    private static boolean notOnlyWhitespace(String value) {
        return value.replaceAll(" ", "").length() > 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BucketPath)) {
            return false;
        }
        BucketPath that = (BucketPath)o;
        if (!this.container.equals(that.container)) {
            return false;
        }
        return this.name != null ? this.name.equals(that.name) : that.name == null;
    }

    public int hashCode() {
        int result = this.container.hashCode();
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }
}

