/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.cryptoutils.extendedstoreconnection.impls.pathencryption;

import java.util.ArrayList;
import java.util.List;
import org.adorsys.cryptoutils.extendedstoreconnection.impls.pathencryption.BucketPathEncryption;
import org.adorsys.cryptoutils.utils.Frame;
import org.adorsys.encobject.complextypes.BucketDirectory;
import org.adorsys.encobject.complextypes.BucketPath;
import org.adorsys.encobject.complextypes.BucketPathUtil;
import org.adorsys.encobject.domain.Payload;
import org.adorsys.encobject.domain.PayloadStream;
import org.adorsys.encobject.domain.StorageMetadata;
import org.adorsys.encobject.service.api.ExtendedStoreConnection;
import org.adorsys.encobject.service.impl.SimplePayloadImpl;
import org.adorsys.encobject.service.impl.SimplePayloadStreamImpl;
import org.adorsys.encobject.service.impl.SimpleStorageMetadataImpl;
import org.adorsys.encobject.types.BucketPathEncryptionPassword;
import org.adorsys.encobject.types.ListRecursiveFlag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketPathEncryptingExtendedStoreConnection
implements ExtendedStoreConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(BucketPathEncryptingExtendedStoreConnection.class);
    protected ExtendedStoreConnection extendedStoreConnection;
    BucketPathEncryption bucketPathEncryption;
    BucketPathEncryptionPassword bucketPathEncryptionPassword;
    boolean active;

    public BucketPathEncryptingExtendedStoreConnection(ExtendedStoreConnection extendedStoreConnection, BucketPathEncryptionPassword bucketPathEncryptionPassword) {
        this.active = this.bucketPathEncryptionPassword != null;
        this.extendedStoreConnection = extendedStoreConnection;
        this.bucketPathEncryption = new BucketPathEncryption();
        this.bucketPathEncryptionPassword = bucketPathEncryptionPassword;
        this.active = bucketPathEncryptionPassword != null;
        Frame frame = new Frame();
        if (this.active) {
            frame.add(bucketPathEncryptionPassword.toString());
        } else {
            frame.add("Filenames will not be encrypted");
        }
        LOGGER.info(frame.toString());
    }

    public void putBlob(BucketPath bucketPath, Payload payload) {
        this.extendedStoreConnection.putBlob(this.e(bucketPath), payload);
    }

    public Payload getBlob(BucketPath bucketPath) {
        return this.d(this.extendedStoreConnection.getBlob(this.e(bucketPath)));
    }

    public Payload getBlob(BucketPath bucketPath, StorageMetadata storageMetadata) {
        return this.d(this.extendedStoreConnection.getBlob(this.e(bucketPath), this.e(storageMetadata)));
    }

    public void putBlobStream(BucketPath bucketPath, PayloadStream payloadStream) {
        this.extendedStoreConnection.putBlobStream(this.e(bucketPath), payloadStream);
    }

    public PayloadStream getBlobStream(BucketPath bucketPath) {
        return this.d(this.extendedStoreConnection.getBlobStream(this.e(bucketPath)));
    }

    public PayloadStream getBlobStream(BucketPath bucketPath, StorageMetadata storageMetadata) {
        return this.d(this.extendedStoreConnection.getBlobStream(this.e(bucketPath), this.e(storageMetadata)));
    }

    public void putBlob(BucketPath bucketPath, byte[] bytes) {
        this.extendedStoreConnection.putBlob(this.e(bucketPath), bytes);
    }

    public StorageMetadata getStorageMetadata(BucketPath bucketPath) {
        return this.d(this.extendedStoreConnection.getStorageMetadata(this.e(bucketPath)));
    }

    public boolean blobExists(BucketPath bucketPath) {
        return this.extendedStoreConnection.blobExists(this.e(bucketPath));
    }

    public void removeBlob(BucketPath bucketPath) {
        this.extendedStoreConnection.removeBlob(this.e(bucketPath));
    }

    public void removeBlobFolder(BucketDirectory bucketDirectory) {
        this.extendedStoreConnection.removeBlobFolder(this.e(bucketDirectory));
    }

    public void createContainer(BucketDirectory bucketDirectory) {
        this.extendedStoreConnection.createContainer(this.e(bucketDirectory));
    }

    public boolean containerExists(BucketDirectory bucketDirectory) {
        return this.extendedStoreConnection.containerExists(this.e(bucketDirectory));
    }

    public void deleteContainer(BucketDirectory bucketDirectory) {
        this.extendedStoreConnection.deleteContainer(this.e(bucketDirectory));
    }

    public List<StorageMetadata> list(BucketDirectory bucketDirectory, ListRecursiveFlag listRecursiveFlag) {
        return this.d(this.extendedStoreConnection.list(this.e(bucketDirectory), listRecursiveFlag));
    }

    public List<BucketDirectory> listAllBuckets() {
        return this.de(this.extendedStoreConnection.listAllBuckets());
    }

    private List<BucketDirectory> de(List<BucketDirectory> bucketDirectories) {
        ArrayList<BucketDirectory> newBucketDirectoryList = new ArrayList<BucketDirectory>();
        bucketDirectories.forEach(bucketDirectory -> newBucketDirectoryList.add(this.d((BucketDirectory)bucketDirectory)));
        return newBucketDirectoryList;
    }

    private BucketPath e(BucketPath bucketPath) {
        if (!this.active) {
            return bucketPath;
        }
        return BucketPathEncryption.encrypt(this.bucketPathEncryptionPassword, bucketPath);
    }

    private BucketDirectory e(BucketDirectory bucketDirectory) {
        if (!this.active) {
            return bucketDirectory;
        }
        return BucketPathEncryption.encrypt(this.bucketPathEncryptionPassword, bucketDirectory);
    }

    private BucketDirectory d(BucketDirectory bucketDirectory) {
        if (!this.active) {
            return bucketDirectory;
        }
        return BucketPathEncryption.decrypt(this.bucketPathEncryptionPassword, bucketDirectory);
    }

    private Payload d(Payload payload) {
        if (!this.active) {
            return payload;
        }
        return new SimplePayloadImpl(this.d(payload.getStorageMetadata()), payload.getData());
    }

    private PayloadStream d(PayloadStream payloadStream) {
        if (!this.active) {
            return payloadStream;
        }
        return new SimplePayloadStreamImpl(this.d(payloadStream.getStorageMetadata()), payloadStream.openStream());
    }

    private StorageMetadata d(StorageMetadata storageMetadata) {
        if (!this.active) {
            return storageMetadata;
        }
        String encryptedName = storageMetadata.getName();
        BucketPath encryptedBucketPath = new BucketPath(encryptedName);
        BucketPath decryptedBucketPath = BucketPathEncryption.decrypt(this.bucketPathEncryptionPassword, encryptedBucketPath);
        String decryptedName = BucketPathUtil.getAsString((BucketPath)decryptedBucketPath);
        SimpleStorageMetadataImpl newStorageMetadata = new SimpleStorageMetadataImpl(storageMetadata);
        newStorageMetadata.setName(decryptedName);
        return newStorageMetadata;
    }

    private StorageMetadata e(StorageMetadata storageMetadata) {
        if (!this.active) {
            return storageMetadata;
        }
        if (storageMetadata == null) {
            return storageMetadata;
        }
        String plainName = storageMetadata.getName();
        BucketPath plainBucketPath = new BucketPath(plainName);
        BucketPath encryptedBucketPath = BucketPathEncryption.encrypt(this.bucketPathEncryptionPassword, plainBucketPath);
        String encryptedName = BucketPathUtil.getAsString((BucketPath)encryptedBucketPath);
        SimpleStorageMetadataImpl newStorageMetadata = new SimpleStorageMetadataImpl(storageMetadata);
        newStorageMetadata.setName(encryptedName);
        return newStorageMetadata;
    }

    private List<StorageMetadata> d(List<StorageMetadata> list) {
        if (!this.active) {
            return list;
        }
        ArrayList<StorageMetadata> newStorageMetadataList = new ArrayList<StorageMetadata>();
        list.forEach(storageMetadata -> newStorageMetadataList.add(this.d((StorageMetadata)storageMetadata)));
        return newStorageMetadataList;
    }
}

