/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.cryptoutils.extendedstoreconnection.impls.pathencryption;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.StringTokenizer;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.adorsys.cryptoutils.exceptions.BaseExceptionHandler;
import org.adorsys.cryptoutils.utils.HexUtil;
import org.adorsys.encobject.complextypes.BucketDirectory;
import org.adorsys.encobject.complextypes.BucketPath;
import org.adorsys.encobject.complextypes.BucketPathUtil;
import org.adorsys.encobject.exceptions.PathDecryptionException;
import org.adorsys.encobject.exceptions.PathEncryptionException;
import org.adorsys.encobject.types.BucketPathEncryptionPassword;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BucketPathEncryption {
    private static final Logger LOGGER = LoggerFactory.getLogger(BucketPathEncryption.class);
    private static final Charset CHARSET = Charset.forName("UTF-8");
    public static final boolean encryptContainer = true;

    public static BucketDirectory encrypt(BucketPathEncryptionPassword bucketPathEncryptionPassword, BucketDirectory bucketDirectory) {
        return new BucketDirectory(BucketPathEncryption.encrypt(bucketPathEncryptionPassword, BucketPathUtil.getAsString((BucketDirectory)bucketDirectory)));
    }

    public static BucketPath encrypt(BucketPathEncryptionPassword bucketPathEncryptionPassword, BucketPath bucketPath) {
        return new BucketPath(BucketPathEncryption.encrypt(bucketPathEncryptionPassword, BucketPathUtil.getAsString((BucketPath)bucketPath)));
    }

    public static BucketDirectory decrypt(BucketPathEncryptionPassword bucketPathEncryptionPassword, BucketDirectory bucketDirectory) {
        return new BucketDirectory(BucketPathEncryption.decrypt(bucketPathEncryptionPassword, BucketPathUtil.getAsString((BucketDirectory)bucketDirectory)));
    }

    public static BucketPath decrypt(BucketPathEncryptionPassword bucketPathEncryptionPassword, BucketPath bucketPath) {
        return new BucketPath(BucketPathEncryption.decrypt(bucketPathEncryptionPassword, BucketPathUtil.getAsString((BucketPath)bucketPath)));
    }

    private static String encrypt(BucketPathEncryptionPassword bucketPathEncryptionPassword, String fullString) {
        try {
            Cipher cipher = BucketPathEncryption.createCipher(bucketPathEncryptionPassword, 1);
            StringBuilder encryptedPath = new StringBuilder();
            StringTokenizer st = new StringTokenizer(fullString, "/");
            while (st.hasMoreTokens()) {
                String plainString = st.nextToken();
                byte[] plainBytes = plainString.getBytes(CHARSET);
                byte[] encryptedBytes = cipher.doFinal(plainBytes);
                String encryptedBytesAsHexString = HexUtil.convertBytesToHexString((byte[])encryptedBytes).toLowerCase();
                encryptedPath.append("/" + encryptedBytesAsHexString);
            }
            LOGGER.debug("encrypted (" + fullString + ") -> (" + encryptedPath.toString() + ")");
            return encryptedPath.toString();
        }
        catch (Exception e) {
            throw new PathEncryptionException(fullString, e);
        }
    }

    public static String decrypt(BucketPathEncryptionPassword BucketPathEncryptionPassword2, String encryptedHexString) {
        try {
            Cipher cipher = BucketPathEncryption.createCipher(BucketPathEncryptionPassword2, 2);
            StringBuilder plainPath = new StringBuilder();
            StringTokenizer st = new StringTokenizer(encryptedHexString, "/");
            while (st.hasMoreTokens()) {
                String encryptedBytesAsHexString = st.nextToken();
                byte[] encryptedBytes = HexUtil.convertHexStringToBytes((String)encryptedBytesAsHexString.toUpperCase());
                byte[] plainBytes = cipher.doFinal(encryptedBytes);
                String plainString = new String(plainBytes, CHARSET);
                plainPath.append("/" + plainString);
            }
            LOGGER.debug("decrypted (" + encryptedHexString + ") -> (" + plainPath.toString() + ")");
            return plainPath.toString();
        }
        catch (Exception e) {
            throw new PathDecryptionException(encryptedHexString, e);
        }
    }

    private static Cipher createCipher(BucketPathEncryptionPassword bucketPathEncryptionPassword, int cipherMode) {
        try {
            byte[] key = bucketPathEncryptionPassword.getValue().getBytes("UTF-8");
            MessageDigest sha = MessageDigest.getInstance("SHA-256");
            key = sha.digest(key);
            key = Arrays.copyOf(key, 16);
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            cipher.init(cipherMode, secretKeySpec);
            return cipher;
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }
}

