/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.cryptoutils.miniostoreconnection;

import java.net.URL;
import java.util.StringTokenizer;
import org.adorsys.cryptoutils.miniostoreconnection.MinioConnectionPropertiesImpl;
import org.adorsys.encobject.exceptions.ParamParserException;
import org.adorsys.encobject.types.connection.MinioAccessKey;
import org.adorsys.encobject.types.connection.MinioRootBucketName;
import org.adorsys.encobject.types.connection.MinioSecretKey;
import org.adorsys.encobject.types.properties.MinioConnectionProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioParamParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinioParamParser.class);
    private static final String DELIMITER = ",";
    private static final String EXPECTED_PARAMS = "<url>,<accesskey>,<secretkey>[,<rootbucket>]";

    public static MinioConnectionProperties getProperties(String params) {
        LOGGER.debug("parse:" + params);
        try {
            MinioConnectionPropertiesImpl properties = new MinioConnectionPropertiesImpl();
            StringTokenizer st = new StringTokenizer(params, DELIMITER);
            properties.setUrl(new URL(st.nextToken()));
            properties.setMinioAccessKey(new MinioAccessKey(st.nextToken()));
            properties.setMinioSecretKey(new MinioSecretKey(st.nextToken()));
            if (st.hasMoreElements()) {
                properties.setMinioRootBucketName(new MinioRootBucketName(st.nextToken()));
            }
            return properties;
        }
        catch (Exception e) {
            throw new ParamParserException(params, DELIMITER, EXPECTED_PARAMS);
        }
    }
}

