/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.cryptoutils.miniostoreconnection;

import java.net.URL;
import java.util.StringTokenizer;
import org.adorsys.cryptoutils.miniostoreconnection.MinioAccessKey;
import org.adorsys.cryptoutils.miniostoreconnection.MinioSecretKey;
import org.adorsys.encobject.exceptions.ParamParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioParamParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinioParamParser.class);
    private URL url;
    private MinioAccessKey minioAccessKey;
    private MinioSecretKey minioSecretKey;
    private String rootBucketName = "org.adorsys.cryptoutils";
    private static final String DELIMITER = ",";
    private static final String EXPECTED_PARAMS = "<url>,<accesskey>,<secretkey>[,<rootbucket>]";

    public MinioParamParser(String params) {
        LOGGER.debug("parse:" + params);
        try {
            StringTokenizer st = new StringTokenizer(params, DELIMITER);
            String urlString = st.nextToken();
            String accessKey = st.nextToken();
            String secretKey = st.nextToken();
            this.url = new URL(urlString);
            this.minioAccessKey = new MinioAccessKey(accessKey);
            this.minioSecretKey = new MinioSecretKey(secretKey);
            if (st.hasMoreElements()) {
                this.rootBucketName = st.nextToken();
            }
        }
        catch (Exception e) {
            throw new ParamParserException(params, DELIMITER, EXPECTED_PARAMS);
        }
    }

    public URL getUrl() {
        return this.url;
    }

    public MinioAccessKey getMinioAccessKey() {
        return this.minioAccessKey;
    }

    public MinioSecretKey getMinioSecretKey() {
        return this.minioSecretKey;
    }

    public String getRootBucketName() {
        return this.rootBucketName;
    }
}

