/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.cryptoutils.miniostoreconnection;

import io.minio.MinioClient;
import io.minio.Result;
import io.minio.messages.Bucket;
import io.minio.messages.DeleteError;
import io.minio.messages.Item;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.adorsys.cryptoutils.exceptions.BaseException;
import org.adorsys.cryptoutils.exceptions.BaseExceptionHandler;
import org.adorsys.cryptoutils.miniostoreconnection.MinioAccessKey;
import org.adorsys.cryptoutils.miniostoreconnection.MinioSecretKey;
import org.adorsys.encobject.complextypes.BucketDirectory;
import org.adorsys.encobject.complextypes.BucketPath;
import org.adorsys.encobject.complextypes.BucketPathUtil;
import org.adorsys.encobject.domain.Payload;
import org.adorsys.encobject.domain.PayloadStream;
import org.adorsys.encobject.domain.StorageMetadata;
import org.adorsys.encobject.domain.StorageType;
import org.adorsys.encobject.exceptions.BucketException;
import org.adorsys.encobject.exceptions.ResourceNotFoundException;
import org.adorsys.encobject.exceptions.StorageConnectionException;
import org.adorsys.encobject.filesystem.StorageMetadataFlattenerGSON;
import org.adorsys.encobject.service.api.ExtendedStoreConnection;
import org.adorsys.encobject.service.impl.SimplePayloadImpl;
import org.adorsys.encobject.service.impl.SimplePayloadStreamImpl;
import org.adorsys.encobject.service.impl.SimpleStorageMetadataImpl;
import org.adorsys.encobject.service.impl.StoreConnectionListHelper;
import org.adorsys.encobject.types.ListRecursiveFlag;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioExtendedStoreConnection
implements ExtendedStoreConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinioExtendedStoreConnection.class);
    private static final String CONTENT_TYPE = "";
    private static final String ROOT_BUCKET = "org.adorsys.cryptoutils";
    private static final String METADATA_EXT = ".metadata.extension.";
    private static final String CONTAINER_BUCKET = "org.adorsys.cryptoutils.containers";
    private static final String MINIO_TMP_FILE_PREFIX = "MINIO_TMP_FILE_";
    private static final String MINIO_TMP_FILE_SUFFIX = "";
    private static final BucketDirectory rootBucket = new BucketDirectory("org.adorsys.cryptoutils");
    private static final BucketDirectory containerBucket = new BucketDirectory("org.adorsys.cryptoutils.containers");
    public static final String CHARSET_NAME = "UTF-8";
    private final MinioClient minioClient;
    private final StorageMetadataFlattenerGSON storageMetadataFlattenerGSON = new StorageMetadataFlattenerGSON();

    public MinioExtendedStoreConnection(URL url, MinioAccessKey minioAccessKey, MinioSecretKey minioSecretKey) {
        try {
            this.minioClient = new MinioClient(url, minioAccessKey.getValue(), minioSecretKey.getValue());
            if (!this.minioClient.bucketExists(rootBucket.getObjectHandle().getContainer())) {
                LOGGER.debug("real bucket " + rootBucket + " wird angelegt ");
                this.minioClient.makeBucket(rootBucket.getObjectHandle().getContainer());
            } else {
                LOGGER.debug("real bucket " + rootBucket + " wird existiert bereits ");
            }
            if (!this.minioClient.bucketExists(containerBucket.getObjectHandle().getContainer())) {
                LOGGER.debug("container bucket " + containerBucket + " wird angelegt ");
                this.minioClient.makeBucket(containerBucket.getObjectHandle().getContainer());
            } else {
                LOGGER.debug("container bucket " + containerBucket + " wird existiert bereits ");
            }
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public void putBlob(BucketPath bucketPath, Payload payload) {
        this.putBlobStreamWithMemory(bucketPath, (PayloadStream)new SimplePayloadStreamImpl(payload.getStorageMetadata(), (InputStream)new ByteArrayInputStream(payload.getData())), payload.getData().length);
    }

    public Payload getBlob(BucketPath bucketPath) {
        try {
            PayloadStream payloadStream = this.getBlobStream(bucketPath);
            return new SimplePayloadImpl(payloadStream.getStorageMetadata(), IOUtils.toByteArray((InputStream)payloadStream.openStream()));
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public void putBlobStream(BucketPath bucketPath, PayloadStream payloadStream) {
        this.putBlobStreamWithTempFile(bucketPath, payloadStream);
        this.storeMetadata(bucketPath, payloadStream.getStorageMetadata());
    }

    public PayloadStream getBlobStream(BucketPath bucketPath) {
        try {
            StorageMetadata storageMetadata = this.getStorageMetadata(bucketPath);
            InputStream stream = this.minioClient.getObject(rootBucket.append(bucketPath).getObjectHandle().getContainer(), rootBucket.append(bucketPath).getObjectHandle().getName());
            SimplePayloadStreamImpl payloadStream = new SimplePayloadStreamImpl(storageMetadata, stream);
            return payloadStream;
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public void putBlob(BucketPath bucketPath, byte[] bytes) {
        this.putBlob(bucketPath, (Payload)new SimplePayloadImpl((StorageMetadata)new SimpleStorageMetadataImpl(), bytes));
    }

    public StorageMetadata getStorageMetadata(BucketPath bucketPath) {
        try {
            if (!this.blobExists(bucketPath)) {
                throw new ResourceNotFoundException(bucketPath.toString());
            }
            LOGGER.debug("load metadata for " + bucketPath);
            InputStream is = this.minioClient.getObject(rootBucket.append(bucketPath).getObjectHandle().getContainer(), rootBucket.append(bucketPath).add(METADATA_EXT).getObjectHandle().getName());
            byte[] bytes = IOUtils.toByteArray((InputStream)is);
            String jsonString = new String(bytes, CHARSET_NAME);
            StorageMetadata storageMetadata = this.storageMetadataFlattenerGSON.fromJson(jsonString);
            return storageMetadata;
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public boolean blobExists(BucketPath bucketPath) {
        LOGGER.debug("blobExists:" + bucketPath);
        String container = rootBucket.append(bucketPath).getObjectHandle().getContainer();
        String prefix = rootBucket.append(bucketPath).getObjectHandle().getName();
        ArrayList<String> list = new ArrayList<String>();
        this.minioClient.listObjects(container, prefix, false).forEach(item -> {
            try {
                list.add(((Item)item.get()).objectName());
            }
            catch (Exception e) {
                throw BaseExceptionHandler.handle((Throwable)e);
            }
        });
        list.forEach(el -> LOGGER.debug("FOUND :" + el));
        boolean value = !list.isEmpty();
        LOGGER.debug("blobExists:" + bucketPath + " -> " + value);
        return value;
    }

    public void removeBlob(BucketPath bucketPath) {
        try {
            LOGGER.debug("removeBlob " + bucketPath);
            this.minioClient.removeObject(rootBucket.append(bucketPath).getObjectHandle().getContainer(), rootBucket.append(bucketPath).getObjectHandle().getName());
            this.minioClient.removeObject(rootBucket.append(bucketPath).getObjectHandle().getContainer(), rootBucket.append(bucketPath).add(METADATA_EXT).getObjectHandle().getName());
            LOGGER.debug("removeBlob done " + bucketPath);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public void removeBlobFolder(BucketDirectory bucketDirectory) {
        if (bucketDirectory.getObjectHandle().getName() == null) {
            throw new StorageConnectionException("not a valid bucket directory " + bucketDirectory);
        }
        List<StorageMetadata> list = this.list(bucketDirectory, ListRecursiveFlag.TRUE);
        list.forEach(metadata -> {
            if (((StorageType)metadata.getType()).equals((Object)StorageType.BLOB)) {
                this.removeBlob(new BucketPath(metadata.getName()));
            }
        });
    }

    public void removeBlobs(Iterable<BucketPath> iterable) {
        iterable.forEach(bucketPath -> this.removeBlob((BucketPath)bucketPath));
    }

    public long countBlobs(BucketDirectory bucketDirectory, ListRecursiveFlag listRecursiveFlag) {
        return this.list(bucketDirectory, listRecursiveFlag).size();
    }

    public void createContainer(BucketDirectory bucketDirectory) {
        try {
            LOGGER.debug("create container " + bucketDirectory);
            if (!this.containerExists(bucketDirectory)) {
                byte[] bytes = "X".getBytes();
                this.minioClient.putObject(containerBucket.getObjectHandle().getContainer(), containerBucket.appendName(bucketDirectory.getObjectHandle().getContainer()).getObjectHandle().getName(), (InputStream)new ByteArrayInputStream(bytes), (long)bytes.length, "");
            }
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public boolean containerExists(BucketDirectory bucketDirectory) {
        try {
            LOGGER.debug("containerExists:" + bucketDirectory);
            ArrayList list = new ArrayList();
            this.minioClient.listObjects(containerBucket.getObjectHandle().getContainer(), bucketDirectory.getObjectHandle().getContainer()).forEach(item -> {
                try {
                    list.add(((Item)item.get()).objectName());
                }
                catch (Exception e) {
                    throw BaseExceptionHandler.handle((Throwable)e);
                }
            });
            boolean value = !list.isEmpty();
            LOGGER.debug("containerExists:" + bucketDirectory + " -> " + value);
            return value;
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public void deleteContainer(BucketDirectory bucketDirectory) {
        LOGGER.debug("deleteContainer " + bucketDirectory);
        try {
            ArrayList objectNames = new ArrayList();
            this.minioClient.listObjects(rootBucket.getObjectHandle().getContainer(), rootBucket.append(bucketDirectory).getObjectHandle().getName()).forEach(el -> {
                try {
                    objectNames.add(((Item)el.get()).objectName());
                }
                catch (Exception e) {
                    throw BaseExceptionHandler.handle((Throwable)e);
                }
            });
            LOGGER.debug("delete " + objectNames.size() + " Elements of Container " + bucketDirectory);
            this.minioClient.removeObject(rootBucket.getObjectHandle().getContainer(), objectNames).forEach(error -> {
                try {
                    DeleteError de = (DeleteError)error.get();
                    throw new BucketException("can not delete File " + de.objectName() + " of bucket " + rootBucket.append(bucketDirectory).getObjectHandle().getContainer() + " :" + de.message());
                }
                catch (Exception e) {
                    throw BaseExceptionHandler.handle((Throwable)e);
                }
            });
            this.minioClient.removeObject(containerBucket.getObjectHandle().getContainer(), bucketDirectory.getObjectHandle().getContainer());
            LOGGER.debug("eventually delete empty Container " + bucketDirectory);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public List<StorageMetadata> list(BucketDirectory bucketDirectory, ListRecursiveFlag listRecursiveFlag) {
        ArrayList<StorageMetadata> returnList = new ArrayList<StorageMetadata>();
        if (!this.containerExists(bucketDirectory)) {
            return returnList;
        }
        String container = bucketDirectory.getObjectHandle().getContainer();
        LOGGER.debug("container ist hier:" + container);
        String directoryname = null;
        String prefix = bucketDirectory.getObjectHandle().getName();
        if (prefix == null) {
            prefix = "";
            directoryname = rootBucket.appendDirectory(container).getObjectHandle().getName();
        } else {
            directoryname = rootBucket.appendDirectory(container).appendDirectory(prefix).getObjectHandle().getName();
        }
        ArrayList<BucketPath> bucketPaths = new ArrayList<BucketPath>();
        LOGGER.debug("search in " + bucketDirectory + " with prefix " + prefix + " " + listRecursiveFlag);
        LOGGER.debug("real search in " + rootBucket.appendDirectory(container).getObjectHandle().getContainer() + " with prefix " + directoryname + " true");
        this.minioClient.listObjects(rootBucket.appendDirectory(container).getObjectHandle().getContainer(), directoryname, true).forEach(el -> {
            try {
                String name = ((Item)el.get()).objectName();
                BucketPath bucketPath = new BucketPath(name);
                if (!bucketPath.getObjectHandle().getName().endsWith(METADATA_EXT)) {
                    LOGGER.debug("found: " + bucketPath);
                    bucketPaths.add(bucketPath);
                }
            }
            catch (Exception e) {
                throw BaseExceptionHandler.handle((Throwable)e);
            }
        });
        if (bucketPaths.contains(new BucketPath(bucketDirectory.getObjectHandle().getContainer(), bucketDirectory.getObjectHandle().getName()))) {
            return returnList;
        }
        String pref = prefix;
        LOGGER.debug("filter prefix ist " + pref);
        Set bucketDirectories = StoreConnectionListHelper.findAllSubDirs(bucketPaths);
        bucketDirectories.add(bucketDirectory);
        if (listRecursiveFlag.equals((Object)ListRecursiveFlag.FALSE)) {
            bucketDirectories.removeIf(bucketSubdir -> {
                String name = bucketSubdir.getObjectHandle().getName();
                if (name == null) {
                    LOGGER.debug("filter bucketDirectory " + bucketSubdir + " -> false");
                    return false;
                }
                if (!name.startsWith(pref)) {
                    throw new BaseException("expected " + name + " to start with " + pref);
                }
                String remainder = name.substring(pref.length());
                int firstSlash = remainder.indexOf("/");
                boolean filterMeOut = false;
                if (pref.length() == 0) {
                    boolean bl = filterMeOut = firstSlash != -1;
                }
                if (!filterMeOut && firstSlash != -1) {
                    int secondSlash = remainder.indexOf("/", firstSlash + 1);
                    filterMeOut = secondSlash != -1;
                }
                LOGGER.debug("filter bucketDirectory " + bucketSubdir + " " + remainder + " -> " + filterMeOut);
                return filterMeOut;
            });
        }
        bucketDirectories.forEach(bucketSubdir -> {
            SimpleStorageMetadataImpl metadata = new SimpleStorageMetadataImpl();
            metadata.setType(StorageType.FOLDER);
            metadata.setName(BucketPathUtil.getAsString((BucketDirectory)bucketSubdir));
            returnList.add((StorageMetadata)metadata);
        });
        if (listRecursiveFlag.equals((Object)ListRecursiveFlag.FALSE)) {
            bucketPaths.removeIf(bucketPath -> {
                String name = bucketPath.getObjectHandle().getName();
                if (!name.startsWith(pref)) {
                    throw new BaseException("expected " + name + " to start with " + pref);
                }
                String remainder = name.substring(pref.length() + 1);
                int index = remainder.indexOf("/");
                boolean filterMeOut = index != -1;
                LOGGER.debug("filter bucketPath " + bucketPath + " " + remainder + " -> " + filterMeOut);
                return filterMeOut;
            });
        }
        bucketPaths.forEach(bucketPath -> returnList.add(this.getStorageMetadata((BucketPath)bucketPath)));
        LOGGER.debug("List returns");
        returnList.forEach(metaData -> LOGGER.debug(metaData.getName() + " " + metaData.getType()));
        return returnList;
    }

    public List<BucketDirectory> listAllBuckets() {
        try {
            ArrayList<BucketDirectory> list = new ArrayList<BucketDirectory>();
            Iterator iterator = this.minioClient.listObjects(containerBucket.getObjectHandle().getContainer()).iterator();
            while (iterator.hasNext()) {
                list.add(new BucketDirectory(((Item)((Result)iterator.next()).get()).objectName()));
            }
            return list;
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public void cleanDatabase() {
        try {
            Iterator iterator = this.minioClient.listBuckets().iterator();
            while (iterator.hasNext()) {
                String realBucketName = ((Bucket)iterator.next()).name();
                for (Result el : this.minioClient.listObjects(realBucketName)) {
                    LOGGER.debug("remove " + realBucketName + "->" + ((Item)el.get()).objectName());
                    this.minioClient.removeObject(realBucketName, ((Item)el.get()).objectName());
                }
                if (realBucketName.equals(rootBucket.getObjectHandle().getContainer()) || realBucketName.equals(containerBucket.getObjectHandle().getContainer())) continue;
                LOGGER.debug("remove bucket " + realBucketName);
                this.minioClient.removeBucket(realBucketName);
            }
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public void showDatabase() {
        try {
            Iterator iterator = this.minioClient.listBuckets().iterator();
            while (iterator.hasNext()) {
                String realBucketName = ((Bucket)iterator.next()).name();
                for (Result el : this.minioClient.listObjects(realBucketName)) {
                    LOGGER.debug("found " + realBucketName + "->" + ((Item)el.get()).objectName());
                }
            }
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    private void putBlobStreamWithMemory(BucketPath bucketPath, PayloadStream payloadStream, int size) {
        LOGGER.debug("store to minio with known size of " + size);
        try {
            this.storeMetadata(bucketPath, payloadStream.getStorageMetadata());
            byte[] bytes = IOUtils.toByteArray((InputStream)payloadStream.openStream());
            this.minioClient.putObject(rootBucket.append(bucketPath).getObjectHandle().getContainer(), rootBucket.append(bucketPath).getObjectHandle().getName(), (InputStream)new ByteArrayInputStream(bytes), (long)bytes.length, "");
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    private void putBlobStreamWithTempFile(BucketPath bucketPath, PayloadStream payloadStream) {
        try {
            LOGGER.debug("store " + bucketPath + " to tmpfile with unknown size");
            InputStream is = payloadStream.openStream();
            File targetFile = File.createTempFile(MINIO_TMP_FILE_PREFIX, "");
            Files.copy(is, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            IOUtils.closeQuietly((InputStream)is);
            LOGGER.debug(bucketPath + " with tmpfile " + targetFile.getAbsolutePath() + " written with " + targetFile.length() + " bytes -> will now be copied to minio");
            FileInputStream fis = new FileInputStream(targetFile);
            this.minioClient.putObject(rootBucket.append(bucketPath).getObjectHandle().getContainer(), rootBucket.append(bucketPath).getObjectHandle().getName(), (InputStream)fis, targetFile.length(), "");
            IOUtils.closeQuietly((InputStream)fis);
            LOGGER.debug("stored " + bucketPath + " to minio with size " + targetFile.length());
            targetFile.delete();
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    private void storeMetadata(BucketPath bucketPath, StorageMetadata storageMetadata) {
        try {
            LOGGER.debug("store metadata for " + bucketPath);
            SimpleStorageMetadataImpl metaData = new SimpleStorageMetadataImpl(storageMetadata);
            metaData.setType(StorageType.BLOB);
            metaData.setName(BucketPathUtil.getAsString((BucketPath)bucketPath));
            String jsonString = this.storageMetadataFlattenerGSON.toJson((StorageMetadata)metaData);
            byte[] bytes = jsonString.getBytes(CHARSET_NAME);
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            this.minioClient.putObject(rootBucket.append(bucketPath).getObjectHandle().getContainer(), rootBucket.append(bucketPath).add(METADATA_EXT).getObjectHandle().getName(), (InputStream)is, (long)bytes.length, "");
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }
}

