/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.cryptoutils.miniostoreconnection;

import java.net.URL;
import java.util.StringTokenizer;
import org.adorsys.cryptoutils.exceptions.BaseExceptionHandler;
import org.adorsys.cryptoutils.miniostoreconnection.MinioAccessKey;
import org.adorsys.cryptoutils.miniostoreconnection.MinioSecretKey;

public class MinioParamParser {
    private URL url;
    private MinioAccessKey minioAccessKey;
    private MinioSecretKey minioSecretKey;

    public MinioParamParser(String params) {
        try {
            StringTokenizer st = new StringTokenizer(params, ",");
            String urlString = st.nextToken();
            String accessKey = st.nextToken();
            String secretKey = st.nextToken();
            this.url = new URL(urlString);
            this.minioAccessKey = new MinioAccessKey(accessKey);
            this.minioSecretKey = new MinioSecretKey(secretKey);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public URL getUrl() {
        return this.url;
    }

    public MinioAccessKey getMinioAccessKey() {
        return this.minioAccessKey;
    }

    public MinioSecretKey getMinioSecretKey() {
        return this.minioSecretKey;
    }
}

