/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.cryptoutils.miniostoreconnection;

import io.minio.MinioClient;
import io.minio.messages.DeleteError;
import io.minio.messages.Item;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.adorsys.cryptoutils.exceptions.BaseException;
import org.adorsys.cryptoutils.exceptions.BaseExceptionHandler;
import org.adorsys.cryptoutils.exceptions.NYIException;
import org.adorsys.cryptoutils.miniostoreconnection.MinioAccessKey;
import org.adorsys.cryptoutils.miniostoreconnection.MinioSecretKey;
import org.adorsys.encobject.complextypes.BucketDirectory;
import org.adorsys.encobject.complextypes.BucketPath;
import org.adorsys.encobject.complextypes.BucketPathUtil;
import org.adorsys.encobject.domain.Payload;
import org.adorsys.encobject.domain.PayloadStream;
import org.adorsys.encobject.domain.StorageMetadata;
import org.adorsys.encobject.domain.StorageType;
import org.adorsys.encobject.exceptions.BucketException;
import org.adorsys.encobject.exceptions.StorageConnectionException;
import org.adorsys.encobject.filesystem.StorageMetadataFlattenerGSON;
import org.adorsys.encobject.service.api.ExtendedStoreConnection;
import org.adorsys.encobject.service.impl.SimplePayloadImpl;
import org.adorsys.encobject.service.impl.SimplePayloadStreamImpl;
import org.adorsys.encobject.service.impl.SimpleStorageMetadataImpl;
import org.adorsys.encobject.service.impl.StoreConnectionListHelper;
import org.adorsys.encobject.types.ListRecursiveFlag;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinioExtendedStoreConnection
implements ExtendedStoreConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MinioExtendedStoreConnection.class);
    private static final String CONTENT_TYPE = "";
    private static final String METADATA_EXT = ".metadata.extension.";
    private final MinioClient minioClient;
    private final StorageMetadataFlattenerGSON storageMetadataFlattenerGSON = new StorageMetadataFlattenerGSON();

    public MinioExtendedStoreConnection(URL url, MinioAccessKey minioAccessKey, MinioSecretKey minioSecretKey) {
        try {
            this.minioClient = new MinioClient(url, minioAccessKey.getValue(), minioSecretKey.getValue());
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public void putBlob(BucketPath bucketPath, Payload payload) {
        this.putBlobStream(bucketPath, (PayloadStream)new SimplePayloadStreamImpl(payload.getStorageMetadata(), (InputStream)new ByteArrayInputStream(payload.getData())));
    }

    public Payload getBlob(BucketPath bucketPath) {
        try {
            PayloadStream payloadStream = this.getBlobStream(bucketPath);
            return new SimplePayloadImpl(payloadStream.getStorageMetadata(), IOUtils.toByteArray((InputStream)payloadStream.openStream()));
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public void putBlobStream(BucketPath bucketPath, PayloadStream payloadStream) {
        try {
            this.storeMetadata(bucketPath, payloadStream.getStorageMetadata());
            byte[] bytes = IOUtils.toByteArray((InputStream)payloadStream.openStream());
            this.minioClient.putObject(bucketPath.getObjectHandle().getContainer(), bucketPath.getObjectHandle().getName(), (InputStream)new ByteArrayInputStream(bytes), (long)bytes.length, CONTENT_TYPE);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public PayloadStream getBlobStream(BucketPath bucketPath) {
        try {
            StorageMetadata storageMetadata = this.getStorageMetadata(bucketPath);
            InputStream stream = this.minioClient.getObject(bucketPath.getObjectHandle().getContainer(), bucketPath.getObjectHandle().getName());
            SimplePayloadStreamImpl payloadStream = new SimplePayloadStreamImpl(storageMetadata, stream);
            return payloadStream;
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public void putBlob(BucketPath bucketPath, byte[] bytes) {
        this.putBlob(bucketPath, (Payload)new SimplePayloadImpl((StorageMetadata)new SimpleStorageMetadataImpl(), bytes));
    }

    public StorageMetadata getStorageMetadata(BucketPath bucketPath) {
        try {
            LOGGER.debug("load metadata for " + bucketPath);
            InputStream is = this.minioClient.getObject(bucketPath.getObjectHandle().getContainer(), bucketPath.add(METADATA_EXT).getObjectHandle().getName());
            byte[] bytes = IOUtils.toByteArray((InputStream)is);
            String jsonString = new String(bytes);
            StorageMetadata storageMetadata = this.storageMetadataFlattenerGSON.fromJson(jsonString);
            return storageMetadata;
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public boolean blobExists(BucketPath bucketPath) {
        LOGGER.debug("blobExists:" + bucketPath);
        String container = bucketPath.getObjectHandle().getContainer();
        String prefix = bucketPath.getObjectHandle().getName();
        ArrayList<String> list = new ArrayList<String>();
        this.minioClient.listObjects(container, prefix, false).forEach(item -> {
            try {
                list.add(((Item)item.get()).objectName());
            }
            catch (Exception e) {
                throw BaseExceptionHandler.handle((Throwable)e);
            }
        });
        list.forEach(el -> LOGGER.debug("FOUND :" + el));
        boolean value = !list.isEmpty();
        LOGGER.info("blobExists:" + bucketPath + " -> " + value);
        return value;
    }

    public void removeBlob(BucketPath bucketPath) {
        try {
            LOGGER.debug("removeBlob " + bucketPath);
            this.minioClient.removeObject(bucketPath.getObjectHandle().getContainer(), bucketPath.getObjectHandle().getName());
            this.minioClient.removeObject(bucketPath.getObjectHandle().getContainer(), bucketPath.add(METADATA_EXT).getObjectHandle().getName());
            LOGGER.info("removeBlob done " + bucketPath);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public void removeBlobFolder(BucketDirectory bucketDirectory) {
        if (bucketDirectory.getObjectHandle().getName() == null) {
            throw new StorageConnectionException("not a valid bucket directory " + bucketDirectory);
        }
        List<StorageMetadata> list = this.list(bucketDirectory, ListRecursiveFlag.TRUE);
        list.forEach(metadata -> {
            if (((StorageType)metadata.getType()).equals((Object)StorageType.BLOB)) {
                this.removeBlob(new BucketPath(metadata.getName()));
            }
        });
    }

    public void removeBlobs(Iterable<BucketPath> iterable) {
        iterable.forEach(bucketPath -> this.removeBlob((BucketPath)bucketPath));
    }

    public long countBlobs(BucketDirectory bucketDirectory, ListRecursiveFlag listRecursiveFlag) {
        throw new NYIException();
    }

    public void createContainer(BucketDirectory bucketDirectory) {
        try {
            LOGGER.info("create container " + bucketDirectory);
            String container = bucketDirectory.getObjectHandle().getContainer();
            if (!this.minioClient.bucketExists(container)) {
                this.minioClient.makeBucket(container);
            }
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public boolean containerExists(BucketDirectory bucketDirectory) {
        try {
            return this.minioClient.bucketExists(bucketDirectory.getObjectHandle().getContainer());
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public void deleteContainer(BucketDirectory bucketDirectory) {
        LOGGER.info("deleteContainer " + bucketDirectory);
        try {
            ArrayList objectNames = new ArrayList();
            this.minioClient.listObjects(bucketDirectory.getObjectHandle().getContainer()).forEach(el -> {
                try {
                    objectNames.add(((Item)el.get()).objectName());
                }
                catch (Exception e) {
                    throw BaseExceptionHandler.handle((Throwable)e);
                }
            });
            LOGGER.info("delete " + objectNames.size() + " Elements of Container " + bucketDirectory);
            this.minioClient.removeObject(bucketDirectory.getObjectHandle().getContainer(), objectNames).forEach(error -> {
                try {
                    DeleteError de = (DeleteError)error.get();
                    throw new BucketException("can not delete File " + de.objectName() + " of bucket " + bucketDirectory.getObjectHandle().getContainer() + " :" + de.message());
                }
                catch (Exception e) {
                    throw BaseExceptionHandler.handle((Throwable)e);
                }
            });
            LOGGER.info("eventually delete empty Container " + bucketDirectory);
            this.minioClient.removeBucket(bucketDirectory.getObjectHandle().getContainer());
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public List<StorageMetadata> list(BucketDirectory bucketDirectory, ListRecursiveFlag listRecursiveFlag) {
        ArrayList<StorageMetadata> returnList = new ArrayList<StorageMetadata>();
        if (!this.containerExists(bucketDirectory)) {
            return returnList;
        }
        String container = bucketDirectory.getObjectHandle().getContainer();
        String prefix = bucketDirectory.getObjectHandle().getName();
        if (prefix == null) {
            prefix = CONTENT_TYPE;
        }
        ArrayList<BucketPath> bucketPaths = new ArrayList<BucketPath>();
        LOGGER.debug("search in " + bucketDirectory + " with prefix " + prefix + " " + listRecursiveFlag);
        this.minioClient.listObjects(container, prefix, true).forEach(el -> {
            try {
                BucketPath bucketPath = new BucketPath(container, ((Item)el.get()).objectName());
                if (!bucketPath.getObjectHandle().getName().endsWith(METADATA_EXT)) {
                    LOGGER.debug("found: " + bucketPath);
                    bucketPaths.add(bucketPath);
                }
            }
            catch (Exception e) {
                throw BaseExceptionHandler.handle((Throwable)e);
            }
        });
        if (bucketPaths.contains(new BucketPath(bucketDirectory.getObjectHandle().getContainer(), bucketDirectory.getObjectHandle().getName()))) {
            return returnList;
        }
        String pref = prefix;
        LOGGER.debug("filter prefix ist " + pref);
        Set bucketDirectories = StoreConnectionListHelper.findAllSubDirs(bucketPaths);
        bucketDirectories.add(bucketDirectory);
        if (listRecursiveFlag.equals((Object)ListRecursiveFlag.FALSE)) {
            bucketDirectories.removeIf(bucketSubdir -> {
                String name = bucketSubdir.getObjectHandle().getName();
                if (name == null) {
                    LOGGER.debug("filter bucketDirectory " + bucketSubdir + " -> false");
                    return false;
                }
                if (!name.startsWith(pref)) {
                    throw new BaseException("expected " + name + " to start with " + pref);
                }
                String remainder = name.substring(pref.length());
                int firstSlash = remainder.indexOf("/");
                boolean filterMeOut = false;
                if (pref.length() == 0) {
                    boolean bl = filterMeOut = firstSlash != -1;
                }
                if (!filterMeOut && firstSlash != -1) {
                    int secondSlash = remainder.indexOf("/", firstSlash + 1);
                    filterMeOut = secondSlash != -1;
                }
                LOGGER.debug("filter bucketDirectory " + bucketSubdir + " " + remainder + " -> " + filterMeOut);
                return filterMeOut;
            });
        }
        bucketDirectories.forEach(bucketSubdir -> {
            SimpleStorageMetadataImpl metadata = new SimpleStorageMetadataImpl();
            metadata.setType(StorageType.FOLDER);
            metadata.setName(BucketPathUtil.getAsString((BucketDirectory)bucketSubdir));
            returnList.add((StorageMetadata)metadata);
        });
        if (listRecursiveFlag.equals((Object)ListRecursiveFlag.FALSE)) {
            bucketPaths.removeIf(bucketPath -> {
                String name = bucketPath.getObjectHandle().getName();
                if (!name.startsWith(pref)) {
                    throw new BaseException("expected " + name + " to start with " + pref);
                }
                String remainder = name.substring(pref.length() + 1);
                int index = remainder.indexOf("/");
                boolean filterMeOut = index != -1;
                LOGGER.debug("filter bucketPath " + bucketPath + " " + remainder + " -> " + filterMeOut);
                return filterMeOut;
            });
        }
        bucketPaths.forEach(bucketPath -> returnList.add(this.getStorageMetadata((BucketPath)bucketPath)));
        LOGGER.debug("List returns");
        returnList.forEach(metaData -> LOGGER.debug(metaData.getName() + " " + metaData.getType()));
        return returnList;
    }

    public void deleteAllBuckets() {
        try {
            LOGGER.info("******************************************************");
            LOGGER.info("DELETE ALL BUCKETS OF DATABASE - FOR TEST PURPOSE ONLY");
            this.minioClient.listBuckets().forEach(bucket -> this.deleteContainer(new BucketDirectory(bucket.name())));
            LOGGER.info("******************************************************");
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    private void storeMetadata(BucketPath bucketPath, StorageMetadata storageMetadata) {
        try {
            LOGGER.debug("store metadata for " + bucketPath);
            SimpleStorageMetadataImpl metaData = new SimpleStorageMetadataImpl(storageMetadata);
            metaData.setType(StorageType.BLOB);
            metaData.setName(BucketPathUtil.getAsString((BucketPath)bucketPath));
            String jsonString = this.storageMetadataFlattenerGSON.toJson((StorageMetadata)metaData);
            byte[] bytes = jsonString.getBytes();
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            this.minioClient.putObject(bucketPath.getObjectHandle().getContainer(), bucketPath.add(METADATA_EXT).getObjectHandle().getName(), (InputStream)is, (long)bytes.length, CONTENT_TYPE);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }
}

