/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.encobject.filesystem;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.adorsys.cryptoutils.exceptions.BaseException;
import org.adorsys.cryptoutils.exceptions.BaseExceptionHandler;
import org.adorsys.cryptoutils.utils.Frame;
import org.adorsys.encobject.complextypes.BucketDirectory;
import org.adorsys.encobject.complextypes.BucketPath;
import org.adorsys.encobject.complextypes.BucketPathUtil;
import org.adorsys.encobject.domain.Payload;
import org.adorsys.encobject.domain.PayloadStream;
import org.adorsys.encobject.domain.StorageMetadata;
import org.adorsys.encobject.domain.StorageType;
import org.adorsys.encobject.exceptions.StorageConnectionException;
import org.adorsys.encobject.filesystem.BucketPathFileHelper;
import org.adorsys.encobject.filesystem.DirectoryContent;
import org.adorsys.encobject.filesystem.ZipFileHelper;
import org.adorsys.encobject.filesystem.exceptions.CreateFolderException;
import org.adorsys.encobject.filesystem.exceptions.DeleteFileException;
import org.adorsys.encobject.filesystem.exceptions.FileIsFolderException;
import org.adorsys.encobject.filesystem.exceptions.FolderDeleteException;
import org.adorsys.encobject.filesystem.exceptions.FolderIsAFileException;
import org.adorsys.encobject.service.api.ExtendedStoreConnection;
import org.adorsys.encobject.service.impl.SimplePayloadImpl;
import org.adorsys.encobject.service.impl.SimplePayloadStreamImpl;
import org.adorsys.encobject.service.impl.SimpleStorageMetadataImpl;
import org.adorsys.encobject.types.ExtendedStoreConnectionType;
import org.adorsys.encobject.types.ListRecursiveFlag;
import org.adorsys.encobject.types.connection.FilesystemBasedirectoryName;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RealFileSystemExtendedStorageConnection
implements ExtendedStoreConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(RealFileSystemExtendedStorageConnection.class);
    protected final BucketDirectory baseDir;
    private ZipFileHelper zipFileHelper;
    private boolean absolutePath = false;

    public RealFileSystemExtendedStorageConnection(FilesystemBasedirectoryName basedir) {
        try {
            this.baseDir = new BucketDirectory(basedir.getValue());
            this.absolutePath = basedir.getValue().startsWith("/");
            Frame frame = new Frame();
            frame.add("USE FILE SYSTEM");
            if (!this.absolutePath) {
                String currentDir = new File(".").getCanonicalPath();
                String absoluteDirectory = basedir.getValue();
                absoluteDirectory = currentDir + "/" + absoluteDirectory;
                frame.add("basedir     : " + basedir);
                frame.add("absolutedir : " + absoluteDirectory);
            } else {
                frame.add("absolutedir : " + basedir);
            }
            LOGGER.info(frame.toString());
            this.zipFileHelper = new ZipFileHelper(this.baseDir, this.absolutePath);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public void createContainer(BucketDirectory bucketDirectory) {
        String containerOnly = bucketDirectory.getObjectHandle().getContainer();
        File file = BucketPathFileHelper.getAsFile(this.baseDir.appendDirectory(containerOnly), this.absolutePath);
        if (file.isDirectory()) {
            LOGGER.debug("directory already exists:" + file);
            return;
        }
        boolean success = file.mkdirs();
        if (!success) {
            throw new CreateFolderException("Can not create directory " + file);
        }
        LOGGER.debug("created folder " + file);
    }

    public boolean containerExists(BucketDirectory bucketDirectory) {
        File file = BucketPathFileHelper.getAsFile(this.baseDir.appendDirectory(bucketDirectory.getObjectHandle().getContainer()), this.absolutePath);
        if (file.isDirectory()) {
            LOGGER.debug("directory exists:" + file);
            return true;
        }
        if (file.isFile()) {
            throw new FolderIsAFileException("folder is a file " + file);
        }
        LOGGER.debug("directory does not exists" + file);
        return false;
    }

    public void deleteContainer(BucketDirectory container) {
        File file = BucketPathFileHelper.getAsFile(this.baseDir.appendDirectory(container.getObjectHandle().getContainer()), this.absolutePath);
        if (!this.containerExists(container)) {
            LOGGER.debug("directory does not exist. so nothing to delete:" + file);
            return;
        }
        try {
            FileUtils.deleteDirectory((File)file);
        }
        catch (IOException e) {
            throw new FolderDeleteException("can not delete " + file, e);
        }
    }

    public void putBlob(BucketPath bucketPath, byte[] bytes) {
        SimplePayloadImpl payload = new SimplePayloadImpl(bytes);
        this.putBlob(bucketPath, (Payload)payload);
    }

    public boolean blobExists(BucketPath bucketPath) {
        File file = BucketPathFileHelper.getAsFile(this.baseDir.append(bucketPath.add(".zip")), this.absolutePath);
        if (file.isDirectory()) {
            throw new FileIsFolderException("file " + file);
        }
        if (file.isFile()) {
            LOGGER.debug("file does exist " + file);
            return true;
        }
        LOGGER.debug("file does not exist " + file);
        return false;
    }

    public List<StorageMetadata> list(BucketDirectory bucketDirectory, ListRecursiveFlag listRecursiveFlag) {
        ArrayList<StorageMetadata> result = new ArrayList<StorageMetadata>();
        File file = BucketPathFileHelper.getAsFile(this.baseDir.append(bucketDirectory), this.absolutePath);
        if (!file.exists()) {
            return result;
        }
        if (!file.isDirectory()) {
            return result;
        }
        DirectoryContent content = this.listContent(bucketDirectory, listRecursiveFlag);
        this.addStorageMetaData(result, content);
        return result;
    }

    public List<BucketDirectory> listAllBuckets() {
        try {
            ArrayList<BucketDirectory> list = new ArrayList<BucketDirectory>();
            String[] dirs = BucketPathFileHelper.getAsFile(this.baseDir, this.absolutePath).list(new DirectoryFilenameFilter());
            if (dirs == null) {
                return list;
            }
            Arrays.stream(dirs).forEach(dir -> list.add(new BucketDirectory(dir)));
            return list;
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    public ExtendedStoreConnectionType getType() {
        return ExtendedStoreConnectionType.FILESYSTEM;
    }

    public void putBlob(BucketPath bucketPath, Payload payload) {
        this.checkContainerExists(bucketPath);
        this.zipFileHelper.writeZip(bucketPath, new SimplePayloadImpl(payload));
    }

    public Payload getBlob(BucketPath bucketPath) {
        this.checkContainerExists(bucketPath);
        return this.zipFileHelper.readZip(bucketPath, null);
    }

    public Payload getBlob(BucketPath bucketPath, StorageMetadata storageMetadata) {
        this.checkContainerExists(bucketPath);
        return this.zipFileHelper.readZip(bucketPath, storageMetadata);
    }

    public void putBlobStream(BucketPath bucketPath, PayloadStream payloadStream) {
        this.checkContainerExists(bucketPath);
        this.zipFileHelper.writeZipStream(bucketPath, new SimplePayloadStreamImpl(payloadStream));
    }

    public PayloadStream getBlobStream(BucketPath bucketPath) {
        this.checkContainerExists(bucketPath);
        return this.zipFileHelper.readZipStream(bucketPath, null);
    }

    public PayloadStream getBlobStream(BucketPath bucketPath, StorageMetadata storageMetadata) {
        this.checkContainerExists(bucketPath);
        return this.zipFileHelper.readZipStream(bucketPath, storageMetadata);
    }

    public StorageMetadata getStorageMetadata(BucketPath bucketPath) {
        this.checkContainerExists(bucketPath);
        return this.zipFileHelper.readZipMetadataOnly(bucketPath);
    }

    public void removeBlob(BucketPath bucketPath) {
        this.checkContainerExists(bucketPath);
        File file = BucketPathFileHelper.getAsFile(this.baseDir.append(bucketPath).add(".zip"), this.absolutePath);
        if (!file.exists()) {
            return;
        }
        try {
            FileUtils.forceDelete((File)file);
        }
        catch (IOException e) {
            throw new DeleteFileException("can not delete " + file, e);
        }
    }

    public void removeBlobFolder(BucketDirectory bucketDirectory) {
        this.checkContainerExists(bucketDirectory);
        if (bucketDirectory.getObjectHandle().getName() == null) {
            throw new StorageConnectionException("not a valid bucket directory " + bucketDirectory);
        }
        File directory = BucketPathFileHelper.getAsFile(this.baseDir.append(bucketDirectory), this.absolutePath);
        LOGGER.debug("remove directory " + directory.getAbsolutePath());
        if (!directory.exists()) {
            return;
        }
        try {
            FileUtils.forceDelete((File)directory);
        }
        catch (IOException e) {
            throw new DeleteFileException("can not delete " + directory, e);
        }
    }

    private void checkContainerExists(BucketPath bucketPath) {
        if (!this.containerExists(bucketPath.getBucketDirectory())) {
            throw new BaseException("Container " + bucketPath.getObjectHandle().getContainer() + " does not exist");
        }
    }

    private void checkContainerExists(BucketDirectory bucketDirectory) {
        if (!this.containerExists(bucketDirectory)) {
            throw new BaseException("Container " + bucketDirectory.getObjectHandle().getContainer() + " does not exist");
        }
    }

    private int countBlobs(DirectoryContent content, int currentCounter) {
        currentCounter += content.getFiles().size();
        for (DirectoryContent subdir : content.getSubidrs()) {
            currentCounter += this.countBlobs(subdir, 0);
        }
        return currentCounter;
    }

    private void files2content(DirectoryContent content, BucketDirectory bucketDirectory, Collection<File> files) {
        String knownPrefix = BucketPathFileHelper.getAsFile(this.baseDir.append(bucketDirectory), this.absolutePath).getAbsolutePath();
        for (File f : files) {
            String name = f.getName();
            if (!name.endsWith(".zip")) {
                LOGGER.debug("ignore file " + bucketDirectory.appendName(name));
                continue;
            }
            String origName = name.substring(0, name.length() - ".zip".length());
            content.getFiles().add(bucketDirectory.appendName(origName));
        }
    }

    private void dirs2content(DirectoryContent content, BucketDirectory bucketDirectory, String[] dirs) {
        String knownPrefix = BucketPathFileHelper.getAsFile(this.baseDir.append(bucketDirectory), this.absolutePath).getAbsolutePath();
        for (String dir : dirs) {
            content.getSubidrs().add(new DirectoryContent(bucketDirectory.appendDirectory(dir)));
        }
    }

    private void addFilesOnly(List<BucketPath> result, DirectoryContent content) {
        result.addAll(content.getFiles());
        for (DirectoryContent subContent : content.getSubidrs()) {
            this.addFilesOnly(result, subContent);
        }
    }

    private void listRecursive(DirectoryContent content) {
        DirectoryContent current = this.listContent(content.getDirectory(), ListRecursiveFlag.FALSE);
        ArrayList<DirectoryContent> newSubdirs = new ArrayList<DirectoryContent>();
        for (DirectoryContent subdir : content.getSubidrs()) {
            DirectoryContent newSubdir = this.listContent(subdir.getDirectory(), ListRecursiveFlag.FALSE);
            this.listRecursive(newSubdir);
            newSubdirs.add(newSubdir);
        }
        content.getSubidrs().clear();
        content.getSubidrs().addAll(newSubdirs);
    }

    private DirectoryContent listContent(BucketDirectory bucketDirectory, ListRecursiveFlag listRecursiveFlag) {
        File file = BucketPathFileHelper.getAsFile(this.baseDir.append(bucketDirectory), this.absolutePath);
        try {
            DirectoryContent content = new DirectoryContent(bucketDirectory);
            if (file.isFile()) {
                return content;
            }
            if (!file.isDirectory()) {
                return content;
            }
            if (listRecursiveFlag.equals((Object)ListRecursiveFlag.FALSE)) {
                Collection files = FileUtils.listFiles((File)file, null, (boolean)listRecursiveFlag.equals((Object)ListRecursiveFlag.TRUE));
                this.files2content(content, bucketDirectory, files);
                String[] list = file.list(new DirectoryFilenameFilter());
                this.dirs2content(content, bucketDirectory, list);
                return content;
            }
            content = this.listContent(bucketDirectory, ListRecursiveFlag.FALSE);
            this.listRecursive(content);
            return content;
        }
        catch (Exception e) {
            throw new StorageConnectionException("" + file, (Throwable)e);
        }
    }

    private List<BucketPath> listFlat(BucketDirectory bucketDirectory, ListRecursiveFlag listRecursiveFlag) {
        ArrayList<BucketPath> result = new ArrayList<BucketPath>();
        DirectoryContent content = this.listContent(bucketDirectory, listRecursiveFlag);
        this.addFilesOnly(result, content);
        return result;
    }

    private void addStorageMetaData(List<StorageMetadata> result, DirectoryContent content) {
        result.add(this.createStorageMetadataForDirectory(content));
        for (BucketPath file : content.getFiles()) {
            result.add(this.getStorageMetadata(file));
        }
        for (DirectoryContent dir : content.getSubidrs()) {
            this.addStorageMetaData(result, dir);
        }
    }

    private StorageMetadata createStorageMetadataForDirectory(DirectoryContent content) {
        SimpleStorageMetadataImpl storageMetadata = new SimpleStorageMetadataImpl();
        storageMetadata.setType(StorageType.FOLDER);
        storageMetadata.setSize(new Long(content.getFiles().size() + content.getSubidrs().size()));
        storageMetadata.setName(BucketPathUtil.getAsString((BucketDirectory)content.getDirectory()));
        return storageMetadata;
    }

    private static final class DirectoryFilenameFilter
    implements FilenameFilter {
        private DirectoryFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            try {
                return new File(dir.getCanonicalPath() + "/" + name).isDirectory();
            }
            catch (IOException e) {
                throw BaseExceptionHandler.handle((Throwable)e);
            }
        }
    }
}

