/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.encobject.filesystem;

import java.util.ArrayList;
import java.util.List;
import org.adorsys.encobject.complextypes.BucketDirectory;
import org.adorsys.encobject.complextypes.BucketPath;

class DirectoryContent {
    private BucketDirectory directory;
    private List<BucketPath> files = new ArrayList<BucketPath>();
    private List<DirectoryContent> subidrs = new ArrayList<DirectoryContent>();

    public DirectoryContent(BucketDirectory directory) {
        this.directory = directory;
    }

    public BucketDirectory getDirectory() {
        return this.directory;
    }

    public List<BucketPath> getFiles() {
        return this.files;
    }

    public List<DirectoryContent> getSubidrs() {
        return this.subidrs;
    }

    public String toString() {
        return "DirectoryContent{directory=" + this.directory.toString() + ", files=" + DirectoryContent.showFile(this.files) + ", subidrs=" + DirectoryContent.showDir(this.subidrs) + '}';
    }

    private static String showFile(List<BucketPath> files) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (BucketPath bp : files) {
            sb.append(bp.toString());
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }

    private static String showDir(List<DirectoryContent> dirs) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (DirectoryContent d : dirs) {
            sb.append(d.toString());
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }
}

