/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.encobject.service;

import com.nimbusds.jose.CompressionAlgorithm;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.factories.DefaultJWEDecrypterFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import org.adorsys.encobject.domain.ContentMetaInfo;
import org.adorsys.encobject.domain.ObjectHandle;
import org.adorsys.encobject.params.EncParamSelector;
import org.adorsys.encobject.params.EncryptionParams;
import org.adorsys.encobject.service.ObjectNotFoundException;
import org.adorsys.encobject.service.StoreConnection;
import org.adorsys.encobject.service.UnknownContainerException;
import org.adorsys.encobject.service.WrongKeyCredentialException;
import org.adorsys.jjwk.selector.JWEEncryptedSelector;
import org.adorsys.jjwk.selector.UnsupportedEncAlgorithmException;
import org.adorsys.jjwk.selector.UnsupportedKeyLengthException;
import org.adorsys.jkeygen.keystore.PasswordCallbackUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class ObjectPersistence {
    private DefaultJWEDecrypterFactory decrypterFactory = new DefaultJWEDecrypterFactory();
    private final StoreConnection blobStoreConnection;

    public ObjectPersistence(StoreConnection blobStoreConnection) {
        this.blobStoreConnection = blobStoreConnection;
    }

    public void storeObject(byte[] data, ContentMetaInfo metaIno, ObjectHandle handle, KeyStore keyStore, String keyID, CallbackHandler keyPassHandler, EncryptionParams encParams) throws UnsupportedEncAlgorithmException, WrongKeyCredentialException, UnsupportedKeyLengthException, UnknownContainerException {
        byte[] bytesToStore;
        String zip;
        if (metaIno == null) {
            metaIno = new ContentMetaInfo();
        }
        Key key = this.readKey(keyStore, keyID, keyPassHandler);
        if (encParams == null) {
            encParams = EncParamSelector.selectEncryptionParams(key);
        }
        JWEHeader.Builder headerBuilder = new JWEHeader.Builder(encParams.getEncAlgo(), encParams.getEncMethod()).keyID(keyID);
        String contentTrype = metaIno.getContentTrype();
        if (StringUtils.isNotBlank((CharSequence)contentTrype)) {
            headerBuilder = headerBuilder.contentType(contentTrype);
        }
        if (StringUtils.isNotBlank((CharSequence)(zip = metaIno.getZip()))) {
            headerBuilder = headerBuilder.compressionAlgorithm(CompressionAlgorithm.DEF);
        } else if (StringUtils.isNotBlank((CharSequence)contentTrype) && StringUtils.containsIgnoreCase((CharSequence)contentTrype, (CharSequence)"text")) {
            headerBuilder = headerBuilder.compressionAlgorithm(CompressionAlgorithm.DEF);
        }
        Map<String, Object> addInfos = metaIno.getAddInfos();
        if (metaIno.getExp() != null) {
            if (addInfos == null) {
                addInfos = new HashMap<String, Object>();
            }
            addInfos.put("exp", metaIno.getExp().getTime());
        }
        if (addInfos != null) {
            headerBuilder = headerBuilder.customParams(addInfos);
        }
        JWEHeader header = headerBuilder.build();
        JWEEncrypter jweEncrypter = JWEEncryptedSelector.geEncrypter((Key)key, (JWEAlgorithm)encParams.getEncAlgo(), (EncryptionMethod)encParams.getEncMethod());
        JWEObject jweObject = new JWEObject(header, new Payload(data));
        try {
            jweObject.encrypt(jweEncrypter);
        }
        catch (JOSEException e) {
            throw new IllegalStateException("Encryption error", e);
        }
        String jweEncryptedObject = jweObject.serialize();
        try {
            bytesToStore = jweEncryptedObject.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("Unsupported content type", e);
        }
        this.blobStoreConnection.putBlob(handle, bytesToStore);
    }

    public byte[] loadObject(ObjectHandle handle, KeyStore keyStore, CallbackHandler keyPassHandler) throws ObjectNotFoundException, WrongKeyCredentialException, UnknownContainerException {
        JWEDecrypter decrypter;
        JWEObject jweObject;
        String jweEncryptedObject;
        byte[] jweEncryptedBytes = this.blobStoreConnection.getBlob(handle);
        try {
            jweEncryptedObject = IOUtils.toString((byte[])jweEncryptedBytes, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new IllegalStateException("Unsupported content type", e);
        }
        try {
            jweObject = JWEObject.parse((String)jweEncryptedObject);
        }
        catch (ParseException e) {
            throw new IllegalStateException("Can not parse jwe object", e);
        }
        String keyID = jweObject.getHeader().getKeyID();
        Key key = this.readKey(keyStore, keyID, keyPassHandler);
        try {
            decrypter = this.decrypterFactory.createJWEDecrypter(jweObject.getHeader(), key);
        }
        catch (JOSEException e) {
            throw new IllegalStateException("No suitable key found", e);
        }
        try {
            jweObject.decrypt(decrypter);
        }
        catch (JOSEException e) {
            throw new WrongKeyCredentialException(e);
        }
        return jweObject.getPayload().toBytes();
    }

    private Key readKey(KeyStore keyStore, String keyID, CallbackHandler keyPassHandler) throws WrongKeyCredentialException {
        try {
            return keyStore.getKey(keyID, PasswordCallbackUtils.getPassword((CallbackHandler)keyPassHandler, (String)keyID));
        }
        catch (UnrecoverableKeyException e) {
            throw new WrongKeyCredentialException(e);
        }
        catch (KeyStoreException e) {
            throw new WrongKeyCredentialException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

