/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.encobject.userdata;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.adorsys.encobject.domain.KeyCredentials;
import org.adorsys.encobject.domain.ObjectHandle;
import org.adorsys.encobject.params.KeyParams;
import org.adorsys.encobject.service.ContainerExistsException;
import org.adorsys.encobject.service.EncObjectService;
import org.adorsys.encobject.service.MissingKeyAlgorithmException;
import org.adorsys.encobject.service.MissingKeystoreAlgorithmException;
import org.adorsys.encobject.service.MissingKeystoreProviderException;
import org.adorsys.encobject.service.ObjectNotFoundException;
import org.adorsys.encobject.service.UnknownContainerException;
import org.adorsys.encobject.service.WrongKeyCredentialException;
import org.adorsys.encobject.service.WrongKeystoreCredentialException;
import org.adorsys.encobject.userdata.ObjectMapperSPI;
import org.adorsys.jjwk.selector.UnsupportedEncAlgorithmException;
import org.adorsys.jjwk.selector.UnsupportedKeyLengthException;

public class ObjectPersistenceAdapter {
    private ObjectMapperSPI objectMapper;
    private KeyCredentials keyCredentials;
    private EncObjectService encObjectService;

    public ObjectPersistenceAdapter(EncObjectService encObjectService, KeyCredentials keyCredentials, ObjectMapperSPI objectMapper) {
        this.encObjectService = encObjectService;
        this.keyCredentials = keyCredentials;
        this.objectMapper = objectMapper;
    }

    public boolean hasStore() {
        return this.encObjectService.hasKeystore(this.keyCredentials);
    }

    public void initStore() {
        try {
            String container = this.keyCredentials.getHandle().getContainer();
            if (!this.encObjectService.containerExists(container)) {
                try {
                    this.encObjectService.newContainer(container);
                }
                catch (ContainerExistsException e) {
                    throw new IllegalStateException(e);
                }
            }
            this.encObjectService.newSecretKey(this.keyCredentials, ObjectPersistenceAdapter.keyParams());
        }
        catch (IOException | NoSuchAlgorithmException | CertificateException | MissingKeyAlgorithmException | MissingKeystoreAlgorithmException | MissingKeystoreProviderException | UnknownContainerException | WrongKeystoreCredentialException e) {
            throw new IllegalStateException(e);
        }
    }

    public <T> T load(ObjectHandle handle, Class<T> klass) {
        byte[] src = null;
        try {
            src = this.encObjectService.readObject(this.keyCredentials, handle);
        }
        catch (ObjectNotFoundException e) {
            return null;
        }
        catch (IOException | CertificateException | MissingKeyAlgorithmException | MissingKeystoreAlgorithmException | MissingKeystoreProviderException | UnknownContainerException | WrongKeyCredentialException | WrongKeystoreCredentialException e) {
            throw new IllegalStateException(e);
        }
        try {
            return this.objectMapper.readValue(src, klass);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public <T> void store(ObjectHandle userMainRecordhandle, T t) {
        this.storeInternal(userMainRecordhandle, t);
    }

    private <T> void storeInternal(ObjectHandle handle, T t) {
        String container = this.keyCredentials.getHandle().getContainer();
        if (!this.encObjectService.containerExists(container)) {
            try {
                this.encObjectService.newContainer(container);
            }
            catch (ContainerExistsException e) {
                throw new IllegalStateException("Can not create container with name: " + container, e);
            }
        }
        try {
            byte[] data = this.objectMapper.writeValueAsBytes(t);
            this.encObjectService.writeObject(data, null, handle, this.keyCredentials);
        }
        catch (IOException | CertificateException | MissingKeyAlgorithmException | MissingKeystoreAlgorithmException | MissingKeystoreProviderException | ObjectNotFoundException | UnknownContainerException | WrongKeyCredentialException | WrongKeystoreCredentialException | UnsupportedEncAlgorithmException | UnsupportedKeyLengthException e) {
            throw new IllegalStateException(e);
        }
    }

    public KeyCredentials getKeyCredentials() {
        return this.keyCredentials;
    }

    private static KeyParams keyParams() {
        KeyParams keyParams = new KeyParams();
        keyParams.setKeyAlogirithm("AES");
        keyParams.setKeyLength(256);
        return keyParams;
    }
}

