/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.encobject.service;

import java.io.IOException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import org.adorsys.encobject.domain.ContentMetaInfo;
import org.adorsys.encobject.domain.KeyCredentials;
import org.adorsys.encobject.domain.ObjectHandle;
import org.adorsys.encobject.params.KeyParams;
import org.adorsys.encobject.service.ContainerExistsException;
import org.adorsys.encobject.service.ContainerPersistence;
import org.adorsys.encobject.service.KeystorePersistence;
import org.adorsys.encobject.service.MissingKeyAlgorithmException;
import org.adorsys.encobject.service.MissingKeystoreAlgorithmException;
import org.adorsys.encobject.service.MissingKeystoreProviderException;
import org.adorsys.encobject.service.ObjectNotFoundException;
import org.adorsys.encobject.service.ObjectPersistence;
import org.adorsys.encobject.service.UnknownContainerException;
import org.adorsys.encobject.service.WrongKeyCredentialException;
import org.adorsys.encobject.service.WrongKeystoreCredentialException;
import org.adorsys.jjwk.selector.UnsupportedEncAlgorithmException;
import org.adorsys.jjwk.selector.UnsupportedKeyLengthException;
import org.adorsys.jkeygen.keystore.KeyStoreService;
import org.adorsys.jkeygen.keystore.SecretKeyData;
import org.adorsys.jkeygen.pwd.PasswordCallbackHandler;
import org.adorsys.jkeygen.secretkey.SecretKeyBuilder;

public class EncObjectService {
    private final KeystorePersistence keystorePersistence;
    private final ObjectPersistence objectPersistence;
    private final ContainerPersistence containerPersistence;

    public EncObjectService(KeystorePersistence keystorePersistence, ObjectPersistence objectPersistence, ContainerPersistence containerPersistence) {
        this.keystorePersistence = keystorePersistence;
        this.objectPersistence = objectPersistence;
        this.containerPersistence = containerPersistence;
    }

    public boolean containerExists(String container) {
        return this.containerPersistence.containerExists(container);
    }

    public void newContainer(String container) throws ContainerExistsException {
        this.containerPersistence.creteContainer(container);
    }

    public void newSecretKey(KeyCredentials keyCredentials, KeyParams keyParams) throws CertificateException, WrongKeystoreCredentialException, MissingKeystoreAlgorithmException, MissingKeystoreProviderException, MissingKeyAlgorithmException, IOException, UnknownContainerException, NoSuchAlgorithmException {
        KeyStore keyStore;
        PasswordCallbackHandler storePassHandler = new PasswordCallbackHandler(keyCredentials.getStorepass().toCharArray());
        PasswordCallbackHandler secretKeyPassHandler = new PasswordCallbackHandler(keyCredentials.getKeypass().toCharArray());
        SecretKey secretKey = new SecretKeyBuilder().withKeyAlg(keyParams.getKeyAlogirithm()).withKeyLength(Integer.valueOf(keyParams.getKeyLength())).build();
        SecretKeyData secretKeyData = new SecretKeyData(secretKey, keyCredentials.getKeyid(), (CallbackHandler)secretKeyPassHandler);
        try {
            keyStore = this.keystorePersistence.loadKeystore(keyCredentials.getHandle(), (CallbackHandler)storePassHandler);
        }
        catch (ObjectNotFoundException e) {
            keyStore = KeyStoreService.newKeyStore(null);
        }
        KeyStoreService.addToKeyStore((KeyStore)keyStore, (SecretKeyData)secretKeyData);
        this.keystorePersistence.saveKeyStore(keyStore, (CallbackHandler)storePassHandler, keyCredentials.getHandle());
    }

    public byte[] readObject(KeyCredentials keyCredentials, ObjectHandle objectHandle) throws ObjectNotFoundException, WrongKeystoreCredentialException, MissingKeystoreAlgorithmException, MissingKeystoreProviderException, MissingKeyAlgorithmException, CertificateException, IOException, WrongKeyCredentialException, UnknownContainerException {
        KeyStore keyStore = this.keystorePersistence.loadKeystore(keyCredentials.getHandle(), (CallbackHandler)new PasswordCallbackHandler(keyCredentials.getStorepass().toCharArray()));
        return this.objectPersistence.loadObject(objectHandle, keyStore, (CallbackHandler)new PasswordCallbackHandler(keyCredentials.getKeypass().toCharArray()));
    }

    public void writeObject(byte[] data, ContentMetaInfo metaIno, ObjectHandle handle, KeyCredentials keyCredentials) throws CertificateException, ObjectNotFoundException, WrongKeystoreCredentialException, MissingKeystoreAlgorithmException, MissingKeystoreProviderException, MissingKeyAlgorithmException, IOException, UnsupportedEncAlgorithmException, WrongKeyCredentialException, UnsupportedKeyLengthException, UnknownContainerException {
        KeyStore keyStore = this.keystorePersistence.loadKeystore(keyCredentials.getHandle(), (CallbackHandler)new PasswordCallbackHandler(keyCredentials.getStorepass().toCharArray()));
        this.objectPersistence.storeObject(data, metaIno, handle, keyStore, keyCredentials.getKeyid(), (CallbackHandler)new PasswordCallbackHandler(keyCredentials.getKeypass().toCharArray()), null);
    }

    public boolean hasKeystore(KeyCredentials keyCredentials) {
        return this.keystorePersistence.hasKeystore(keyCredentials.getHandle());
    }
}

