/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.encobject.params;

import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import java.security.Key;
import org.adorsys.encobject.params.EncryptionParams;
import org.adorsys.jjwk.selector.UnsupportedEncAlgorithmException;
import org.apache.commons.lang3.StringUtils;

public class EncParamSelector {
    public static EncryptionParams selectEncryptionParams(Key key) throws UnsupportedEncAlgorithmException {
        String algorithm = key.getAlgorithm();
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)"NONE", (CharSequence[])new CharSequence[]{algorithm})) {
            algorithm = "AES";
        }
        if (StringUtils.equalsAnyIgnoreCase((CharSequence)"AES", (CharSequence[])new CharSequence[]{algorithm})) {
            return new EncryptionParams.Builder().setEncAlgo(JWEAlgorithm.A256GCMKW).setEncMethod(EncryptionMethod.A256GCM).build();
        }
        throw new UnsupportedEncAlgorithmException(algorithm);
    }
}

