/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.encobject.service.impl.generator;

import java.security.KeyStore;
import java.util.Date;
import java.util.UUID;
import javax.security.auth.callback.CallbackHandler;
import org.adorsys.cryptoutils.exceptions.BaseExceptionHandler;
import org.adorsys.encobject.domain.ReadKeyPassword;
import org.adorsys.encobject.exceptions.KeyStoreConfigException;
import org.adorsys.encobject.service.api.generator.KeyPairGenerator;
import org.adorsys.encobject.service.api.generator.KeyStoreCreationConfig;
import org.adorsys.encobject.service.api.generator.SecretKeyGenerator;
import org.adorsys.encobject.service.impl.generator.UglyKeyStoreCache;
import org.adorsys.jkeygen.keystore.KeyEntry;
import org.adorsys.jkeygen.keystore.KeyPairData;
import org.adorsys.jkeygen.keystore.KeyStoreType;
import org.adorsys.jkeygen.keystore.KeystoreBuilder;
import org.adorsys.jkeygen.keystore.SecretKeyData;
import org.adorsys.jkeygen.pwd.PasswordCallbackHandler;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyStoreGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyStoreGenerator.class);
    private final KeyStoreType keyStoreType;
    private final String serverKeyPairAliasPrefix;
    private final KeyStoreCreationConfig config;
    private final ReadKeyPassword readKeyPassword;

    public KeyStoreGenerator(KeyStoreCreationConfig config, KeyStoreType keyStoreType, String serverKeyPairAliasPrefix, ReadKeyPassword readKeyPassword) {
        this.config = config;
        this.keyStoreType = keyStoreType;
        this.serverKeyPairAliasPrefix = "KEYSTORE-ID-0";
        this.readKeyPassword = readKeyPassword;
        LOGGER.debug("Keystore ID ignored " + serverKeyPairAliasPrefix);
    }

    public KeyStore generate() {
        KeyStore keyStore;
        if (this.config.getEncKeyNumber() == 0 && this.config.getSecretKeyNumber() == 0 && this.config.getSignKeyNumber() == 0) {
            throw new KeyStoreConfigException("Configuration of keystore must at least contain one key");
        }
        if (UglyKeyStoreCache.INSTANCE.isActive() && (keyStore = UglyKeyStoreCache.INSTANCE.getCachedKeyStoreFor(this.keyStoreType, this.serverKeyPairAliasPrefix, this.readKeyPassword, this.config)) != null) {
            LOGGER.debug("KeyStoreGeneration (milliseconds) DURATION WAS 0");
            return keyStore;
        }
        keyStore = null;
        Date startTime = new Date();
        try {
            KeyPairData signatureKeyPair;
            int i;
            String keyStoreID = this.serverKeyPairAliasPrefix;
            PasswordCallbackHandler readKeyHandler = new PasswordCallbackHandler(this.readKeyPassword.getValue().toCharArray());
            KeystoreBuilder keystoreBuilder = new KeystoreBuilder().withStoreType(this.keyStoreType);
            KeyPairGenerator encKeyPairGenerator = this.config.getEncKeyPairGenerator(keyStoreID);
            int numberOfEncKeyPairs = this.config.getEncKeyNumber();
            for (i = 0; i < numberOfEncKeyPairs; ++i) {
                signatureKeyPair = encKeyPairGenerator.generateEncryptionKey(this.serverKeyPairAliasPrefix + RandomStringUtils.randomAlphanumeric((int)5).toUpperCase(), (CallbackHandler)readKeyHandler);
                keystoreBuilder = keystoreBuilder.withKeyEntry((KeyEntry)signatureKeyPair);
            }
            KeyPairGenerator signKeyPairGenerator = this.config.getSignKeyPairGenerator(keyStoreID);
            int numberOfSignKeyPairs = this.config.getSignKeyNumber();
            for (i = 0; i < numberOfSignKeyPairs; ++i) {
                signatureKeyPair = signKeyPairGenerator.generateSignatureKey(this.serverKeyPairAliasPrefix + UUID.randomUUID().toString(), (CallbackHandler)readKeyHandler);
                keystoreBuilder = keystoreBuilder.withKeyEntry((KeyEntry)signatureKeyPair);
            }
            SecretKeyGenerator secretKeyGenerator = this.config.getSecretKeyGenerator(keyStoreID);
            int numberOfSecretKeys = this.config.getSecretKeyNumber();
            for (i = 0; i < numberOfSecretKeys; ++i) {
                SecretKeyData secretKeyData = secretKeyGenerator.generate(this.serverKeyPairAliasPrefix + RandomStringUtils.randomAlphanumeric((int)5).toUpperCase(), (CallbackHandler)readKeyHandler);
                keystoreBuilder = keystoreBuilder.withKeyEntry((KeyEntry)secretKeyData);
            }
            KeyStore keyStore2 = keyStore = keystoreBuilder.build();
            return keyStore2;
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
        finally {
            Date stopTime = new Date();
            long duration = stopTime.getTime() - startTime.getTime();
            LOGGER.debug("KeyStoreGeneration (milliseconds) DURATION WAS " + duration);
            if (UglyKeyStoreCache.INSTANCE.isActive()) {
                UglyKeyStoreCache.INSTANCE.cacheKeyStoreFor(keyStore, this.keyStoreType, this.serverKeyPairAliasPrefix, this.readKeyPassword, this.config);
            }
        }
    }
}

