/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.encobject.service.impl;

import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import javax.security.auth.callback.CallbackHandler;
import org.adorsys.cryptoutils.exceptions.BaseExceptionHandler;
import org.adorsys.encobject.service.api.KeySource;
import org.adorsys.encobject.types.KeyID;
import org.adorsys.jkeygen.keystore.PasswordCallbackUtils;

public class KeyStoreBasedSecretKeySourceImpl
implements KeySource {
    private KeyStore keyStore;
    private CallbackHandler keyPassHandler;

    public KeyStoreBasedSecretKeySourceImpl(KeyStore keyStore, CallbackHandler keyPassHandler) {
        this.keyStore = keyStore;
        this.keyPassHandler = keyPassHandler;
    }

    @Override
    public Key readKey(KeyID keyID) {
        return this.readKey(this.keyStore, keyID, this.keyPassHandler);
    }

    private Key readKey(KeyStore keyStore, KeyID keyID, CallbackHandler keyPassHandler) {
        try {
            return keyStore.getKey(keyID.getValue(), PasswordCallbackUtils.getPassword((CallbackHandler)keyPassHandler, (String)keyID.getValue()));
        }
        catch (KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }
}

