/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.encobject.service.impl;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.adorsys.cryptoutils.exceptions.BaseExceptionHandler;
import org.adorsys.encobject.domain.UserMetaData;
import org.adorsys.encobject.service.api.EncryptionStreamService;
import org.adorsys.encobject.service.api.KeySource;
import org.adorsys.encobject.service.impl.JWEncryptionServiceImpl;
import org.adorsys.encobject.types.KeyID;
import org.apache.commons.io.IOUtils;

public class JWEncryptionStreamServiceImpl
implements EncryptionStreamService {
    private JWEncryptionServiceImpl jwEncryptionService = new JWEncryptionServiceImpl();

    @Override
    public InputStream getEncryptedInputStream(UserMetaData userMetaData, InputStream inputStream, KeySource keySource, KeyID keyID, Boolean compress) {
        try {
            byte[] decrypted = IOUtils.toByteArray((InputStream)inputStream);
            byte[] encrypted = this.jwEncryptionService.encrypt(decrypted, keySource, keyID, compress);
            return new ByteArrayInputStream(encrypted);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public InputStream getDecryptedInputStream(UserMetaData userMetaData, InputStream inputStream, KeySource keySource, KeyID keyID) {
        try {
            byte[] encrypted = IOUtils.toByteArray((InputStream)inputStream);
            byte[] decrypted = this.jwEncryptionService.decrypt(encrypted, keySource, keyID);
            return new ByteArrayInputStream(decrypted);
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }
}

