/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.encobject.service.impl;

import com.nimbusds.jose.CompressionAlgorithm;
import com.nimbusds.jose.EncryptionMethod;
import com.nimbusds.jose.JWEAlgorithm;
import com.nimbusds.jose.JWEDecrypter;
import com.nimbusds.jose.JWEEncrypter;
import com.nimbusds.jose.JWEHeader;
import com.nimbusds.jose.JWEObject;
import com.nimbusds.jose.Payload;
import com.nimbusds.jose.crypto.factories.DefaultJWEDecrypterFactory;
import java.security.Key;
import org.adorsys.cryptoutils.exceptions.BaseException;
import org.adorsys.cryptoutils.exceptions.BaseExceptionHandler;
import org.adorsys.encobject.domain.ContentMetaInfo;
import org.adorsys.encobject.exceptions.ExtendedPersistenceException;
import org.adorsys.encobject.params.EncParamSelector;
import org.adorsys.encobject.params.EncryptionParams;
import org.adorsys.encobject.service.api.EncryptionService;
import org.adorsys.encobject.service.api.KeySource;
import org.adorsys.encobject.service.impl.ContentMetaInfoUtils;
import org.adorsys.encobject.types.EncryptionType;
import org.adorsys.encobject.types.KeyID;
import org.adorsys.encobject.types.PersistenceLayerContentMetaInfoUtil;
import org.adorsys.jjwk.selector.JWEEncryptedSelector;
import org.apache.commons.io.IOUtils;

public class JWEncryptionServiceImpl
implements EncryptionService {
    private DefaultJWEDecrypterFactory decrypterFactory = new DefaultJWEDecrypterFactory();

    @Override
    public byte[] encrypt(byte[] data, KeySource keySource, KeyID keyID, Boolean compress) {
        try {
            ContentMetaInfo metaInfo = new ContentMetaInfo();
            Key key = keySource.readKey(keyID);
            PersistenceLayerContentMetaInfoUtil.setKeyID(metaInfo, keyID);
            PersistenceLayerContentMetaInfoUtil.setEncryptionType(metaInfo, EncryptionType.JWE);
            EncryptionParams encParams = EncParamSelector.selectEncryptionParams(key);
            JWEHeader.Builder headerBuilder = new JWEHeader.Builder(encParams.getEncAlgo(), encParams.getEncMethod()).keyID(keyID.getValue());
            ContentMetaInfoUtils.metaInfo2Header(metaInfo, headerBuilder);
            if (compress != null && compress.booleanValue()) {
                headerBuilder = headerBuilder.compressionAlgorithm(CompressionAlgorithm.DEF);
            }
            JWEHeader header = headerBuilder.build();
            JWEEncrypter jweEncrypter = JWEEncryptedSelector.getEncrypter((Key)key, (JWEAlgorithm)encParams.getEncAlgo(), (EncryptionMethod)encParams.getEncMethod());
            JWEObject jweObject = new JWEObject(header, new Payload(data));
            jweObject.encrypt(jweEncrypter);
            String jweEncryptedObject = jweObject.serialize();
            byte[] bytesToStore = jweEncryptedObject.getBytes("UTF-8");
            return bytesToStore;
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }

    @Override
    public byte[] decrypt(byte[] jweEncryptedBytes, KeySource keySource, KeyID keyID) {
        try {
            String jweEncryptedObject = IOUtils.toString((byte[])jweEncryptedBytes, (String)"UTF-8");
            JWEObject jweObject = JWEObject.parse((String)jweEncryptedObject);
            ContentMetaInfo metaInfo = new ContentMetaInfo();
            ContentMetaInfoUtils.header2MetaInfo(jweObject.getHeader(), metaInfo);
            EncryptionType encryptionType = PersistenceLayerContentMetaInfoUtil.getEncryptionnType(metaInfo);
            if (!encryptionType.equals((Object)EncryptionType.JWE)) {
                throw new BaseException("Expected EncryptionType is " + (Object)((Object)EncryptionType.JWE) + " but was " + (Object)((Object)encryptionType));
            }
            KeyID keyID2 = PersistenceLayerContentMetaInfoUtil.getKeyID(metaInfo);
            KeyID keyID3 = new KeyID(jweObject.getHeader().getKeyID());
            if (!keyID.equals((Object)keyID2)) {
                throw new BaseException("die in der MetaInfo hinterlegte keyID " + (Object)((Object)keyID) + " passt nicht zu der im header hinterlegten KeyID " + (Object)((Object)keyID2));
            }
            if (!keyID2.equals((Object)keyID3)) {
                throw new BaseException("die in der MetaInfo hinterlegte keyID " + (Object)((Object)keyID2) + " passt nicht zu der im header hinterlegten KeyID " + (Object)((Object)keyID3));
            }
            Key key = keySource.readKey(keyID);
            if (key == null) {
                throw new ExtendedPersistenceException("can not read key with keyID " + (Object)((Object)keyID) + " from keySource of class " + keySource.getClass().getName());
            }
            JWEDecrypter decrypter = this.decrypterFactory.createJWEDecrypter(jweObject.getHeader(), key);
            jweObject.decrypt(decrypter);
            return jweObject.getPayload().toBytes();
        }
        catch (Exception e) {
            throw BaseExceptionHandler.handle((Throwable)e);
        }
    }
}

