/*
 * Decompiled with CFR 0.152.
 */
package org.adorsys.encobject.service.impl.generator;

import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import org.adorsys.cryptoutils.exceptions.BaseException;
import org.adorsys.encobject.domain.ReadKeyPassword;
import org.adorsys.encobject.service.api.generator.KeyStoreCreationConfig;
import org.adorsys.jkeygen.keystore.KeyStoreType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum UglyKeyStoreCache {
    INSTANCE;

    private static final Logger LOGGER;
    private static final String UGLY_KEYSTORE_CACHE = "UGLY_KEYSTORE_CACHE";
    Map<String, KeyStore> map = new HashMap<String, KeyStore>();

    private UglyKeyStoreCache() {
        if (this.isActive()) {
            Logger LOGGER = LoggerFactory.getLogger(UglyKeyStoreCache.class);
            LOGGER.warn("UGLY_KEYSTORE_CACHE CREATION");
        }
    }

    public boolean isActive() {
        return System.getProperty(UGLY_KEYSTORE_CACHE) != null;
    }

    public synchronized KeyStore getCachedKeyStoreFor(KeyStoreType keyStoreType, String serverKeyPairAliasPrefix, ReadKeyPassword readKeyPassword, KeyStoreCreationConfig config) {
        if (!this.isActive()) {
            throw new BaseException("Programming error. Must not be called when not active");
        }
        String key = this.getMapKeyFor(keyStoreType, serverKeyPairAliasPrefix, readKeyPassword, config);
        if (this.map.containsKey(key)) {
            return this.map.get(key);
        }
        LOGGER.debug("unknown key:" + key);
        this.map.keySet().forEach(knownkey -> LOGGER.debug("known key:" + knownkey));
        return null;
    }

    public synchronized KeyStore cacheKeyStoreFor(KeyStore keyStore, KeyStoreType keyStoreType, String serverKeyPairAliasPrefix, ReadKeyPassword readKeyPassword, KeyStoreCreationConfig config) {
        if (!this.isActive()) {
            throw new BaseException("Programming error. Must not be called when not active");
        }
        String key = this.getMapKeyFor(keyStoreType, serverKeyPairAliasPrefix, readKeyPassword, config);
        if (this.map.containsKey(key)) {
            throw new BaseException("this key is already known. " + key);
        }
        return this.map.put(key, keyStore);
    }

    private String getMapKeyFor(KeyStoreType keyStoreType, String serverKeyPairAliasPrefix, ReadKeyPassword readKeyPassword, KeyStoreCreationConfig config) {
        String key = keyStoreType.getValue() + "+" + serverKeyPairAliasPrefix + "+" + readKeyPassword.getValue() + "+" + config.getEncKeyNumber() + "." + config.getSecretKeyNumber() + "." + config.getSignKeyNumber();
        return key;
    }

    static {
        LOGGER = LoggerFactory.getLogger(UglyKeyStoreCache.class);
    }
}

